<?php
// admin/add_exam.php - Updated Code (Add New Exam with Active Exam Check)

session_start();
include_once('../config/db.php');
include_once('includes/header.php');

$conn = getDBConnection();
$message = '';
$error = '';

// Check if form is submitted
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['add_exam'])) {
    
    $exam_name = $_POST['exam_name'];
    $session_id = $_POST['session_id']; 
    $start_date = $_POST['start_date'];
    $end_date = $_POST['end_date'];
    $status = $_POST['status']; 

    if (empty($exam_name) || empty($session_id) || empty($start_date)) {
        $error = "Please fill all required fields (Name, Session, Start Date).";
    } else {
        // Check if there's already an active exam
        $check_active_sql = "SELECT id, name FROM exams WHERE status = 'active' LIMIT 1";
        $active_exam_result = $conn->query($check_active_sql);
        
        if ($active_exam_result->num_rows > 0) {
            $active_exam = $active_exam_result->fetch_assoc();
            $error = "Cannot add new exam. '{$active_exam['name']}' is currently active. Please complete the active exam first.";
        } else {
            $stmt = $conn->prepare("INSERT INTO exams (name, session_id, start_date, end_date, status) VALUES (?, ?, ?, ?, ?)");
            $stmt->bind_param("sisss", $exam_name, $session_id, $start_date, $end_date, $status);
            
            if ($stmt->execute()) {
                $message = "Exam '{$exam_name}' successfully added!";
            } else {
                $error = "Error adding exam: " . $stmt->error;
            }
            $stmt->close();
        }
    }
}

// Fetch active session (where is_active = 1)
$active_session_result = $conn->query("SELECT id, name FROM academic_sessions WHERE is_active = 1 LIMIT 1");
$active_session = $active_session_result->fetch_assoc();

// Check for active exam to show warning
$active_exam_result = $conn->query("SELECT id, name, end_date FROM exams WHERE status = 'active' LIMIT 1");
$active_exam = $active_exam_result->fetch_assoc();

$conn->close();
?>

<h2 class="mb-4">Add New Exam / Test</h2>

<?php if ($message): ?>
    <div class="alert alert-success"><?php echo htmlspecialchars($message); ?></div>
<?php endif; ?>

<?php if ($error): ?>
    <div class="alert alert-danger"><?php echo htmlspecialchars($error); ?></div>
<?php endif; ?>

<?php if ($active_exam): ?>
    <div class="alert alert-warning">
        <strong>Note:</strong> '<?php echo htmlspecialchars($active_exam['name']); ?>' is currently active. 
        <?php if ($active_exam['end_date']): ?>
            It will automatically complete on <?php echo date('d M, Y', strtotime($active_exam['end_date'])); ?>.
        <?php else: ?>
            It has no end date set. Please update its status manually.
        <?php endif; ?>
        You can add a new exam only after this exam is completed.
    </div>
<?php endif; ?>

<div class="card p-4">
    <form action="add_exam.php" method="POST">
        <input type="hidden" name="add_exam" value="1">
        
        <div class="form-group">
            <label for="exam_name">Exam Name <span class="text-danger">*</span></label>
            <input type="text" name="exam_name" id="exam_name" class="form-control" placeholder="E.g., Mid-Term Exam, Final Assessment" 
                   <?php echo $active_exam ? 'disabled' : 'required'; ?>>
            <?php if ($active_exam): ?>
                <small class="form-text text-muted">Cannot add new exam while an exam is active</small>
            <?php endif; ?>
        </div>

        <div class="form-row">
            <div class="form-group col-md-6">
                <label for="session_id">Academic Session <span class="text-danger">*</span></label>
                <?php if (!empty($active_session)): ?>
                    <select name="session_id" id="session_id" class="form-control" <?php echo $active_exam ? 'disabled' : ''; ?>>
                        <option value="<?php echo $active_session['id']; ?>" selected>
                            <?php echo htmlspecialchars($active_session['name']); ?> (Active Session)
                        </option>
                    </select>
                    <input type="hidden" name="session_id" value="<?php echo $active_session['id']; ?>">
                    <small class="form-text text-muted">Active academic session is automatically selected</small>
                <?php else: ?>
                    <div class="alert alert-warning p-2">
                        No active academic session found.
                    </div>
                    <select name="session_id" id="session_id" class="form-control" <?php echo $active_exam ? 'disabled' : 'required'; ?>>
                        <option value="">-- Select Session --</option>
                        <?php 
                        // Fetch all sessions as fallback
                        $conn = getDBConnection();
                        $all_sessions = $conn->query("SELECT id, name FROM academic_sessions ORDER BY id DESC");
                        while($session = $all_sessions->fetch_assoc()): ?>
                            <option value="<?php echo $session['id']; ?>">
                                <?php echo htmlspecialchars($session['name']); ?>
                            </option>
                        <?php endwhile; 
                        $conn->close();
                        ?>
                    </select>
                <?php endif; ?>
            </div>
            <div class="form-group col-md-6">
                <label for="status">Exam Status</label>
                <select name="status" id="status" class="form-control" <?php echo $active_exam ? 'disabled' : ''; ?>>
                    <option value="upcoming">Upcoming</option>
                    <option value="active">Active</option>
                    <option value="completed">Completed</option>
                </select>
                <?php if ($active_exam): ?>
                    <small class="form-text text-muted">Status selection disabled while an exam is active</small>
                <?php endif; ?>
            </div>
        </div>

        <div class="form-row">
            <div class="form-group col-md-6">
                <label for="start_date">Start Date <span class="text-danger">*</span></label>
                <input type="date" name="start_date" id="start_date" class="form-control" 
                       <?php echo $active_exam ? 'disabled' : 'required'; ?>>
            </div>
            <div class="form-group col-md-6">
                <label for="end_date">End Date</label>
                <input type="date" name="end_date" id="end_date" class="form-control" 
                       <?php echo $active_exam ? 'disabled' : ''; ?>>
            </div>
        </div>

        <button type="submit" class="btn btn-primary" <?php echo $active_exam ? 'disabled' : ''; ?>>
            <i class="fas fa-plus-circle"></i> Add Exam
        </button>
        
        <?php if ($active_exam): ?>
            <div class="alert alert-info mt-3">
                <strong>Information:</strong> You cannot add a new exam while '<?php echo htmlspecialchars($active_exam['name']); ?>' is active. 
                Please wait until it's completed or manually change its status to completed.
            </div>
        <?php elseif (empty($active_session)): ?>
            <div class="alert alert-warning mt-3">
                <strong>Note:</strong> No active academic session found. Please select a session manually or set a session as active in Academic Sessions.
            </div>
        <?php endif; ?>
    </form>
</div>

<?php
include_once('includes/footer.php');
?>