<?php 
// FILE: admin/award_list_print.php - FINAL TEMPLATE CODE (Standardized Keys & Logo Fix)

if (!isset($report_data) || !isset($subject_headers) || !isset($class_details) || !isset($settings)) {
    die("<h1>Error:</h1> Data not fully prepared. Missing data variables."); 
}

$className = htmlspecialchars($class_details['class_name'] ?? 'N/A');
$sectionName = htmlspecialchars($class_details['section_name'] ?? 'N/A');
$termName = htmlspecialchars($class_details['term_name'] ?? 'N/A');

// School Details: Now guaranteed to use these standardized keys
$schoolName = htmlspecialchars($settings['institute_name'] ?? 'YOUR SCHOOL NAME HERE');
$schoolAddress = htmlspecialchars($settings['institute_address'] ?? 'Address Not Set');
$schoolPhone = htmlspecialchars($settings['institute_phone'] ?? 'Phone Not Set');

// --- Logo Path Fix (Handles 'uploads/school_logo/...|NULL') ---
$rawLogoPath = $settings['institute_logo_path'] ?? '';
$logoPathParts = explode('|', $rawLogoPath);
$cleanLogoPath = trim($logoPathParts[0]);
// Set the final URL with prefix
$logo_url = !empty($cleanLogoPath) ? '../' . $cleanLogoPath : '../uploads/default.png';
// --- End Logo Path Fix ---


// Calculate Subject Column Width dynamically
// Total Columns (S.No, Roll No, Student Name, Father Name, Subjects)
$totalFixedCols = 4; // S.No (1) + Roll No (1) + Student Name (1) + Father Name (1)
// Fixed width for the 4 fixed columns (3% S.No + 7% Roll No + 15% Student Name + 15% Father Name = 40%)
$totalFixedPercent = 3 + 7 + 15 + 15; 
$subjectColWidth = (100 - $totalFixedPercent) / max(1, count($subject_headers)); 
$totalColumns = $totalFixedCols + count($subject_headers);
?>

<!DOCTYPE html>
<html>
<head>
    <title>Award List Template: <?php echo $className . '-' . $sectionName; ?></title>
    <style>
        body { font-family: Arial, sans-serif; font-size: 10pt; margin: 0; padding: 0; }
        .container { width: 98%; margin: auto; padding-top: 20px; }
        
        /* HEADER STYLING for Logo, Name, Address, Phone */
        .header { text-align: center; margin-bottom: 20px; border-bottom: 2px solid #000; padding-bottom: 10px; display: flex; align-items: center; }
        .logo-container { width: 15%; text-align: center; } 
        .logo { max-width: 80px; max-height: 80px; }
        .info-container { width: 70%; text-align: center; } 
        .school-name { font-size: 18pt; font-weight: bold; margin: 0; }
        .contact-info { font-size: 10pt; margin-top: 2px; }
        .report-title { font-size: 14pt; margin: 5px 0; }
        
        /* DETAILS BAR & TABLE styles */
        .details-bar { display: flex; justify-content: space-between; margin-bottom: 15px; font-weight: bold; }
        .details-bar span { display: inline-block; margin-right: 30px; }
        table { width: 100%; border-collapse: collapse; margin-top: 15px; }
        th, td { border: 1px solid #000; padding: 4px 2px; text-align: center; height: 25px; font-size: 9pt; }
        th { background-color: #f2f2f2; font-weight: bold; white-space: nowrap; }
        
        /* COLUMN WIDTHS ADJUSTED */
        .sno-col { width: 3%; }
        .rollno-col { width: 7%; } /* ✅ NEW: Roll No. Column */
        .student-col { text-align: center; width: 15%; white-space: normal; }
        .father-col { text-align: center; width: 15%; white-space: normal; }
        .subject-col { width: <?php echo $subjectColWidth; ?>%; } 
        
        @media print { body { margin: 0.5cm; } .no-print { display: none; } }
    </style>
</head>
<body>

<div class="container">
    
    <div class="header">
        <div class="logo-container">
            <img src="<?php echo htmlspecialchars($logo_url); ?>" alt="School Logo" class="logo"
                 onerror="this.onerror=null;this.src='../uploads/default.png';">
        </div>
        <div class="info-container">
            <p class="school-name"><?php echo $schoolName; ?></p>
            <p class="contact-info">
                <?php echo $schoolAddress; ?><br>
                <?php echo $schoolPhone; ?>
            </p>
            <h2 class="report-title">AWARD LIST / MARKS TEMPLATE (TERM: <?php echo strtoupper($termName); ?>)</h2>
        </div>
    </div>

    <div class="details-bar">
        <span>**Class:** <?php echo $className; ?></span>
        <span>**Section:** <?php echo $sectionName; ?></span>
        <span>**Term:** <?php echo $termName; ?></span>
        <span>**Date:** <?php echo date('d-M-Y'); ?></span>
    </div>

    <table>
        <thead>
            <tr>
                <th class="sno-col">S.No</th>
                <th class="rollno-col">Roll No.</th>
				<th class="student-col">Student Name</th>
                <th class="father-col">Father Name</th>
                
                <?php 
                if (!empty($subject_headers)) {
                    foreach ($subject_headers as $subject_name): ?>
                        <th class="subject-col"><?php echo htmlspecialchars($subject_name); ?></th>
                    <?php endforeach; 
                } else {
                    echo '<th colspan="' . ($totalColumns - 4) . '">Error: No Subjects Allocated</th>';
                }
                ?>
            </tr>
        </thead>
        <tbody>
            <?php $serial_no = 1; ?>
            <?php 
            if (empty($report_data)): ?>
                <tr>
                    <td colspan="<?php echo $totalColumns; ?>">No active students found for this Class/Section.</td>
                </tr>
            <?php endif; ?>
            
            <?php 
            // Loop through each student
            foreach ($report_data as $student): ?>
                <tr>
                    <td><?php echo $serial_no++; ?></td>
                    <td class="rollno-col"><?php echo htmlspecialchars($student['roll_no'] ?? 'N/A'); ?></td> <td class="student-col"><?php echo htmlspecialchars($student['student_name']); ?></td>
                    <td class="father-col"><?php echo htmlspecialchars($student['father_name']); ?></td>
                    
                    <?php 
                    if (!empty($subject_headers)) {
                        foreach (array_keys($subject_headers) as $sub_id): 
                            // Yahan Marks show karne ka logic aayega agar Award List mein marks hote
                            // Abhi sirf blank cell show kar raha hai, jaisa aapke code mein tha.
                            ?>
                            <td class="subject-col">
                                &nbsp; 
                            </td>
                        <?php endforeach;
                    }
                    ?>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>

    <p style="margin-top: 30px;" class="no-print">
        <button onclick="window.print()" class="btn btn-success">Print Award List Template</button>
    </p>

</div>
</body>
</html>