 <?php
include_once('includes/header.php'); 
include_once('includes/sidebar.php'); 

if ($_SESSION['user_role_id'] != 1) { // Only Admin
    header('Location: dashboard.php?err=' . urlencode('Aapke paas is page ka access nahi hai.'));
    exit;
}

$message = $_GET['msg'] ?? '';
$error = $_GET['err'] ?? '';
?>

<h1 class="mb-4">Database Backup & Maintenance 💾</h1>

<?php if ($message): ?>
    <div class="alert alert-success"><?php echo htmlspecialchars($message); ?></div>
<?php endif; ?>
<?php if ($error): ?>
    <div class="alert alert-danger"><?php echo htmlspecialchars($error); ?></div>
<?php endif; ?>

<div class="card p-4">
    <h4 class="card-title">Create New Backup</h4>
    <p class="text-info">Database ke tamam data (students, fees, marks, wagaira) ka SQL backup file banayega.</p>
    
    <form action="system_process.php" method="POST">
        <input type="hidden" name="action" value="create_backup">
        <button type="submit" class="btn btn-danger btn-lg mt-3" onclick="this.disabled=true; this.innerText='Backup in Progress...'; return true;">
            <i class="fas fa-database"></i> Generate Database Backup
        </button>
    </form>
    
    <h4 class="mt-5">Recent Backups</h4>
    <p>Backup files `../storage/backups/` folder mein save hoti hain.</p>
    </div>

<?php
include_once('includes/footer.php'); 
?>