<?php
// admin/class_result_sheet.php - Selection Page for Class Wise Result Sheet

session_start();
ob_start(); 
include_once('../config/db.php');
// Assuming your header includes database connection details and checks
include_once('includes/header.php'); 

$conn = getDBConnection();

$message = $_GET['msg'] ?? '';
$error = $_GET['err'] ?? '';

// Current Session ID
$current_session_id = $settings['academic.active_session_id'] ?? 1;

// --- 1. Fetch Sessions ---
$sessions_result = $conn->query("SELECT id, name FROM academic_sessions ORDER BY id DESC");
$sessions = $sessions_result->fetch_all(MYSQLI_ASSOC);

// --- 2. Fetch Exams (Terms) for current session ---
$exams_result = $conn->query("SELECT id, name FROM exams WHERE session_id = {$current_session_id} ORDER BY id DESC");
$exams = $exams_result->fetch_all(MYSQLI_ASSOC);

// --- 3. Fetch Classes ---
$classes_result = $conn->query("SELECT id, name FROM academic_classes ORDER BY order_no ASC");
$classes = $classes_result->fetch_all(MYSQLI_ASSOC);

// --- 4. Fetch Sections ---
$sections_result = $conn->query("SELECT id, name FROM academic_sections ORDER BY name ASC");
$sections = $sections_result->fetch_all(MYSQLI_ASSOC);

if (isset($conn) && is_object($conn)) {
    $conn->close();
}
?>

<div class="container-fluid">
    <div class="row">
        <main role="main" class="col-md-9 ml-sm-auto col-lg-10 px-4">
            <h1 class="mt-4">📊 Class Wise Result Sheet</h1>
            <p class="mb-4">Select the **Session**, **Exam**, **Class**, and **Section** to generate the complete result sheet for the entire class on a single page.</p>

            <?php if ($message): ?>
                <div class="alert alert-success"><?php echo htmlspecialchars($message); ?></div>
            <?php endif; ?>
            <?php if ($error): ?>
                <div class="alert alert-danger"><?php echo htmlspecialchars($error); ?></div>
            <?php endif; ?>

            <div class="card p-4 mb-4">
                <form action="class_result_sheet_generate.php" method="GET" target="_blank">
                    <div class="form-row">
                        <div class="col-md-3 mb-3">
                            <label for="session_id">Select Session</label>
                            <select class="form-control" id="session_id" name="session_id" required>
                                <option value="">--- Select Session ---</option>
                                <?php foreach ($sessions as $session): ?>
                                    <option value="<?php echo $session['id']; ?>" <?php echo $current_session_id == $session['id'] ? 'selected' : ''; ?>>
                                        <?php echo htmlspecialchars($session['name']); ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="col-md-3 mb-3">
                            <label for="exam_id">Select Exam/Term</label>
                            <select class="form-control" id="exam_id" name="exam_id" required>
                                <option value="">--- Select Exam ---</option>
                                <?php foreach ($exams as $exam): ?>
                                    <option value="<?php echo $exam['id']; ?>">
                                        <?php echo htmlspecialchars($exam['name']); ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="col-md-3 mb-3">
                            <label for="class_id">Select Class</label>
                            <select class="form-control" id="class_id" name="class_id" required>
                                <option value="">--- Select Class ---</option>
                                <?php foreach ($classes as $class): ?>
                                    <option value="<?php echo $class['id']; ?>">
                                        <?php echo htmlspecialchars($class['name']); ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="col-md-3 mb-3">
                            <label for="section_id">Select Section</label>
                            <select class="form-control" id="section_id" name="section_id" required>
                                <option value="">--- Select Section ---</option>
                                <?php foreach ($sections as $section): ?>
                                    <option value="<?php echo $section['id']; ?>">
                                        <?php echo htmlspecialchars($section['name']); ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                            <small class="form-text text-muted">Ensure students are enrolled in this section.</small>
                        </div>
                    </div>
                    
                    <button type="submit" class="btn btn-primary btn-lg mt-3">
                        <i class="fas fa-print"></i> Generate Result Sheet
                    </button>
                </form>
            </div>
        </main>
    </div>
</div>

<?php
// Assuming your footer.php closes main tags and body
include_once('includes/footer.php'); 
?>