<?php 
// FILE: admin/class_result_sheet_print.php - Class Wise Result Card Template (Logo FIX)

if (!isset($report_data) || !isset($subject_details) || !isset($class_details) || !isset($settings) || !isset($termName)) {
    die("<h1>Error:</h1> Data not fully prepared. Missing data variables."); 
}

// --- NEW FUNCTION: To add 1st, 2nd, 3rd Suffix --- (Same as before)
if (!function_exists('getNumberSuffix')) {
    function getNumberSuffix($num) {
        if (!is_numeric($num) || $num <= 0) {
            return $num; 
        }
        if ($num % 100 >= 11 && $num % 100 <= 13) {
            return $num . 'th';
        }
        switch ($num % 10) {
            case 1:  return $num . 'st';
            case 2:  return $num . 'nd';
            case 3:  return $num . 'rd';
            default: return $num . 'th';
        }
    }
}
// --- END NEW FUNCTION ---

$className = htmlspecialchars($class_details['class_name'] ?? 'N/A');
$sectionName = htmlspecialchars($class_details['section_name'] ?? 'N/A');
$termName = htmlspecialchars($termName ?? 'N/A');

$schoolName = htmlspecialchars($settings['institute_name'] ?? 'YOUR SCHOOL NAME HERE');
$schoolAddress = htmlspecialchars($settings['institute_address'] ?? 'Address Not Set');
$schoolPhone = htmlspecialchars($settings['institute_phone'] ?? 'Phone Not Set');

// ✅ FIX: settings array mein 'institute.logo_path' use kiya gaya tha. 
// generate.php file se 'institute_logo_path' ki value $settings array mein aati hai.
$rawLogoPath = $settings['institute_logo_path'] ?? ''; 
$logoPathParts = explode('|', $rawLogoPath);
$cleanLogoPath = trim($logoPathParts[0]);

// ✅ FIX: Path ko theek kiya gaya hai. Kyunki yeh file admin/ mein hai, 
// to yeh 'uploads/' folder ke liye '..' use karegi.
$logo_url = !empty($cleanLogoPath) ? '../' . $cleanLogoPath : '../uploads/default.png';

// --- Column Width Calculation (Same as previous) ---
$totalFixedPercent = 3 + 5 + 12 + 12; 
$totalFinalPercent = 7 + 7 + 7 + 7;
$remainingWidth = 100 - ($totalFixedPercent + $totalFinalPercent);
$subjectColCount = count($subject_details);
$subjectColWidth = $remainingWidth / max(1, $subjectColCount); 
$totalColumns = 4 + $subjectColCount + 4;
?>

<!DOCTYPE html>
<html>
<head>
    <title>Class Result Sheet: <?php echo $className . '-' . $sectionName; ?></title>
    <style>
        body { font-family: Arial, sans-serif; font-size: 8pt; margin: 0; padding: 0; }
        .container { width: 98%; margin: auto; padding-top: 10px; }
        
        /* HEADER STYLING */
        .header { text-align: center; margin-bottom: 10px; border-bottom: 2px solid #000; padding-bottom: 5px; display: flex; align-items: center; }
        .logo-container { width: 10%; text-align: center; } 
        .logo { max-width: 60px; max-height: 60px; }
        .info-container { width: 80%; text-align: center; } 
        .school-name { font-size: 14pt; font-weight: bold; margin: 0; }
        .contact-info { font-size: 8pt; margin-top: 2px; }
        .report-title { font-size: 12pt; margin: 5px 0; font-weight: bold; }
        
        /* DETAILS BAR & TABLE styles */
        .details-bar { display: flex; justify-content: space-between; margin-bottom: 10px; font-weight: bold; font-size: 9pt; }
        .details-bar span { display: inline-block; margin-right: 20px; }
        table { width: 100%; border-collapse: collapse; margin-top: 10px; table-layout: fixed; }
        th, td { border: 1px solid #000; padding: 1px 1px; text-align: center; height: 16px; font-size: 8pt; vertical-align: middle; } 
        th { background-color: #f2f2f2; font-weight: bold; white-space: nowrap; }
        
        /* COLUMN WIDTHS (Same as previous) */
        .sno-col { width: 3%; }
        .rollno-col { width: 5%; } 
        .student-col { width: 12%; } 
        .father-col { width: 12%; } 
        .subject-col { width: <?php echo $subjectColWidth; ?>%; } 
        .total-col { width: 7%; font-weight: bold; }
        .position-col { width: 7%; font-weight: bold; }
        .status-col { width: 7%; font-weight: bold; }
        .remarks-col { width: 7%; }

        /* Highlight Classes */
        .pass { background-color: #d4edda; color: #155724; }
        .fail { background-color: #f8d7da; color: #721c24; }
        .absent { background-color: #fff3cd; color: #856404; }
        
        /* --- LANDSCAPE PRINT CSS --- */
        @page {
            size: A4 landscape; 
            margin: 0.5cm;
        }

        @media print { 
            body { margin: 0.5cm; } 
            .no-print { display: none; } 
            table { page-break-after: auto; }
            tr, td, th { page-break-inside: avoid; }
        }
    </style>
</head>
<body>

<div class="container">
    
    <div class="header">
        <div class="logo-container">
            <img src="<?php echo htmlspecialchars($logo_url); ?>" alt="School Logo" class="logo"
                 onerror="this.onerror=null;this.src='../uploads/default.png';">
        </div>
        <div class="info-container">
            <p class="school-name"><?php echo $schoolName; ?></p>
            <p class="contact-info">
                <?php echo $schoolAddress; ?><br>
                <?php echo $schoolPhone; ?>
            </p>
            <h2 class="report-title">CLASS RESULT SHEET (EXAM: <?php echo strtoupper($termName); ?>)</h2>
        </div>
    </div>

    <div class="details-bar">
        <span>**Class:** <?php echo $className; ?></span>
        <span>**Section:** <?php echo $sectionName; ?></span>
        <span>**Exam:** <?php echo $termName; ?></span>
        <span>**Date:** <?php echo date('d-M-Y'); ?></span>
    </div>

    <table>
        <thead>
            <tr>
                <th class="sno-col">S.No</th>
                <th class="rollno-col">Roll No.</th> 
                <th class="student-col">Student Name</th>
                <th class="father-col">Father Name</th>
                
                <?php 
                if (!empty($subject_details)) {
                    foreach ($subject_details as $subject_id => $subject): ?>
                        <th class="subject-col">
                            <?php echo htmlspecialchars($subject['name']); ?><br>
                            <span style="font-weight: normal; font-size: 7pt;">(Total: <?php echo $subject['total_marks']; ?>)</span>
                        </th>
                    <?php endforeach; 
                } else {
                    echo '<th colspan="' . max(1, $totalColumns - 4) . '">Error: No Subjects Allocated</th>';
                }
                ?>
                <th class="total-col">Max Marks</th>
                <th class="total-col">Obtained Marks</th>
                <th class="position-col">Position</th> 
                <th class="status-col">% & Status</th>
                <th class="remarks-col">Remarks</th> 
            </tr>
        </thead>
        <tbody>
            <?php $serial_no = 1; ?>
            <?php 
            if (empty($report_data)): ?>
                <tr>
                    <td colspan="<?php echo $totalColumns; ?>">No active students found for this Class/Section.</td>
                </tr>
            <?php endif; ?>
            
            <?php 
            foreach ($report_data as $student): ?>
                <tr>
                    <td><?php echo $serial_no++; ?></td>
                    <td><?php echo htmlspecialchars($student['roll_no'] ?? 'N/A'); ?></td>
                    <td class="student-col"><?php echo htmlspecialchars($student['student_name']); ?></td>
                    <td class="father-col"><?php echo htmlspecialchars($student['father_name']); ?></td>
                    
                    <?php 
                    if (!empty($subject_details)) {
                        foreach (array_keys($subject_details) as $subject_id): 
                            $marks_data = $student['subject_marks'][$subject_id] ?? ['obtained' => 'N/A', 'total' => 'N/A', 'status' => 'N/A'];
                            $status_class = '';
                            if ($marks_data['status'] === 'Fail') $status_class = 'fail';
                            if ($marks_data['status'] === 'Absent') $status_class = 'absent';
                            ?>
                            <td class="subject-col <?php echo $status_class; ?>">
                                <?php echo $marks_data['obtained']; ?>/<?php echo $marks_data['total']; ?>
                            </td>
                        <?php endforeach;
                    }
                    ?>
                    
                    <td class="total-col"><?php echo $student['total_max_marks']; ?></td>
                    <td class="total-col"><?php echo $student['total_obtained_marks']; ?></td>
                    <td class="position-col">
                        <?php echo getNumberSuffix($student['position']); ?> 
                    </td>
                    <td class="status-col <?php echo ($student['final_status'] === 'PASS' ? 'pass' : ($student['final_status'] === 'FAIL' ? 'fail' : '')); ?>">
                        <?php echo $student['percentage']; ?>%<br>
                        <span style="font-size: 8pt;"><?php echo $student['final_status']; ?></span>
                    </td>
                    <td class="remarks-col"></td> </tr>
            <?php endforeach; ?>
        </tbody>
    </table>

    <p style="margin-top: 30px;" class="no-print">
        <button onclick="window.print()" class="btn btn-success">Print Class Result Sheet</button>
    </p>

</div>
</body>
</html>