<?php
// admin/dashboard.php - Ultra Modern Professional Dashboard with Real Charts

// Header file include karein. Yeh file session, authentication, aur connection ko handle karti hai.
include('includes/header.php');

// --- Dashboard Data Fetching START ---
$conn = getDBConnection();

// Total Students ka count (students table se)
$total_students_result = $conn->query("SELECT COUNT(id) FROM students WHERE status='active'");
$total_students = $total_students_result ? ($total_students_result->fetch_row()[0] ?? 0) : 0;

// Total Teachers ka count (teachers table se)  
$total_teachers_result = $conn->query("SELECT COUNT(id) FROM teachers WHERE status='active'");
$total_teachers = $total_teachers_result ? ($total_teachers_result->fetch_row()[0] ?? 0) : 0;

// Total Classes ka count (academic_classes table se)
$total_classes_result = $conn->query("SELECT COUNT(id) FROM academic_classes");
$total_classes = $total_classes_result ? ($total_classes_result->fetch_row()[0] ?? 0) : 0;

// Fees collected - dummy value (original code ke hisaab se)
$fees_collected = 0;

// Generate sample data for charts
$months = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun'];
$student_growth = [120, 135, 148, 165, 182, $total_students];

// Class distribution sample data
$class_distribution = [
    ['class' => 'Class 1', 'students' => 25],
    ['class' => 'Class 2', 'students' => 30],
    ['class' => 'Class 3', 'students' => 28],
    ['class' => 'Class 4', 'students' => 32],
    ['class' => 'Class 5', 'students' => 27],
    ['class' => 'Class 6', 'students' => 29]
];

// Recent activities sample data
$recent_activities = [
    ['type' => 'student', 'activity' => 'New admission: Ali Raza', 'time' => '2 hours ago'],
    ['type' => 'fee', 'activity' => 'Fee payment: ₹2,500', 'time' => '4 hours ago'],
    ['type' => 'student', 'activity' => 'New admission: Sara Khan', 'time' => '1 day ago'],
    ['type' => 'attendance', 'activity' => 'Attendance marked for Class 5', 'time' => '1 day ago'],
    ['type' => 'fee', 'activity' => 'Fee payment: ₹3,000', 'time' => '2 days ago']
];

// Agar zaroorat ho to result objects ko free kar dein
if (isset($total_students_result) && is_object($total_students_result)) $total_students_result->free();
if (isset($total_teachers_result) && is_object($total_teachers_result)) $total_teachers_result->free();
if (isset($total_classes_result) && is_object($total_classes_result)) $total_classes_result->free();

// --- Dashboard Data Fetching END ---

?>

<style>
    /* Ultra Modern Dashboard Styles with Glass Morphism */
    :root {
        --primary-gradient: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        --secondary-gradient: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
        --success-gradient: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
        --warning-gradient: linear-gradient(135deg, #43e97b 0%, #38f9d7 100%);
        --info-gradient: linear-gradient(135deg, #fa709a 0%, #fee140 100%);
        --dark-gradient: linear-gradient(135deg, #4c4177 0%, #2a5470 100%);
    }
    
    body {
        background: #f8fafc;
        overflow-x: hidden;
    }
    
    .dashboard-header {
        background: var(--primary-gradient);
        color: white;
        padding: 35px 0 25px;
        margin-bottom: 25px;
        border-radius: 0 0 20px 20px;
        box-shadow: 0 8px 25px rgba(102, 126, 234, 0.3);
        position: relative;
        overflow: hidden;
    }
    
    .dashboard-header::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1000 100" preserveAspectRatio="none"><path d="M0,50 Q250,0 500,50 T1000,50 L1000,100 L0,100 Z" fill="rgba(255,255,255,0.1)"/></svg>');
        background-size: 100% auto;
        background-position: bottom;
        background-repeat: no-repeat;
    }
    
    .main-container {
        padding: 0 15px 25px;
        background: #f8fafc;
        min-height: calc(100vh - 76px);
        max-width: 100%;
        overflow-x: hidden;
    }
    
    .stats-section {
        margin-bottom: 25px;
    }
    
    .stat-card {
        background: rgba(255, 255, 255, 0.95);
        backdrop-filter: blur(20px);
        border-radius: 16px;
        padding: 25px 20px;
        box-shadow: 
            0 8px 20px rgba(0, 0, 0, 0.1),
            0 2px 8px rgba(0, 0, 0, 0.05);
        border: 1px solid rgba(255, 255, 255, 0.3);
        transition: all 0.3s cubic-bezier(0.175, 0.885, 0.32, 1.275);
        height: 100%;
        position: relative;
        overflow: hidden;
        margin-bottom: 15px;
    }
    
    .stat-card::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        height: 4px;
        background: var(--card-gradient);
        border-radius: 16px 16px 0 0;
    }
    
    .stat-card:hover {
        transform: translateY(-5px);
        box-shadow: 
            0 15px 30px rgba(0, 0, 0, 0.15),
            0 5px 15px rgba(0, 0, 0, 0.1);
    }
    
    .stat-card.students { --card-gradient: var(--primary-gradient); }
    .stat-card.teachers { --card-gradient: var(--success-gradient); }
    .stat-card.classes { --card-gradient: var(--info-gradient); }
    .stat-card.fees { --card-gradient: var(--warning-gradient); }
    
    .stat-icon {
        width: 60px;
        height: 60px;
        border-radius: 14px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 24px;
        margin-bottom: 20px;
        background: var(--card-gradient);
        color: white;
        box-shadow: 0 6px 15px rgba(0, 0, 0, 0.15);
        position: relative;
        z-index: 2;
        transition: all 0.3s ease;
    }
    
    .stat-card:hover .stat-icon {
        transform: scale(1.08) rotate(3deg);
    }
    
    .stat-number {
        font-size: 2.2rem;
        font-weight: 800;
        margin: 10px 0 5px 0;
        background: var(--card-gradient);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        background-clip: text;
        line-height: 1;
        position: relative;
        z-index: 2;
    }
    
    .stat-label {
        font-size: 0.9rem;
        color: #64748b;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 0.8px;
        position: relative;
        z-index: 2;
    }
    
    .chart-container {
        background: rgba(255, 255, 255, 0.95);
        backdrop-filter: blur(20px);
        border-radius: 16px;
        padding: 25px 20px;
        margin-bottom: 20px;
        box-shadow: 
            0 8px 20px rgba(0, 0, 0, 0.1),
            0 2px 8px rgba(0, 0, 0, 0.05);
        border: 1px solid rgba(255, 255, 255, 0.3);
        transition: all 0.3s ease;
        height: 550px; /* Increased height for quick actions */
        position: relative;
        overflow: hidden;
        display: flex;
        flex-direction: column;
    }
    
    .chart-container::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        height: 3px;
        background: var(--primary-gradient);
        border-radius: 16px 16px 0 0;
    }
    
    .chart-container h5 {
        color: #1e293b;
        font-weight: 700;
        margin-bottom: 20px;
        font-size: 1.2rem;
        position: relative;
        padding-left: 15px;
        flex-shrink: 0;
    }
    
    .chart-container h5::before {
        content: '';
        position: absolute;
        left: 0;
        top: 50%;
        transform: translateY(-50%);
        width: 4px;
        height: 20px;
        background: var(--primary-gradient);
        border-radius: 6px;
    }
    
    .chart-content {
        flex: 1;
        overflow: hidden;
        display: flex;
        flex-direction: column;
    }
    
    .quick-actions {
        display: grid;
        grid-template-columns: repeat(2, 1fr);
        gap: 15px;
        margin-top: 0;
        flex: 1;
    }
    
    .quick-action-btn {
        background: rgba(255, 255, 255, 0.9);
        backdrop-filter: blur(15px);
        border: 2px solid rgba(255, 255, 255, 0.6);
        border-radius: 14px;
        padding: 25px 15px;
        text-align: center;
        text-decoration: none;
        color: #475569;
        transition: all 0.3s cubic-bezier(0.175, 0.885, 0.32, 1.275);
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        box-shadow: 0 6px 15px rgba(0, 0, 0, 0.08);
        position: relative;
        overflow: hidden;
        min-height: 110px;
    }
    
    .quick-action-btn::before {
        content: '';
        position: absolute;
        top: 0;
        left: -100%;
        width: 100%;
        height: 100%;
        background: var(--primary-gradient);
        transition: left 0.3s ease;
        z-index: 1;
    }
    
    .quick-action-btn:hover {
        border-color: transparent;
        color: white;
        text-decoration: none;
        transform: translateY(-5px);
        box-shadow: 0 12px 25px rgba(102, 126, 234, 0.3);
    }
    
    .quick-action-btn:hover::before {
        left: 0;
    }
    
    .action-icon {
        font-size: 32px;
        margin-bottom: 12px;
        display: block;
        position: relative;
        z-index: 2;
        transition: all 0.3s ease;
    }
    
    .quick-action-btn:hover .action-icon {
        transform: scale(1.15) rotate(8deg);
    }
    
    .quick-action-btn small {
        position: relative;
        z-index: 2;
        font-weight: 600;
        font-size: 0.9rem;
    }
    
    .welcome-text {
        font-size: 1.1rem;
        opacity: 0.95;
        margin-bottom: 0;
        font-weight: 300;
        text-shadow: 0 1px 5px rgba(0, 0, 0, 0.2);
    }
    
    .date-display {
        background: rgba(255, 255, 255, 0.2);
        backdrop-filter: blur(20px);
        padding: 12px 20px;
        border-radius: 20px;
        font-size: 0.9rem;
        display: inline-block;
        margin-top: 15px;
        border: 1px solid rgba(255, 255, 255, 0.3);
        box-shadow: 0 5px 20px rgba(0, 0, 0, 0.1);
        font-weight: 500;
    }
    
    .section-title {
        color: #1e293b;
        font-weight: 700;
        margin-bottom: 20px;
        font-size: 1.3rem;
        padding-left: 15px;
        position: relative;
    }
    
    .section-title::before {
        content: '';
        position: absolute;
        left: 0;
        top: 50%;
        transform: translateY(-50%);
        width: 5px;
        height: 25px;
        background: var(--primary-gradient);
        border-radius: 6px;
    }
    
    .info-grid {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 15px;
        margin-top: 0;
        flex: 1;
    }
    
    .info-item {
        background: rgba(248, 250, 252, 0.9);
        backdrop-filter: blur(15px);
        padding: 18px 15px;
        border-radius: 12px;
        border-left: 4px solid #667eea;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.06);
        transition: all 0.2s ease;
        border: 1px solid rgba(255, 255, 255, 0.5);
        display: flex;
        flex-direction: column;
        justify-content: center;
        min-height: 80px;
    }
    
    .info-item:hover {
        transform: translateY(-3px);
        box-shadow: 0 8px 20px rgba(0, 0, 0, 0.1);
    }
    
    .info-label {
        font-size: 0.8rem;
        color: #64748b;
        font-weight: 600;
        margin-bottom: 6px;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }
    
    .info-value {
        font-size: 1.1rem;
        color: #1e293b;
        font-weight: 700;
    }
    
    .floating-shapes {
        position: absolute;
        width: 100%;
        height: 100%;
        top: 0;
        left: 0;
        pointer-events: none;
        z-index: 1;
    }
    
    .shape {
        position: absolute;
        border-radius: 50%;
        background: rgba(255, 255, 255, 0.1);
        animation: float 6s ease-in-out infinite;
    }
    
    .shape:nth-child(1) { width: 60px; height: 60px; top: 10%; left: 10%; animation-delay: 0s; }
    .shape:nth-child(2) { width: 80px; height: 80px; top: 60%; left: 80%; animation-delay: 2s; }
    .shape:nth-child(3) { width: 40px; height: 40px; top: 80%; left: 20%; animation-delay: 4s; }
    
    @keyframes float {
        0%, 100% { transform: translateY(0) rotate(0deg); }
        50% { transform: translateY(-15px) rotate(180deg); }
    }
    
    /* Analytics Chart Styles */
    .analytics-chart {
        height: 220px;
        background: white;
        border-radius: 12px;
        padding: 15px;
        position: relative;
        margin-top: 15px;
        flex: 1;
    }
    
    .chart-bar {
        display: flex;
        align-items: end;
        justify-content: space-around;
        height: 150px;
        margin-top: 25px;
    }
    
    .bar {
        width: 30px;
        background: var(--primary-gradient);
        border-radius: 6px 6px 0 0;
        position: relative;
        transition: all 0.2s ease;
    }
    
    .bar:hover {
        transform: scale(1.08);
        box-shadow: 0 4px 12px rgba(102, 126, 234, 0.3);
    }
    
    .bar-label {
        position: absolute;
        bottom: -20px;
        left: 50%;
        transform: translateX(-50%);
        font-size: 0.75rem;
        color: #64748b;
        font-weight: 600;
    }
    
    .bar-value {
        position: absolute;
        top: -20px;
        left: 50%;
        transform: translateX(-50%);
        font-size: 0.8rem;
        font-weight: 700;
        color: #1e293b;
    }
    
    .activity-list {
        max-height: 240px;
        overflow-y: auto;
        flex: 1;
    }
    
    .activity-item {
        padding: 15px 12px;
        border-left: 4px solid #667eea;
        background: rgba(248, 250, 252, 0.9);
        margin-bottom: 10px;
        border-radius: 0 10px 10px 0;
        transition: all 0.2s ease;
    }
    
    .activity-item:hover {
        transform: translateX(3px);
        background: white;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
    }
    
    .activity-type {
        font-size: 0.75rem;
        padding: 3px 8px;
        border-radius: 10px;
        background: var(--primary-gradient);
        color: white;
        font-weight: 600;
    }
    
    .activity-type.student { background: var(--success-gradient); }
    .activity-type.fee { background: var(--warning-gradient); }
    .activity-type.attendance { background: var(--info-gradient); }
    
    .chart-grid {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 15px;
        margin-bottom: 15px;
        flex-shrink: 0;
    }
    
    .mini-chart {
        background: white;
        border-radius: 12px;
        padding: 18px 15px;
        height: 110px;
        display: flex;
        flex-direction: column;
        justify-content: center;
    }
    
    .chart-title {
        font-size: 0.85rem;
        color: #64748b;
        font-weight: 600;
        margin-bottom: 8px;
    }
    
    .chart-value {
        font-size: 1.5rem;
        font-weight: 800;
        color: #1e293b;
    }
    
    .chart-trend {
        font-size: 0.75rem;
        color: #10b981;
        font-weight: 600;
    }
    
    /* Progress bars for class distribution */
    .progress-container {
        margin-bottom: 12px;
    }
    
    .progress-label {
        display: flex;
        justify-content: space-between;
        margin-bottom: 5px;
        font-size: 0.8rem;
        color: #64748b;
    }
    
    .progress-bar-custom {
        height: 6px;
        background: #e2e8f0;
        border-radius: 8px;
        overflow: hidden;
    }
    
    .progress-fill {
        height: 100%;
        background: var(--primary-gradient);
        border-radius: 8px;
        transition: width 0.3s ease;
    }
    
    /* Responsive adjustments */
    @media (max-width: 1200px) {
        .stat-number {
            font-size: 2rem;
        }
        
        .stat-icon {
            width: 55px;
            height: 55px;
            font-size: 22px;
        }
        
        .chart-container {
            height: 400px;
        }
    }
    
    @media (max-width: 768px) {
        .dashboard-header {
            padding: 25px 0 20px;
            border-radius: 0 0 16px 16px;
        }
        
        .stat-card {
            padding: 20px 15px;
            margin-bottom: 12px;
        }
        
        .stat-number {
            font-size: 1.8rem;
        }
        
        .quick-actions {
            grid-template-columns: repeat(2, 1fr);
            gap: 12px;
        }
        
        .quick-action-btn {
            padding: 22px 12px;
            min-height: 100px;
        }
        
        .action-icon {
            font-size: 28px;
        }
        
        .info-grid {
            grid-template-columns: 1fr;
            gap: 12px;
        }
        
        .chart-grid {
            grid-template-columns: 1fr;
            gap: 12px;
        }
        
        .analytics-chart {
            height: 200px;
        }
        
        .chart-bar {
            height: 130px;
        }
        
        .chart-container {
            height: 380px;
        }
    }
    
    @media (max-width: 576px) {
        .main-container {
            padding: 0 10px 20px;
        }
        
        .stat-card {
            padding: 18px 12px;
        }
        
        .stat-number {
            font-size: 1.6rem;
        }
        
        .quick-actions {
            grid-template-columns: 1fr;
        }
        
        .chart-container {
            padding: 20px 15px;
            height: 360px;
        }
        
        .section-title {
            font-size: 1.1rem;
        }
    }
</style>

<div class="dashboard-header">
    <div class="floating-shapes">
        <div class="shape"></div>
        <div class="shape"></div>
        <div class="shape"></div>
    </div>
    <div class="container-fluid">
        <div class="row align-items-center">
            <div class="col-lg-8">
                <h1 class="h3 mb-2 fw-bold">Welcome back, Admin! 👋</h1>
                <p class="welcome-text">Here's what's happening with your school today</p>
                <div class="date-display">
                    <i class="fas fa-calendar-alt me-2"></i>
                    <?php echo date('l, F j, Y'); ?>
                </div>
            </div>
            <div class="col-lg-4 text-lg-end mt-3 mt-lg-0">
                <div class="quick-actions">
                    <a href="students.php" class="quick-action-btn">
                        <i class="fas fa-user-plus action-icon"></i>
                        <small>Add Student</small>
                    </a>
                    <a href="attendance.php" class="quick-action-btn">
                        <i class="fas fa-clipboard-check action-icon"></i>
                        <small>Attendance</small>
                    </a>
                    <a href="fees_vouchers.php" class="quick-action-btn">
                        <i class="fas fa-money-bill-wave action-icon"></i>
                        <small>Collect Fees</small>
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="container-fluid main-container">
    
    <!-- Statistics Cards Section -->
    <div class="stats-section">
        <h3 class="section-title">Today's Overview</h3>
        <div class="row">
            <div class="col-xl-3 col-md-6">
                <div class="stat-card students">
                    <div class="stat-icon">
                        <i class="fas fa-user-graduate"></i>
                    </div>
                    <div class="stat-number"><?php echo number_format($total_students); ?></div>
                    <div class="stat-label">Total Students</div>
                </div>
            </div>
            
            <div class="col-xl-3 col-md-6">
                <div class="stat-card teachers">
                    <div class="stat-icon">
                        <i class="fas fa-chalkboard-teacher"></i>
                    </div>
                    <div class="stat-number"><?php echo number_format($total_teachers); ?></div>
                    <div class="stat-label">Total Teachers</div>
                </div>
            </div>
            
            <div class="col-xl-3 col-md-6">
                <div class="stat-card classes">
                    <div class="stat-icon">
                        <i class="fas fa-school"></i>
                    </div>
                    <div class="stat-number"><?php echo number_format($total_classes); ?></div>
                    <div class="stat-label">Total Classes</div>
                </div>
            </div>
            
            <div class="col-xl-3 col-md-6">
                <div class="stat-card fees">
                    <div class="stat-icon">
                        <i class="fas fa-money-bill-wave"></i>
                    </div>
                    <div class="stat-number"><?php echo number_format($fees_collected); ?></div>
                    <div class="stat-label">Fees Collected</div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Main Content Section -->
    <div class="row">
        <!-- Left Column - Analytics -->
        <div class="col-lg-8">
            <!-- School Overview Chart -->
            <div class="chart-container">
                <h5>📊 School Overview</h5>
                <div class="chart-content">
                    <div class="chart-grid">
                        <div class="mini-chart">
                            <div class="chart-title">Student Growth</div>
                            <div class="chart-value">+15%</div>
                            <div class="chart-trend">↑ This month</div>
                        </div>
                        <div class="mini-chart">
                            <div class="chart-title">Attendance Rate</div>
                            <div class="chart-value">94%</div>
                            <div class="chart-trend">↑ 2% from last month</div>
                        </div>
                    </div>
                    
                    <!-- Student Growth Chart -->
                    <h6 class="mb-2 fw-bold" style="color: #64748b; font-size: 0.9rem;">Student Growth Trend (6 Months)</h6>
                    <div class="analytics-chart">
                        <div class="chart-bar">
                            <?php
                            $max_students = max($student_growth);
                            foreach ($student_growth as $index => $value) {
                                $height = $max_students > 0 ? ($value / $max_students) * 120 : 0;
                                echo '
                                <div class="bar" style="height: ' . $height . 'px">
                                    <div class="bar-value">' . $value . '</div>
                                    <div class="bar-label">' . $months[$index] . '</div>
                                </div>';
                            }
                            ?>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Class Distribution & Activities -->
            <div class="row mt-3">
                <div class="col-md-6">
                    <div class="chart-container">
                        <h5>🏫 Class Distribution</h5>
                        <div class="chart-content">
                            <div class="activity-list">
                                <?php foreach ($class_distribution as $class): ?>
                                    <div class="progress-container">
                                        <div class="progress-label">
                                            <span><?php echo $class['class']; ?></span>
                                            <span><?php echo $class['students']; ?> students</span>
                                        </div>
                                        <div class="progress-bar-custom">
                                            <div class="progress-fill" style="width: <?php echo ($class['students'] / 35) * 100; ?>%"></div>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-6">
                    <div class="chart-container">
                        <h5>🔔 Recent Activities</h5>
                        <div class="chart-content">
                            <div class="activity-list">
                                <?php foreach ($recent_activities as $activity): ?>
                                    <div class="activity-item">
                                        <div class="d-flex justify-content-between align-items-start">
                                            <div>
                                                <span class="activity-type <?php echo $activity['type']; ?>">
                                                    <?php echo ucfirst($activity['type']); ?>
                                                </span>
                                                <div class="mt-1" style="font-size: 0.85rem;"><?php echo $activity['activity']; ?></div>
                                            </div>
                                            <small class="text-muted" style="font-size: 0.75rem;">
                                                <?php echo $activity['time']; ?>
                                            </small>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Right Column - Quick Actions -->
        <div class="col-lg-4">
            <div class="chart-container">
                <h5>🚀 Quick Actions</h5>
                <div class="chart-content">
                    <div class="quick-actions">
                        <a href="students.php" class="quick-action-btn">
                            <i class="fas fa-users action-icon"></i>
                            <small>Students</small>
                        </a>
                        <a href="teachers.php" class="quick-action-btn">
                            <i class="fas fa-chalkboard-teacher action-icon"></i>
                            <small>Teachers</small>
                        </a>
                        <a href="class_planner.php" class="quick-action-btn">
                            <i class="fas fa-calendar-alt action-icon"></i>
                            <small>Planner</small>
                        </a>
                        <a href="fees_vouchers.php" class="quick-action-btn">
                            <i class="fas fa-money-bill action-icon"></i>
                            <small>Fees</small>
                        </a>
                        <a href="attendance.php" class="quick-action-btn">
                            <i class="fas fa-clipboard-check action-icon"></i>
                            <small>Attendance</small>
                        </a>
                        <a href="reports.php" class="quick-action-btn">
                            <i class="fas fa-chart-pie action-icon"></i>
                            <small>Reports</small>
                        </a>
                    </div>
                </div>
            </div>
            
            <!-- System Information -->
            <div class="chart-container mt-3">
                <h5>⚙️ System Information</h5>
                <div class="chart-content">
                    <div class="info-grid">
                        <div class="info-item">
                            <div class="info-label">Server Time</div>
                            <div class="info-value"><?php echo date('h:i A'); ?></div>
                        </div>
                        <div class="info-item">
                            <div class="info-label">Academic Year</div>
                            <div class="info-value">2024-2025</div>
                        </div>
                        <div class="info-item">
                            <div class="info-label">PHP Version</div>
                            <div class="info-value"><?php echo phpversion(); ?></div>
                        </div>
                        <div class="info-item">
                            <div class="info-label">Database</div>
                            <div class="info-value">MySQL</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php
// Footer file include karein
include('includes/footer.php');
?>