<?php
// FILE: admin/delete_expense.php

session_start();
include_once('../config/db.php');

// Connection open
$conn = getDBConnection();

// Check if ID is provided
$expense_id = $_GET['id'] ?? null;
$message = '';
$status = 'error';

if ($expense_id && is_numeric($expense_id)) {
    // Prepare the delete statement
    $stmt = $conn->prepare("DELETE FROM other_expenses WHERE id = ?");
    
    if ($stmt) {
        $stmt->bind_param("i", $expense_id);
        
        if ($stmt->execute()) {
            // Check if any row was affected
            if ($stmt->affected_rows > 0) {
                $message = "Expense with ID: {$expense_id} has been deleted successfully.";
                $status = 'deleted';
            } else {
                $message = "Error: Expense with ID: {$expense_id} not found.";
            }
        } else {
            $message = "Database error during deletion: " . $stmt->error;
        }
        $stmt->close();
    } else {
        $message = "Database error preparing statement: " . $conn->error;
    }
} else {
    $message = "Invalid or missing expense ID.";
}

// Connection close (Agar header/footer mein close nahi ho raha to yahan close karna behtar hai)
if (isset($conn) && $conn instanceof mysqli) {
    @$conn->close();
}

// Redirect back to the report page with status message
header("Location: financial_summary_report.php?status={$status}&message=" . urlencode($message));
exit();

?>