<?php
// admin/delete_marks_process.php - Dedicated file for deleting student marks entries (FINAL FIX)

session_start();
ob_start(); 
include_once('../config/db.php'); 

$conn = getDBConnection();

$exam_id = (int)($_GET['exam_id'] ?? 0);
$class_id = (int)($_GET['class_id'] ?? 0);
$student_id = (int)($_GET['student_id'] ?? 0);

$redirect_url = "marks_entry.php?exam_id={$exam_id}&class_id={$class_id}";


if ($student_id > 0 && $exam_id > 0 && $class_id > 0) {
    
    $conn->begin_transaction();
    $overall_success = false;

    try {
        // Only delete from exam_marks (as final_results table is not available)
        $delete_marks_stmt = $conn->prepare("DELETE FROM exam_marks WHERE student_id = ? AND exam_id = ? AND class_id = ?");
        $delete_marks_stmt->bind_param("iii", $student_id, $exam_id, $class_id); 
        $delete_marks_stmt->execute();
        $marks_rows_affected = $delete_marks_stmt->affected_rows;
        $delete_marks_stmt->close();
        
        if ($marks_rows_affected > 0) {
            $overall_success = true;
        }

        $conn->commit(); 

        if ($overall_success) {
             header("Location: {$redirect_url}&msg=" . urlencode("Student's marks deleted successfully. Total entries removed: {$marks_rows_affected}."));
        } else {
             header("Location: {$redirect_url}&err=" . urlencode("Deletion completed, but no marks were found to delete."));
        }
        exit;
        
    } catch (Exception $e) {
        $conn->rollback(); 
        $error_message = $e->getMessage();
        header("Location: {$redirect_url}&err=" . urlencode("DB Error during marks deletion: " . $error_message));
        exit;
    }
} else {
    header("Location: marks_entry.php?err=" . urlencode("Invalid parameters provided for result deletion."));
    exit;
}

if (isset($conn) && is_object($conn)) {
    $conn->close();
}
ob_end_flush();
?>