 <?php
include_once('includes/header.php'); 
include_once('includes/sidebar.php'); 

$conn = getDBConnection();
$class_id = (int)($_GET['id'] ?? 0);

if ($class_id <= 0) {
    header('Location: sections.php?err=' . urlencode('Invalid Class ID.'));
    exit;
}

$stmt = $conn->prepare("SELECT * FROM academic_classes WHERE id = ?");
$stmt->bind_param("i", $class_id);
$stmt->execute();
$result = $stmt->get_result();
$class = $result->fetch_assoc();

if (!$class) {
    header('Location: sections.php?err=' . urlencode('Class not found.'));
    exit;
}

$stmt->close();
$conn->close();
?>

<h1 class="mb-4">Edit Class: <?php echo htmlspecialchars($class['name']); ?></h1>

<div class="row">
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                Update Class Details
            </div>
            <div class="card-body">
                <form action="classes_process.php" method="POST">
                    <input type="hidden" name="action" value="update_class">
                    <input type="hidden" name="class_id" value="<?php echo $class['id']; ?>">
                    
                    <div class="form-group">
                        <label>Class Name:</label>
                        <input type="text" name="name" class="form-control" value="<?php echo htmlspecialchars($class['name']); ?>" required>
                    </div>
                    
                    <div class="form-group">
                        <label>Display Order:</label>
                        <input type="number" name="order_no" class="form-control" value="<?php echo htmlspecialchars($class['order_no']); ?>" required>
                    </div>

                    <div class="form-group">
                        <label>Class Code (Auto-Generated):</label>
                        <input type="text" class="form-control" value="<?php echo htmlspecialchars($class['code'] ?? 'N/A'); ?>" disabled>
                    </div>
                    
                    <button type="submit" class="btn btn-primary">Save Changes</button>
                    <a href="sections.php" class="btn btn-secondary">Cancel / Go Back</a>
                </form>
            </div>
        </div>
    </div>
</div>

<?php
include_once('includes/footer.php'); 
?>