<?php
// admin/edit_exam.php

session_start();
include_once('../config/db.php');
include_once('includes/header.php');

$conn = getDBConnection();
$exam_id = (int)($_GET['id'] ?? 0);
$error = $_GET['err'] ?? '';
$message = $_GET['msg'] ?? '';

if ($exam_id === 0) {
    // Agar ID nahi mili to wapas 'manage_exams.php' par bhej dein
    header('Location: manage_exams.php?err=' . urlencode('Invalid Exam ID provided for editing.'));
    exit;
}

// 1. Exam Data Fetch Karein
$exam_data = null;
$stmt = $conn->prepare("SELECT id, name, session_id, start_date, end_date, status FROM exams WHERE id = ?");
$stmt->bind_param("i", $exam_id);
$stmt->execute();
$result = $stmt->get_result();
if ($result->num_rows > 0) {
    $exam_data = $result->fetch_assoc();
} else {
    // Exam ID database mein nahi mili
    header('Location: manage_exams.php?err=' . urlencode('Exam not found.'));
    exit;
}
$stmt->close();

// 2. Sessions Fetch Karein dropdown ke liye
$sessions_result = $conn->query("SELECT id, name FROM academic_sessions ORDER BY id DESC");
$sessions = $sessions_result->fetch_all(MYSQLI_ASSOC);

?>

<h2 class="mb-4">Edit Exam: <?php echo htmlspecialchars($exam_data['name']); ?></h2>

<?php if ($message): ?>
    <div class="alert alert-success"><?php echo htmlspecialchars($message); ?></div>
<?php endif; ?>

<?php if ($error): ?>
    <div class="alert alert-danger"><?php echo htmlspecialchars($error); ?></div>
<?php endif; ?>

<div class="card p-4">
    <form action="exam_process.php" method="POST">
        <input type="hidden" name="action" value="update_exam">
        <input type="hidden" name="exam_id" value="<?php echo (int)$exam_data['id']; ?>">
        
        <div class="form-group">
            <label for="exam_name">Exam Name <span class="text-danger">*</span></label>
            <input type="text" name="exam_name" id="exam_name" class="form-control" 
                value="<?php echo htmlspecialchars($exam_data['name']); ?>" 
                placeholder="E.g., Mid-Term Exam, Final Assessment" required>
        </div>

        <div class="form-row">
            <div class="form-group col-md-6">
                <label for="session_id">Academic Session <span class="text-danger">*</span></label>
                <select name="session_id" id="session_id" class="form-control" required>
                    <option value="">-- Select Session --</option>
                    <?php foreach ($sessions as $session): ?>
                        <option value="<?php echo $session['id']; ?>" 
                            <?php echo $exam_data['session_id'] == $session['id'] ? 'selected' : ''; ?>>
                            <?php echo htmlspecialchars($session['name']); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="form-group col-md-6">
                <label for="status">Status</label>
                <select name="status" id="status" class="form-control">
                    <option value="upcoming" <?php echo $exam_data['status'] == 'upcoming' ? 'selected' : ''; ?>>Upcoming</option>
                    <option value="active" <?php echo $exam_data['status'] == 'active' ? 'selected' : ''; ?>>Active</option>
                    <option value="completed" <?php echo $exam_data['status'] == 'completed' ? 'selected' : ''; ?>>Completed</option>
                </select>
            </div>
        </div>

        <div class="form-row">
            <div class="form-group col-md-6">
                <label for="start_date">Start Date <span class="text-danger">*</span></label>
                <input type="date" name="start_date" id="start_date" class="form-control" 
                    value="<?php echo htmlspecialchars($exam_data['start_date']); ?>" required>
            </div>
            <div class="form-group col-md-6">
                <label for="end_date">End Date</label>
                <input type="date" name="end_date" id="end_date" class="form-control" 
                    value="<?php echo htmlspecialchars($exam_data['end_date'] ?? ''); ?>">
            </div>
        </div>

        <button type="submit" class="btn btn-success"><i class="fas fa-save"></i> Save Changes</button>
        <a href="manage_exams.php" class="btn btn-secondary">Cancel</a>
    </form>
</div>

<?php
$conn->close();
include_once('includes/footer.php');
?>