<?php
// FILE: admin/fee_collection.php - DEDICATED PAYMENT COLLECTION PAGE
session_start();
include_once('../config/db.php');
include_once('includes/header.php'); // Aapke admin header/sidebar ko include karega

$conn = getDBConnection();

$message = '';
$error = '';
$invoice_id_search = (int)($_GET['invoice_id'] ?? 0); // From fee_report_monthly.php
$voucher_no_search = $_POST['voucher_no_search'] ?? ''; // For manual search form

$invoice = null;
$payments = [];
$total_paid = 0;
$due_amount = 0;

// ====================================================================
// 1. PAYMENT SUBMISSION LOGIC
// ====================================================================
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['submit_payment'])) {
    
    $invoice_id_submit = (int)$_POST['invoice_id'];
    $amount_paid = (float)$_POST['amount_paid'];
    $payment_date = $_POST['payment_date'];
    $payment_method = $_POST['payment_method'];
    $reference_no = trim($_POST['reference_no'] ?? '');

    // Input validation (Aapke system ke mutabiq)
    if ($amount_paid <= 0 || empty($payment_date) || empty($payment_method)) {
        $error = "Payment amount, date, aur method zaroori hain.";
    } elseif ($invoice_id_submit <= 0) {
        $error = "Invalid Invoice ID.";
    } else {
        // Assume maximum payment limit is handled on front end or is the total due.
        
        $insert_query = "
            INSERT INTO fee_payments (
                invoice_id, 
                amount, 
                payment_date, 
                payment_method, 
                reference_no,
                created_at
            ) VALUES (?, ?, ?, ?, ?, NOW())";

        $stmt = $conn->prepare($insert_query);
        $stmt->bind_param("idsss", 
            $invoice_id_submit, 
            $amount_paid, 
            $payment_date, 
            $payment_method, 
            $reference_no
        );
        
        if ($stmt->execute()) {
            // Success message ke saath report page par redirect karein
            $message = "Payment of Rs. " . number_format($amount_paid) . " successfully recorded.";
            header("Location: fee_report_monthly.php?msg=" . urlencode($message));
            exit();
        } else {
            $error = "Payment record karte waqt ghalti hui: " . $stmt->error;
        }
        $stmt->close();
    }
}

// ====================================================================
// 2. INVOICE FETCH LOGIC
// ====================================================================
$search_value = $invoice_id_search > 0 ? $invoice_id_search : $voucher_no_search;
$search_column = $invoice_id_search > 0 ? 'fi.id' : 'fi.voucher_no';

if (!empty($search_value)) {
    // Query to fetch invoice, student, and class details
    $invoice_query = "
        SELECT 
            fi.*,
            s.gr_no, 
            CONCAT(s.first_name, ' ', s.last_name) AS student_name,
            ac.name AS class_name
        FROM 
            fee_invoices fi
        JOIN 
            students s ON fi.student_id = s.id
        -- Class name ke liye join
        JOIN 
            academic_classes ac ON fi.class_id = ac.id
        WHERE 
            {$search_column} = ?
        LIMIT 1
    ";

    $stmt = $conn->prepare($invoice_query);
    if ($invoice_id_search > 0) {
        $stmt->bind_param("i", $search_value);
    } else {
        $stmt->bind_param("s", $search_value);
    }
    
    $stmt->execute();
    $result = $stmt->get_result();
    $invoice = $result->fetch_assoc();
    $stmt->close();

    if ($invoice) {
        // Payments history fetch karein
        $payments_query = "SELECT * FROM fee_payments WHERE invoice_id = ? ORDER BY payment_date DESC";
        $p_stmt = $conn->prepare($payments_query);
        $p_stmt->bind_param("i", $invoice['id']);
        $p_stmt->execute();
        $payments = $p_stmt->get_result()->fetch_all(MYSQLI_ASSOC);
        $p_stmt->close();

        // Total Paid Amount calculate karein
        foreach ($payments as $payment) {
            $total_paid += (float)$payment['amount'];
        }

        $due_amount = $invoice['total_amount'] - $total_paid;
        
    } else {
        $error = "Invoice not found for the given " . ($invoice_id_search > 0 ? 'ID' : 'Voucher No') . ".";
    }
}
?>

<div class="content-wrapper">
    <div class="container-fluid">
        <h1 class="mt-4"><i class="fas fa-money-bill-wave"></i> Collect Fee Payment</h1>
        <ol class="breadcrumb mb-4">
            <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
            <li class="breadcrumb-item"><a href="fee_report_monthly.php">Fee Report</a></li>
            <li class="breadcrumb-item active">Collect Fee</li>
        </ol>

        <?php if (!empty($message)): ?>
            <div class="alert alert-success"><?php echo $message; ?></div>
        <?php endif; ?>
        <?php if (!empty($error)): ?>
            <div class="alert alert-danger"><?php echo $error; ?></div>
        <?php endif; ?>
        
        <div class="card mb-4">
            <div class="card-header"><i class="fas fa-search"></i> Find Invoice by Voucher No.</div>
            <div class="card-body">
                <form method="POST" action="fee_collection.php" class="form-row align-items-center">
                    <div class="col-md-9">
                        <input type="text" name="voucher_no_search" class="form-control" placeholder="Enter Voucher Number (e.g., FINV-00123)" required value="<?php echo htmlspecialchars($voucher_no_search); ?>">
                    </div>
                    <div class="col-md-3">
                        <button type="submit" class="btn btn-secondary btn-block"><i class="fas fa-search"></i> Search</button>
                    </div>
                </form>
            </div>
        </div>

        <?php if ($invoice): ?>
            <div class="card mb-4">
                <div class="card-header bg-primary text-white"><i class="fas fa-file-invoice"></i> Invoice Details - **<?php echo htmlspecialchars($invoice['voucher_no']); ?>**</div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <p><strong>Student Name:</strong> <?php echo htmlspecialchars($invoice['student_name']); ?></p>
                            <p><strong>G.R. No.:</strong> <?php echo htmlspecialchars($invoice['gr_no']); ?></p>
                            <p><strong>Class:</strong> <?php echo htmlspecialchars($invoice['class_name']); ?></p>
                        </div>
                        <div class="col-md-6 text-right">
                            <h5 class="text-secondary">Invoice Date: <?php echo date('d-M-Y', strtotime($invoice['invoice_date'])); ?></h5>
                            <h4 class="text-info">Total Invoice Amount: **Rs. <?php echo number_format($invoice['total_amount']); ?>**</h4>
                            <h4 class="<?php echo $due_amount <= 0 ? 'text-success' : 'text-danger'; ?>">Balance Due: **Rs. <?php echo number_format($due_amount); ?>**</h4>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card mb-4">
                <div class="card-header"><i class="fas fa-dollar-sign"></i> Record Payment</div>
                <div class="card-body">
                    <form method="POST" action="fee_collection.php">
                        <input type="hidden" name="invoice_id" value="<?php echo $invoice['id']; ?>">
                        
                        <div class="form-row">
                            <div class="form-group col-md-4">
                                <label for="amount_paid">Amount Paid (Max: <?php echo number_format($due_amount); ?>)</label>
                                <input type="number" step="0.01" name="amount_paid" id="amount_paid" class="form-control" 
                                       max="<?php echo (float)$due_amount; ?>" required 
                                       value="<?php echo max(0, (float)$due_amount); ?>"
                                       <?php echo $due_amount <= 0 ? 'disabled' : ''; ?>>
                            </div>
                            
                            <div class="form-group col-md-4">
                                <label for="payment_date">Payment Date</label>
                                <input type="date" name="payment_date" id="payment_date" class="form-control" required value="<?php echo date('Y-m-d'); ?>"
                                       <?php echo $due_amount <= 0 ? 'disabled' : ''; ?>>
                            </div>
                            
                            <div class="form-group col-md-4">
                                <label for="payment_method">Payment Method</label>
                                <select name="payment_method" id="payment_method" class="form-control" required
                                        <?php echo $due_amount <= 0 ? 'disabled' : ''; ?>>
                                    <option value="">-- Select Method --</option>
                                    <option value="Cash">Cash</option>
                                    <option value="Bank Transfer">Bank Transfer</option>
                                    <option value="Cheque">Cheque</option>
                                    <option value="Mobile Payment">Mobile Payment</option>
                                </select>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="reference_no">Reference/Cheque No. (Optional)</label>
                            <input type="text" name="reference_no" id="reference_no" class="form-control" placeholder="Enter reference number or cheque number"
                                   <?php echo $due_amount <= 0 ? 'disabled' : ''; ?>>
                        </div>

                        <button type="submit" name="submit_payment" class="btn btn-success btn-lg" 
                                <?php echo $due_amount <= 0 ? 'disabled' : ''; ?>>
                            <i class="fas fa-save"></i> Record Payment
                        </button>
                        
                        <?php if ($due_amount <= 0): ?>
                            <div class="alert alert-success mt-3">This invoice is already fully paid.</div>
                        <?php endif; ?>
                    </form>
                </div>
            </div>
            
            <?php if (!empty($payments)): ?>
            <div class="card mb-4">
                <div class="card-header"><i class="fas fa-history"></i> Payment History</div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-sm">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Amount</th>
                                    <th>Date</th>
                                    <th>Method</th>
                                    <th>Reference No.</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($payments as $p): ?>
                                <tr>
                                    <td><?php echo $p['id']; ?></td>
                                    <td>Rs. <?php echo number_format($p['amount']); ?></td>
                                    <td><?php echo date('d-M-Y', strtotime($p['payment_date'])); ?></td>
                                    <td><?php echo htmlspecialchars($p['payment_method']); ?></td>
                                    <td><?php echo htmlspecialchars($p['reference_no']); ?></td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <?php endif; ?>
            
        <?php elseif(empty($search_value)): ?>
            <div class="alert alert-info">Kripya, invoice ID URL mein bhejien (jaise `fee_collection.php?invoice_id=123`) ya Voucher No. se search karein.</div>
        <?php endif; ?>

    </div>
</div>

<?php
include_once('includes/footer.php'); 
if (isset($conn) && is_object($conn)) {
    $conn->close();
}
?>