<?php
// FILE: admin/fee_report_monthly.php - FINAL FIXED CODE (Cleaned UI)

session_start();
include_once('../config/db.php');
include_once('includes/header.php'); 

$conn = getDBConnection();

// --- START: Settings Fetch Logic (Same as before) ---
$settings_data = [];
$settings_query = $conn->query("SELECT setting_key, setting_value FROM settings");
if ($settings_query) {
    while ($row = $settings_query->fetch_assoc()) {
        $settings_data[trim($row['setting_key'])] = trim($row['setting_value']);
    }
}
$institute_name = $settings_data['institute.name'] ?? $settings_data['institute name'] ?? $settings_data['institute_name'] ?? "SCHOOL NAME (UPDATE SETTINGS)";
$institute_address = $settings_data['institute.address'] ?? $settings_data['institute address'] ?? $settings_data['institute_address'] ?? "Address Not Set";
$institute_phone = $settings_data['institute.phone'] ?? $settings_data['institute phone'] ?? $settings_data['institute_phone'] ?? "Phone Not Set";

$raw_logo_path = $settings_data['institute.logo_path'] ?? $settings_data['institute logo path'] ?? '';
$logoPathParts = explode('|', $raw_logo_path);

// Logo Path se sirf clean path nikal rahe hain
$logo_db_path_clean = end($logoPathParts); 

// === LOGO PATH: Dono Contexts ke liye path set karna ===
// 1. Main page view (Relative to admin/ folder)
$relative_logo_path = !empty($logo_db_path_clean) ? '../' . $logo_db_path_clean : '../assets/img/logo.png'; 

// 2. Print Pop-up ke liye (Web Root se Relative Path)
$project_root = '/learning/'; 
$final_logo_path_for_print = $project_root . $logo_db_path_clean;
// =================================================

$current_session_id = $settings_data['academic.active_session_id'] ?? 1;
// --- END: Settings Fetch Logic ---

$months = [1 => 'January', 2 => 'February', 3 => 'March', 4 => 'April', 5 => 'May', 6 => 'June', 7 => 'July', 8 => 'August', 9 => 'September', 10 => 'October', 11 => 'November', 12 => 'December'];

// Input Variables / WARNING FIX (Same as before)
$selected_class_id = (int)($_POST['class_id'] ?? 0);
$selected_section_id = (int)($_POST['section_id'] ?? 0);
$selected_month = (int)($_POST['month'] ?? date('n')); 
$selected_year = (int)($_POST['year'] ?? date('Y'));   


// Classes aur Sections fetch karein (Same as before)
$classes_query = $conn->query("SELECT id, name FROM academic_classes ORDER BY id");
$classes = $classes_query->fetch_all(MYSQLI_ASSOC);

$sections_query = $conn->query("SELECT id, name FROM academic_sections ORDER BY id");
$sections = $sections_query->fetch_all(MYSQLI_ASSOC);

$report_data = [];

if ($selected_class_id > 0) {
    
    $where_clauses = ["en.class_id = ?", "en.session_id = ?", "s.status = 'active'"];
    $param_types = "ii";
    $params = [$selected_class_id, $current_session_id];

    if ($selected_section_id > 0) {
        $where_clauses[] = "en.section_id = ?";
        $param_types .= "i";
        $params[] = $selected_section_id;
    }
    
    $query = "
        SELECT 
            s.id AS student_id,
            s.gr_no, 
            TRIM(CONCAT(IFNULL(s.first_name, ''), ' ', IFNULL(s.last_name, ''))) AS student_name, 
            ac.name AS class_name,
            acs.name AS section_name, 
            fi.id AS invoice_id,
            fi.voucher_no,
            fi.total_amount AS invoice_amount, 
            SUM(fp.amount) AS amount_paid_total
        FROM students s
        JOIN student_enrollments en ON s.id = en.student_id
        JOIN academic_classes ac ON en.class_id = ac.id
        LEFT JOIN academic_sections acs ON en.section_id = acs.id
        LEFT JOIN fee_invoices fi ON s.id = fi.student_id 
        LEFT JOIN fee_payments fp ON fi.id = fp.invoice_id
        WHERE " . implode(' AND ', $where_clauses) . "
        GROUP BY s.id, fi.id
        ORDER BY s.gr_no
    ";
    
    $final_params = $params; 
    $final_param_types = $param_types; 

    $stmt = $conn->prepare($query); 
    $stmt->bind_param($final_param_types, ...$final_params);
    $stmt->execute();
    $result = $stmt->get_result();
    $report_data = $result->fetch_all(MYSQLI_ASSOC);
    $stmt->close();
}
?>

<style>
/* Yeh CSS Pop-up window mein use hoga */
.print-container {
    padding: 20px;
    width: 100%;
    margin: auto;
}
.report-header {
    border-bottom: 2px solid #000;
    padding-bottom: 10px;
    margin-bottom: 15px;
    text-align: center;
}
.report-header img {
    max-height: 80px; 
    width: auto; 
    object-fit: contain;
    float: left;
    margin-right: 20px;
}
.report-header h2 {
    margin: 0; 
    font-weight: 900; 
    color: #000;
    font-size: 16pt;
}
.report-header p {
    margin: 0; 
    font-size: 11pt;
}
.report-table {
    width: 100%;
    border-collapse: collapse;
    font-size: 10pt;
    table-layout: fixed; /* Table ko fixed width de dein */
}
.report-table th, .report-table td {
    border: 1px solid #000;
    padding: 4px;
    /* Default: Text ko center kiya gaya hai */
    text-align: center; 
}

/* Amount columns ko Right aligned rakha gaya hai taake numbers theek dikhen */
.report-table th.text-right, .report-table td.text-right { text-align: right !important; }

.font-weight-bold { font-weight: bold; }

@media print {
    #layoutSidenav_nav, .sb-topnav, .d-print-none, .breadcrumb {
        display: none !important;
    }
}
</style>


<h1 class="mt-4 d-print-none"><i class="fas fa-chart-bar"></i> Fee Status Report</h1>
<ol class="breadcrumb mb-4 d-print-none">
    <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
    <li class="breadcrumb-item active">Fee Report</li>
</ol>

<div class="card mb-4 d-print-none">
    <div class="card-header"><i class="fas fa-filter"></i> Select Filters</div>
    <div class="card-body">
        <form method="POST" action="fee_report_monthly.php" class="form-row align-items-end">
            
            <div class="form-group col-md-3 mb-0">
                <label for="class_id">Select Class:</label>
                <select name="class_id" id="class_id" class="form-control" required>
                    <option value="">-- Select Class --</option>
                    <?php foreach ($classes as $class): ?>
                        <option value="<?php echo $class['id']; ?>" <?php echo ($selected_class_id == $class['id']) ? 'selected' : ''; ?>><?php echo htmlspecialchars($class['name']); ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            
            <div class="form-group col-md-2 mb-0">
                <label for="section_id">Select Section:</label>
                <select name="section_id" id="section_id" class="form-control">
                    <option value="0">-- All Sections --</option>
                    <?php foreach ($sections as $section): ?>
                        <option value="<?php echo $section['id']; ?>" <?php echo ($selected_section_id == $section['id']) ? 'selected' : ''; ?>><?php echo htmlspecialchars($section['name']); ?></option>
                    <?php endforeach; ?>
                </select>
            </div>

            <div class="form-group col-md-2 mb-0">
                <label for="month">Select Month (Non-Functional):</label>
                <select name="month" id="month" class="form-control" required>
                    <?php foreach ($months as $num => $name): ?>
                        <option value="<?php echo $num; ?>" <?php echo ($selected_month == $num) ? 'selected' : ''; ?>><?php echo htmlspecialchars($name); ?></option>
                    <?php endforeach; ?>
                </select>
            </div>

            <div class="form-group col-md-2 mb-0">
                <label for="year">Select Year (Non-Functional):</label>
                <input type="number" name="year" id="year" class="form-control" value="<?php echo $selected_year; ?>" min="2020" max="<?php echo date('Y') + 1; ?>" required>
            </div>

            <div class="col-md-3 mb-0">
                <button type="submit" class="btn btn-primary btn-block"><i class="fas fa-search"></i> Generate Report</button>
            </div>
        </form>
    </div>
</div>

<?php if ($selected_class_id > 0 && !empty($report_data)): ?>
    
    <button class="btn btn-info mb-3 d-print-none" onclick="printReportContent('<?php echo $final_logo_path_for_print; ?>')"><i class="fas fa-print"></i> Print Class Report (Full Width)</button>

    <div id="report-content" class="card mb-4">
        
        <div class="report-header">
            <div style="overflow: hidden;">
                <img id="print-logo-preview" src="<?php echo htmlspecialchars($relative_logo_path); ?>" alt="Logo" class="print-logo">
                <div style="text-align: center; margin-left: 100px;">
                    <h2><?php echo htmlspecialchars($institute_name); ?></h2>
                    <p><?php echo htmlspecialchars($institute_address); ?></p>
                    <p>Phone: <?php echo htmlspecialchars($institute_phone); ?></p>
                </div>
            </div>
            <h4 style="margin-top: 10px; border-top: 1px solid #ccc; padding-top: 5px; font-size: 14pt;">
                Fee Status Report | Class: <?php echo htmlspecialchars($report_data[0]['class_name'] ?? 'N/A') . (empty($report_data[0]['section_name']) ? '' : ' - Section: ' . htmlspecialchars($report_data[0]['section_name'])); ?>
            </h4>
            <p style="margin-top: 5px; font-size: 9pt;">Report Date: <?php echo date('Y-m-d H:i:s'); ?></p>
        </div>

        <div class="card-header d-print-none">
            <i class="fas fa-table"></i> 
            Fee Status for All Invoices (Class: <?php echo htmlspecialchars($report_data[0]['class_name'] ?? 'N/A') . (empty($report_data[0]['section_name']) ? '' : ' - Section: ' . htmlspecialchars($report_data[0]['section_name'])); ?>)
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="report-table table-bordered table-striped" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th style="width: 25%;">Student Name</th>
                            <th style="width: 15%;">Class/Section</th>
                            <th style="width: 10%;">Voucher No.</th>
                            <th class="text-right" style="width: 10%;">Inv. Amount</th>
                            <th class="text-right" style="width: 10%;">Paid Amount</th>
                            <th class="text-right" style="width: 15%;">Due Amount</th>
                            <th style="width: 15%;">Status</th> 
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($report_data as $student): 
                            $invoice_amount = $student['invoice_amount'] ?? 0;
                            $amount_paid = $student['amount_paid_total'] ?? 0;
                            $due_amount = $invoice_amount - $amount_paid;
                            
                            $display_name = !empty(trim($student['student_name'])) ? htmlspecialchars($student['student_name']) : 'GR: ' . htmlspecialchars($student['gr_no']);
                        ?>
                        <tr>
                            <td><?php echo $display_name; ?></td> 
                            <td><?php echo htmlspecialchars($student['class_name']) . (empty($student['section_name']) ? '' : ' (' . htmlspecialchars($student['section_name']) . ')'); ?></td>
                            <td><?php echo htmlspecialchars($student['voucher_no'] ?? 'N/A'); ?></td>
                            <td class="text-right">Rs. <?php echo number_format($invoice_amount); ?></td>
                            <td class="text-right">Rs. <?php echo number_format($amount_paid); ?></td>
                            <td class="text-right">
                                <span class="font-weight-bold <?php echo $due_amount > 0 ? 'text-danger' : 'text-success'; ?>">
                                    Rs. <?php echo number_format($due_amount); ?>
                                </span>
                            </td>
                            <td>
                                <?php 
                                    $status_text = 'N/A';
                                    if (!$student['invoice_id']) { $status_text = 'No Inv.'; }
                                    elseif ($due_amount <= 0) { $status_text = 'PAID'; }
                                    else { $status_text = 'UNPAID'; }
                                ?>
                                <?php echo $status_text; ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
<?php elseif ($selected_class_id > 0 && empty($report_data)): ?>
    <div class="alert alert-warning">Selected filters (Class, Section) ke liye koi active student ya fee data nahi mila.</div>
<?php endif; ?>

<script>
function printReportContent(logoPath) {
    // 1. Sirf report area ka content uthao
    const reportContentDiv = document.getElementById('report-content');
    
    if (!reportContentDiv) {
        alert('Report content not found.');
        return;
    }
    
    // Naya content banao jismein sirf table aur header ho
    const reportHeader = reportContentDiv.querySelector('.report-header').outerHTML;
    const tableHTML = reportContentDiv.querySelector('table').outerHTML;
    
    // 2. Ek naya Pop-up Window kholo
    const printWindow = window.open('', '', 'height=600,width=1000'); 

    // 3. HTML content aur CSS style naye window mein daalo
    printWindow.document.write('<html><head><title>Fee Status Report</title>');
    
    // Naye window mein CSS styles daal rahe hain
    printWindow.document.write('<style>');
    
    // Final CSS Styles (Widths aur Alignment update kiye gaye)
    printWindow.document.write(`
        body { margin: 0; padding: 0; font-family: Arial, sans-serif; }
        .print-container { padding: 20px; width: 100%; margin: 0; box-sizing: border-box; }
        .report-header { border-bottom: 2px solid #000; padding-bottom: 10px; margin-bottom: 15px; text-align: center; }
        .report-header img { max-height: 80px; width: auto; object-fit: contain; float: left; margin-right: 20px; }
        .report-header h2 { margin: 0; font-weight: 900; color: #000; font-size: 16pt; }
        .report-header p { margin: 0; font-size: 11pt; }
        .report-table { width: 100%; border-collapse: collapse; font-size: 10pt; table-layout: fixed; }
        .report-table th, .report-table td { 
            border: 1px solid #000; 
            padding: 4px; 
            /* Saare cells ko center align kiya gaya */
            text-align: center; 
        }
        .text-right { text-align: right !important; }
        .font-weight-bold { font-weight: bold; }
        .text-danger { color: #dc3545; }
        .text-success { color: #28a745; }

        /* Column Widths Update (Student Name Chota, Status Bara) */
        .report-table th:nth-child(1), .report-table td:nth-child(1) { width: 25%; } /* Student Name */
        .report-table th:nth-child(2), .report-table td:nth-child(2) { width: 15%; } /* Class/Section */
        .report-table th:nth-child(3), .report-table td:nth-child(3) { width: 10%; } /* Voucher No. */
        .report-table th:nth-child(4), .report-table td:nth-child(4) { width: 10%; text-align: right; } /* Inv. Amount (Right) */
        .report-table th:nth-child(5), .report-table td:nth-child(5) { width: 10%; text-align: right; } /* Paid Amount (Right) */
        .report-table th:nth-child(6), .report-table td:nth-child(6) { width: 15%; text-align: right; } /* Due Amount (Right) */
        .report-table th:nth-child(7), .report-table td:nth-child(7) { width: 15%; } /* Status (Bara) */
        
        /* Amount columns ke liye Right alignment over-ride karein */
        .report-table th.text-right, .report-table td.text-right { text-align: right !important; }
    `);
    
    printWindow.document.write('</style>');
    printWindow.document.write('</head><body>');
    
    // Content ko .print-container div mein wrap karein
    printWindow.document.write('<div class="print-container">');
    printWindow.document.write(reportHeader); // Header add kiya
    printWindow.document.write(tableHTML); // Table add kiya
    printWindow.document.write('</div>');

    printWindow.document.write('</body></html>');
    printWindow.document.close();

    // 4. Print command de aur window band kar dein
    printWindow.onload = function() {
        // Logo path ko naye window mein set karein (Final Fix)
        const logoElement = printWindow.document.querySelector('.report-header img');
        if (logoElement && logoPath) {
            logoElement.src = logoPath; 
        }
        
        // Print aur Close
        printWindow.print();
        printWindow.close(); 
    };
}
</script>
<?php
include_once('includes/footer.php'); 
if (isset($conn) && is_object($conn)) {
    $conn->close();
}
?>