<?php
session_start();
include_once('../config/db.php');
$conn = getDBConnection();

$session_id = $_GET['session_id'] ?? '';
$class_id = $_GET['class_id'] ?? '';
$section_id = $_GET['section_id'] ?? '';
$month_year = $_GET['month_year'] ?? '';

if (empty($session_id)) $session_id = 1;
if (empty($class_id)) $class_id = 1;
if (empty($month_year)) $month_year = date('Y-m');

// School info
$settings = [];
$result = $conn->query("SELECT setting_key, setting_value FROM settings WHERE setting_key IN ('institute.name','institute.address','institute.logo_path', 'institute.phone')");
while ($row = $result->fetch_assoc()) {
    $settings[$row['setting_key']] = $row['setting_value'];
}

$school_name = $settings['institute.name'] ?? '';
$school_address = $settings['institute.address'] ?? '';
$school_phone = $settings['institute.phone'] ?? '';
$school_logo_path = $settings['institute.logo_path'] ?? '';
$school_logo = !empty($school_logo_path) ? '../' . $school_logo_path : '';

$class_id = (int)$class_id;
$section_id_safe = (int)$section_id;
$section_filter = $section_id_safe && $section_id_safe != 0 ? "AND se.section_id = $section_id_safe" : "";

// FIXED QUERY: Alag alag fields select karein aur PHP mein combine karein
$query = "
    SELECT 
        s.id AS student_id,
        s.first_name,
        s.last_name,
        COALESCE(se.roll_no, s.id) AS roll_no,
        s.father_name,
        c.name AS class_name,
        sec.name AS section_name,
        fi.voucher_no,
        fi.month_year,
        fi.issue_date,
        fi.due_date,
        COALESCE(fi.total_amount, 0) AS total_amount, 
        fi.status,
        fi.id as invoice_id
    FROM fee_invoices fi
    INNER JOIN students s ON fi.student_id = s.id
    INNER JOIN student_enrollments se ON s.id = se.student_id AND fi.session_id = se.session_id
    INNER JOIN academic_classes c ON se.class_id = c.id
    LEFT JOIN academic_sections sec ON se.section_id = sec.id
    WHERE fi.session_id = ?
      AND se.class_id = ? 
      $section_filter
      AND fi.month_year = ?
    ORDER BY se.roll_no ASC, s.id ASC
";

$stmt = $conn->prepare($query);
$stmt->bind_param("iis", $session_id, $class_id, $month_year);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows == 0) {
    die("<h3 style='color:red;text-align:center;margin-top:50px;'>No vouchers found for the selected criteria.</h3>");
}

// FIX: fetch_all() ki jagah while loop use karein aur student name manually combine karein
$vouchers_data = [];
while ($row = $result->fetch_assoc()) {
    // Student name manually combine karein
    $row['student_name'] = $row['first_name'] . ' ' . $row['last_name'];
    $vouchers_data[] = $row;
}

/**
 * 🔑 Due Date Year Fix Function (Invalid dates/0000-00-00 ko handle karta hai)
 */
function format_date_safe($date_string) {
    if (empty($date_string) || $date_string === '0000-00-00') {
        return 'N/A';
    }
    $timestamp = strtotime($date_string);
    if ($timestamp === false || date('Y', $timestamp) < 2000) { 
        return 'N/A';
    }
    return date('d-M-Y', $timestamp);
}

/**
 * Function to get assigned fees for a student invoice
 */
function getAssignedFees($conn, $invoice_id) {
    $fees_query = "
        SELECT fii.fee_type, fii.description, fii.amount 
        FROM fee_invoice_items fii 
        WHERE fii.invoice_id = ? 
        ORDER BY fii.id ASC
    ";
    $stmt = $conn->prepare($fees_query);
    $stmt->bind_param("i", $invoice_id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    $fees = [];
    while ($row = $result->fetch_assoc()) {
        $fees[] = $row;
    }
    return $fees;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Fee Voucher Print</title>
<style>
@page {
    size: A4 landscape;
    margin: 5mm;
}
body {
    font-family: Arial, sans-serif;
    margin: 0;
    padding: 0;
}
/* 🔑 FIX 1: Teen voucher ek hi page par horizontal alignment */
.student-voucher-set {
    display: flex;
    justify-content: space-between;
    width: 100%;
    height: auto; 
    min-height: 190mm; /* A4 Landscape height - Size wahi rakha hai */
    margin: 10px auto 10px auto;
    box-sizing: border-box;
    /* Page cutting masle ko hal karne ke liye */
    page-break-after: always; 
    position: relative;
    border-bottom: 2px dashed #ccc; 
}

/* Each voucher box */
.voucher {
    width: 32.5%;
    display: flex;
    flex-direction: column;
    justify-content: space-between;
    border: 1px solid #000;
    padding: 10px;
    box-sizing: border-box;
    position: relative;
    background-color: #fff;
    margin-bottom: 30px; /* Space for footer credit */
    /* Ensure voucher content doesn't break across pages */
    page-break-inside: avoid;
}

/* Dotted separator lines in the center white space */
.student-voucher-set::before,
.student-voucher-set::after {
    content: "";
    position: absolute;
    top: 0;
    /* 🔑 DOTTED LINE FIX: Height ko voucher box ke barabar kiya */
    height: calc(100% - 30px); /* 30px margin-bottom (footer credit) ko exclude kiya */
    border-right: 2px dotted #000;
}
.student-voucher-set::before {
    left: 33.1%;
}
.student-voucher-set::after {
    left: 66.8%;
}

/* Headers */
.voucher-header {
    text-align: center;
    border-bottom: 1px solid #000;
    padding-bottom: 4px;
}
.voucher-header img {
    width: 45px;
    height: 45px;
    object-fit: contain;
    display: block;
    margin: 0 auto 4px;
}
.voucher-header h2 {
    font-size: 14px;
    margin: 0;
}
.voucher-header p {
    font-size: 10px;
    margin: 2px 0;
}
.copy-label {
    text-align: right;
    font-weight: bold;
    font-size: 11px;
    margin-top: 2px;
    border-bottom: 1px solid #000;
    padding-bottom: 3px;
}

/* Details & Tables */
.details, .fees {
    width: 100%;
    border-collapse: collapse;
    font-size: 10px;
    margin-top: 4px;
}
.details td, .fees td, .fees th {
    border: 1px solid #000;
    padding: 2px 4px;
}
.fees th {
    background-color: #f5f5f5;
}
.total {
    font-weight: bold;
    background-color: #f0f0f0;
}

/* Signature section */
.signatures {
    display: flex;
    justify-content: space-between;
    margin-top: 60px; 
}
.signatures div {
    width: 45%;
    text-align: center;
    font-size: 10px;
    border-top: 1px solid #000;
    padding-top: 5px;
}

/* Footer Credit style - Har voucher ke neeche fixed position */
.footer-credit {
    text-align: center;
    font-size: 8px;
    color: #555;
    /* VOUCHER KE ANDAR ABSOLUTE POSITION DEIN */
    position: absolute;
    bottom: -20px;
    width: calc(100% - 20px); /* Padding adjust kiya */
    left: 10px;
}

/* Print styling */
@media print {
    .no-print { display: none; }
    body { margin: 0; padding: 0; }
    .student-voucher-set {
        /* Ensure har set ke baad naya page ho */
        page-break-after: always; 
        margin: 0;
        border-bottom: none;
        padding-bottom: 5mm;
    }
}

</style>
</head>
<body>
<div class="no-print" style="text-align:center;padding:10px;">
    <button onclick="window.print()">🖨 Print Vouchers</button>
    <p style="font-size:12px;color:red;">**Important:** Printer layout ko **Landscape** aur scale ko **Default** par set karein taake ek hi page par teen aayen.</p>
</div>

<?php 
// Debugging ke liye
// echo "<!-- Total Vouchers: " . count($vouchers_data) . " -->";
// echo "<!-- Sample Data: " . print_r($vouchers_data[0] ?? 'No data', true) . " -->";

foreach ($vouchers_data as $row): 
    $month_name = date('F Y', strtotime($row['month_year'].'-01'));
    // 🔑 Fix: Safe date formatting use karein
    $issue_date_formatted = format_date_safe($row['issue_date']);
    $due_date_formatted = format_date_safe($row['due_date']);
    
    // Get assigned fees for this invoice
    $assigned_fees = getAssignedFees($conn, $row['invoice_id']);
?>
<div class="student-voucher-set">
<?php 
for ($i = 1; $i <= 3; $i++): 
    $copy_type = ($i == 1) ? 'BANK COPY' : (($i == 2) ? 'SCHOOL COPY' : 'STUDENT COPY');
?>
    <div class="voucher">
        <div>
            <div class="voucher-header">
                <?php if ($school_logo): ?>
                    <img src="<?php echo $school_logo; ?>" alt="Logo">
                <?php endif; ?>
                <h2><?php echo htmlspecialchars($school_name); ?></h2>
                <p><?php echo htmlspecialchars($school_address); ?></p>
                <?php if (!empty($school_phone)): ?>
                    <p style="font-size: 10px; margin: 0; padding-bottom: 4px;">Phone No: <?php echo htmlspecialchars($school_phone); ?></p> <?php endif; ?>
            </div>

            <div class="copy-label"><?php echo $copy_type; ?></div>

            <table class="details">
                <tr>
                    <td><b>Student Name:</b> <?php echo htmlspecialchars($row['student_name']); ?></td>
                    <td><b>Father Name:</b> <?php echo htmlspecialchars($row['father_name']); ?></td>
                </tr>
                <tr>
                    <td><b>Class (Section):</b> <?php echo htmlspecialchars($row['class_name'].' ('.$row['section_name'].')'); ?></td>
                    <td><b>Roll No:</b> <?php echo htmlspecialchars($row['roll_no']); ?></td>
                </tr>
                <tr>
                    <td><b>Slip ID:</b> <?php echo htmlspecialchars($row['voucher_no']); ?></td>
                    <td><b>Month:</b> <?php echo htmlspecialchars($month_name); ?></td>
                </tr>
                 <tr>
                    <td><b>Issue Date:</b> **<?php echo $issue_date_formatted; ?>**</td>
                    <td><b>Due Date:</b> **<?php echo $due_date_formatted; ?>**</td>
                </tr>
            </table>

            <table class="fees" style="margin-top:10px;">
                <tr><th>Particular</th><th>Amount (Rs)</th></tr>
                <?php 
                $total_amount = 0;
                foreach ($assigned_fees as $fee): 
                    $total_amount += $fee['amount'];
                ?>
                <tr>
                    <td><?php echo htmlspecialchars(ucfirst($fee['fee_type']) . ' Fee'); ?></td>
                    <td style="text-align:right;"><?php echo number_format($fee['amount'], 2); ?></td>
                </tr>
                <?php endforeach; ?>
                <tr class="total">
                    <td><strong>Total</strong></td>
                    <td style="text-align:right;"><strong><?php echo number_format($total_amount, 2); ?></strong></td>
                </tr>
            </table>
            
            <p style="font-size:10px;margin-top:8px;">
                <b>Valid up to:</b> **<?php echo $due_date_formatted; ?>**<br>
                <b>Note:</b> Fee due date tak jama karayein.
            </p>
        </div>

        <div class="signatures">
            <div>Cashier</div>
            <div>Principal</div>
        </div>
        
        <div class="footer-credit">
            Software Developed By **Liva Solutions** - www.livasol.com
        </div>
    </div>
<?php endfor; ?>
</div>
<?php endforeach; ?>
</body>
</html>