<?php
// admin/fees_generate.php - COMPLETE CODE (Final Fix: Using Aliases to resolve unknown column error)
session_start();
// Database connection aur zaroori functions ke liye
include_once('../config/db.php'); 

// Header aur Sidebar includes
include_once('includes/header.php'); 

$conn = getDBConnection();
$message = $_GET['msg'] ?? '';
$error = $_GET['err'] ?? '';

// Current Session ID fetch karein
$settings_result = $conn->query("SELECT setting_value FROM settings WHERE setting_key='academic.active_session_id'");
$current_session_id = $settings_result->fetch_assoc()['setting_value'] ?? 1;

// Classes ko fetch karein dropdown ke liye
$classes_result = $conn->query("SELECT id, name AS name FROM academic_classes ORDER BY order_no ASC");
$classes = $classes_result->fetch_all(MYSQLI_ASSOC);

// Sections ko fetch karein dropdown ke liye
$sections_result = $conn->query("SELECT id, name AS name FROM academic_sections ORDER BY name ASC");
$sections = $sections_result->fetch_all(MYSQLI_ASSOC);

$conn->close();
?>

<h1 class="mb-4">Fees Voucher Generation & Print <i class="fas fa-print"></i></h1>

<?php if ($message): ?>
    <div class="alert alert-success"><?php echo htmlspecialchars($message); ?></div>
<?php endif; ?>
<?php if ($error): ?>
    <div class="alert alert-danger"><?php echo htmlspecialchars($error); ?></div>
<?php endif; ?>

<div class="card p-4 mb-4">
    
    <h3 class="card-title">1. Generate Monthly Fees Vouchers</h3>
    <p class="text-info">
        Yeh process **current active session (ID: <?php echo $current_session_id; ?>)** ke students ke liye fees voucher banayega.
        **Jo vouchers pehle se maujood hain, woh skip ho jayenge.**
    </p>

    <form action="fees_process.php" method="POST" onsubmit="return confirm('WARNING: Kya aap is month ke liye fees vouchers database mein generate karna chahte hain?');">
        <input type="hidden" name="action" value="generate_vouchers">
        <input type="hidden" name="session_id" value="<?php echo $current_session_id; ?>">
        
        <div class="form-row">
            <div class="form-group col-md-3">
                <label>Month & Year (Fee Due):</label>
                <input type="month" name="month_year" class="form-control" value="<?php echo date('Y-m'); ?>" required>
            </div>
            <div class="form-group col-md-3">
                <label>Issue Date (Voucher Date):</label>
                <input type="date" name="issue_date" class="form-control" value="<?php echo date('Y-m-d'); ?>" required>
            </div>
            <div class="form-group col-md-3">
                <label>Due Date:</label>
                <input type="date" name="due_date" class="form-control" value="<?php echo date('Y-m-d', strtotime('+10 days')); ?>" required>
            </div>
            <div class="form-group col-md-3">
                <label>Select Class (Optional for filter):</label>
                <select name="class_id" class="form-control">
                    <option value="0">All Classes (Single Click)</option>
                    <?php foreach ($classes as $class): ?>
                        <option value="<?php echo $class['id']; ?>">
                            <?php echo htmlspecialchars($class['name']); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="form-group col-md-3">
                <label>Section (Optional for filter):</label>
                <select name="section_id" class="form-control">
                    <option value="0">All Sections</option>
                    <?php foreach ($sections as $section): ?>
                        <option value="<?php echo $section['id']; ?>">
                            <?php echo htmlspecialchars($section['name']); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
        </div>
        <button type="submit" class="btn btn-primary btn-lg mt-3">
            <i class="fas fa-magic"></i> Generate Vouchers
        </button>
    </form>
</div>

<div class="card p-4">
    <h3 class="card-title">2. Print Fees Vouchers (Class/Student Wise)</h3>
    
    <h4 class="mt-4">2A. Class/Section Wise Print (Bulk Print)</h4>
    <form class="form-row" action="fee_voucher_print.php" method="GET" target="_blank">
        <input type="hidden" name="session_id" value="<?php echo $current_session_id; ?>">
        <div class="form-group col-md-3">
            <label>Fee Month:</label>
            <input type="month" name="month_year" class="form-control" value="<?php echo date('Y-m'); ?>" required>
        </div>
        <div class="form-group col-md-3">
            <label>Select Class (Required):</label>
            <select name="class_id" class="form-control" required>
                <option value="">Select Class --</option>
                <?php foreach ($classes as $class): ?>
                    <option value="<?php echo $class['id']; ?>">
                        <?php echo htmlspecialchars($class['name']); ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="form-group col-md-3">
            <label>Section (Optional):</label>
            <select name="section_id" class="form-control">
                <option value="0">All Sections</option>
                <?php foreach ($sections as $section): ?>
                    <option value="<?php echo $section['id']; ?>">
                        <?php echo htmlspecialchars($section['name']); ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="form-group col-md-3 d-flex align-items-end">
            <button type="submit" class="btn btn-warning btn-block">
                <i class="fas fa-print"></i> Print Vouchers
            </button>
        </div>
    </form>

    <hr>

    <h4 class="mt-4">2B. Student Wise Print (Search for Re-Print)</h4>
    <form class="form-row" action="fees_vouchers.php" method="GET">
        <div class="form-group col-md-6">
            <label>Search Student Name/Roll/Voucher No:</label>
            <input type="text" name="v_search" class="form-control" placeholder="Mubeshir, 101, VCHR-1001..." required>
        </div>
        <div class="form-group col-md-6 d-flex align-items-end">
            <button type="submit" class="btn btn-info btn-block">
                <i class="fas fa-search"></i> Search Vouchers
            </button>
        </div>
    </form>
    <p class="mt-2 text-muted"><small>Search karne ke baad, aapko list mein se student ka voucher mil jayega jahan se aap usko print kar sakte hain.</small></p>

</div>

<?php
include_once('includes/footer.php'); 
?>