<?php
// admin/fees_vouchers.php - COLLECT FEE PAYMENT ONLY
session_start();
include_once('includes/header.php'); 

$conn = getDBConnection();
$message = $_GET['msg'] ?? '';
$error = $_GET['err'] ?? '';
$v_search = $_GET['v_search'] ?? '';

// Current Session ID fetch karein
$settings_result = $conn->query("SELECT setting_value FROM settings WHERE setting_key='academic.active_session_id'");
$current_session_id = $settings_result->fetch_assoc()['setting_value'] ?? 1;

$search_results = [];
$student_invoices = [];
$student_info = null;

// ====================================================================
// VOUCHER SEARCH LOGIC - ALL VOUCHERS (PAID + UNPAID + PARTIAL)
// ====================================================================
if (isset($_POST['voucher_no']) || !empty($v_search)) {
    $voucher_no_search = $_POST['voucher_no'] ?? $v_search;
    
    // Search term sanitize karein
    $search_term = $conn->real_escape_string($voucher_no_search);
    
    // IMPROVED SEARCH QUERY - ALL VOUCHERS (paid, unpaid, partial)
    $voucher_query = "
        SELECT DISTINCT
            fi.id,
            fi.voucher_no,
            fi.month_year,
            fi.issue_date,
            fi.due_date,
            fi.total_amount,
            fi.amount_paid,
            fi.net_payable,
            fi.status,
            fi.student_id,
            s.first_name,
            s.last_name, 
            s.father_name,
            c.name as class_name,
            sec.name as section_name,
            en.roll_no
        FROM fee_invoices fi
        INNER JOIN students s ON fi.student_id = s.id
        INNER JOIN student_enrollments en ON s.id = en.student_id AND fi.session_id = en.session_id
        INNER JOIN academic_classes c ON en.class_id = c.id
        LEFT JOIN academic_sections sec ON en.section_id = sec.id
        WHERE (fi.voucher_no = '{$search_term}' 
               OR s.first_name LIKE '%{$search_term}%' 
               OR s.last_name LIKE '%{$search_term}%'
               OR en.roll_no = '{$search_term}'
               OR CONCAT(s.first_name, ' ', s.last_name) LIKE '%{$search_term}%')
        AND fi.session_id = {$current_session_id}
        ORDER BY fi.month_year DESC, c.name ASC, en.roll_no ASC
    ";
    
    $search_result = $conn->query($voucher_query);
    
    if ($search_result && $search_result->num_rows > 0) {
        // fetch_all() ki jagah while loop use karein
        while ($row = $search_result->fetch_assoc()) {
            $row['student_name'] = $row['first_name'] . ' ' . $row['last_name'];
            $search_results[] = $row;
        }

        // Agar results milen, to student ki saari invoices load karein
        if (count($search_results) > 0) {
            $student_id = $search_results[0]['student_id'];
            $student_info = [
                'id' => $student_id,
                'name' => $search_results[0]['first_name'] . ' ' . $search_results[0]['last_name'],
                'father_name' => $search_results[0]['father_name'],
                'class_name' => $search_results[0]['class_name'],
                'section_name' => $search_results[0]['section_name'],
                'roll_no' => $search_results[0]['roll_no']
            ];

            // Student ki SAARI invoices fetch karein (paid bhi)
            $invoices_query = "
                SELECT 
                    fi.id,
                    fi.voucher_no,
                    fi.month_year,
                    fi.issue_date,
                    fi.due_date,
                    fi.total_amount,
                    fi.amount_paid,
                    fi.net_payable,
                    fi.status,
                    fi.student_id
                FROM fee_invoices fi
                WHERE fi.student_id = {$student_id} 
                AND fi.session_id = {$current_session_id}
                ORDER BY fi.month_year ASC
            ";
            
            $invoices_result = $conn->query($invoices_query);
            if ($invoices_result) {
                while ($invoice_row = $invoices_result->fetch_assoc()) {
                    $student_invoices[] = $invoice_row;
                }
            }
        }
    }
}

$conn->close();
?>

<div class="container-fluid">
    <!-- Page Header -->
    <div class="page-header">
        <div class="row align-items-center">
            <div class="col">
                <h1 class="h3 mb-0 text-gray-800">
                    <i class="fas fa-hand-holding-usd me-2"></i>
                    Collect Fee Payment
                </h1>
                <p class="text-muted mb-0">Search student and collect fee payment</p>
            </div>
            <div class="col-auto">
                <a href="fees_vouchers_list.php" class="btn btn-primary">
                    <i class="fas fa-list me-2"></i>View All Vouchers
                </a>
            </div>
        </div>
    </div>

    <?php if ($message): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="fas fa-check-circle me-2"></i><?php echo htmlspecialchars($message); ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>
    
    <?php if ($error): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="fas fa-exclamation-triangle me-2"></i><?php echo htmlspecialchars($error); ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <!-- Search Card -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">
                <i class="fas fa-search me-2"></i>Search Student
            </h6>
        </div>
        <div class="card-body">
            <form action="fees_vouchers.php" method="POST">
                <div class="row">
                    <div class="col-md-8">
                        <div class="form-group">
                            <label class="form-label">Enter Student Name, Roll No, or Voucher Code</label>
                            <input type="text" name="voucher_no" class="form-control form-control-lg" 
                                   placeholder="e.g., VCHR-1159, Mubeshir, 25" 
                                   value="<?php echo htmlspecialchars($voucher_no_search ?? ''); ?>" required>
                        </div>
                    </div>
                    <div class="col-md-4 d-flex align-items-end">
                        <div class="d-grid gap-2 w-100">
                            <button type="submit" class="btn btn-primary btn-lg">
                                <i class="fas fa-search me-2"></i> Search Student
                            </button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Search Results -->
    <?php if (!empty($search_results) && count($search_results) > 1): ?>
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-warning">
                    <i class="fas fa-users me-2"></i>Multiple Students Found
                </h6>
            </div>
            <div class="card-body">
                <div class="alert alert-warning">
                    <strong>Multiple students found for "<?php echo htmlspecialchars($voucher_no_search); ?>".</strong> 
                    Please select the correct student:
                </div>
                
                <div class="row">
                    <?php foreach ($search_results as $res): 
                        $due_amount = (float)$res['net_payable'] - (float)$res['amount_paid'];
                        $status_badge = '';
                        switch($res['status']) {
                            case 'paid': $status_badge = 'success'; break;
                            case 'partial': $status_badge = 'warning'; break;
                            default: $status_badge = 'danger'; break;
                        }
                    ?>
                    <div class="col-md-6 mb-3">
                        <div class="card border-left-<?php echo $status_badge; ?> shadow h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-<?php echo $status_badge; ?> text-uppercase mb-1">
                                            <?php echo htmlspecialchars($res['first_name'] . ' ' . $res['last_name']); ?>
                                        </div>
                                        <div class="h6 mb-1 text-gray-800">
                                            <i class="fas fa-user me-1"></i>
                                            <?php echo htmlspecialchars($res['father_name']); ?>
                                        </div>
                                        <div class="text-xs text-muted mb-1">
                                            <i class="fas fa-graduation-cap me-1"></i>
                                            <?php echo htmlspecialchars($res['class_name'] . ' (' . ($res['section_name'] ?? 'N/A') . ')'); ?>
                                        </div>
                                        <div class="text-xs text-muted mb-2">
                                            <i class="fas fa-hashtag me-1"></i>
                                            Roll No: <?php echo htmlspecialchars($res['roll_no']); ?> | 
                                            Voucher: <?php echo htmlspecialchars($res['voucher_no']); ?>
                                        </div>
                                        <div class="d-flex justify-content-between align-items-center">
                                            <span class="badge badge-<?php echo $status_badge; ?>">
                                                <?php echo ucfirst($res['status']); ?>
                                            </span>
                                            <span class="text-danger font-weight-bold">
                                                Rs. <?php echo number_format($due_amount, 2); ?>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="card-footer text-center">
                                <a href="fees_vouchers.php?v_search=<?php echo htmlspecialchars($res['voucher_no']); ?>" 
                                   class="btn btn-sm btn-success">
                                    <i class="fas fa-hand-holding-usd me-1"></i> Select & Pay
                                </a>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>

    <?php elseif (!empty($student_invoices) && $student_info): ?>
        <!-- Student Found - Show Invoices -->
        <div class="row">
            <div class="col-lg-12">
                <!-- Student Info Card -->
                <div class="card shadow mb-4 border-left-success">
                    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                        <h6 class="m-0 font-weight-bold text-success">
                            <i class="fas fa-user-graduate me-2"></i>Student Information
                        </h6>
                        <div class="dropdown no-arrow">
                            <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink" 
                               data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-400"></i>
                            </a>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-3 text-center">
                                <div class="icon-circle bg-success">
                                    <i class="fas fa-user text-white"></i>
                                </div>
                                <h5 class="mt-2 mb-1"><?php echo htmlspecialchars($student_info['name']); ?></h5>
                                <p class="text-muted mb-0">Student</p>
                            </div>
                            <div class="col-md-9">
                                <div class="row">
                                    <div class="col-md-4">
                                        <strong><i class="fas fa-user-friends me-2"></i>Father Name:</strong>
                                        <p class="text-gray-800"><?php echo htmlspecialchars($student_info['father_name']); ?></p>
                                    </div>
                                    <div class="col-md-3">
                                        <strong><i class="fas fa-graduation-cap me-2"></i>Class:</strong>
                                        <p class="text-gray-800"><?php echo htmlspecialchars($student_info['class_name']); ?></p>
                                    </div>
                                    <div class="col-md-3">
                                        <strong><i class="fas fa-users me-2"></i>Section:</strong>
                                        <p class="text-gray-800"><?php echo htmlspecialchars($student_info['section_name']); ?></p>
                                    </div>
                                    <div class="col-md-2">
                                        <strong><i class="fas fa-hashtag me-2"></i>Roll No:</strong>
                                        <p class="text-gray-800"><?php echo htmlspecialchars($student_info['roll_no']); ?></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Invoices Table -->
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">
                            <i class="fas fa-file-invoice me-2"></i>Fee Invoices
                        </h6>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-bordered" width="100%" cellspacing="0">
                                <thead class="thead-light">
                                    <tr>
                                        <th>Select</th>
                                        <th>Voucher #</th>
                                        <th>Month</th>
                                        <th>Due Date</th>
                                        <th>Total Amount</th>
                                        <th>Paid Amount</th>
                                        <th>Balance Due</th>
                                        <th>Status</th>
                                        <th>Print</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php 
                                    $total_balance_due = 0;
                                    foreach ($student_invoices as $invoice): 
                                        $balance_due = (float)$invoice['net_payable'] - (float)$invoice['amount_paid'];
                                        $total_balance_due += $balance_due;
                                        $month_name = date('F Y', strtotime($invoice['month_year'] . '-01'));
                                        
                                        // Status ke liye class determine karein
                                        $status_class = '';
                                        $is_selectable = true;
                                        switch($invoice['status']) {
                                            case 'paid': 
                                                $status_class = 'success'; 
                                                $is_selectable = false;
                                                break;
                                            case 'partial': 
                                                $status_class = 'warning'; 
                                                break;
                                            default: 
                                                $status_class = 'danger'; 
                                                break;
                                        }
                                    ?>
                                    <tr>
                                        <td class="text-center">
                                            <?php if ($is_selectable && $balance_due > 0): ?>
                                                <input type="radio" name="selected_invoice" value="<?php echo $invoice['id']; ?>" 
                                                       data-balance="<?php echo $balance_due; ?>"
                                                       data-month="<?php echo $month_name; ?>"
                                                       data-voucher="<?php echo $invoice['voucher_no']; ?>"
                                                       onchange="updatePaymentForm(this)"
                                                       required>
                                            <?php else: ?>
                                                <i class="fas fa-check text-muted" title="Already paid"></i>
                                            <?php endif; ?>
                                        </td>
                                        <td class="font-weight-bold text-primary">
                                            <?php echo htmlspecialchars($invoice['voucher_no']); ?>
                                        </td>
                                        <td><?php echo $month_name; ?></td>
                                        <td><?php echo date('d-M-Y', strtotime($invoice['due_date'])); ?></td>
                                        <td class="text-right font-weight-bold">
                                            Rs. <?php echo number_format($invoice['net_payable'], 2); ?>
                                        </td>
                                        <td class="text-right text-success">
                                            Rs. <?php echo number_format($invoice['amount_paid'], 2); ?>
                                        </td>
                                        <td class="text-right font-weight-bold <?php echo ($balance_due > 0) ? 'text-danger' : 'text-success'; ?>">
                                            Rs. <?php echo number_format($balance_due, 2); ?>
                                        </td>
                                        <td class="text-center">
                                            <span class="badge badge-<?php echo $status_class; ?>">
                                                <?php echo ucfirst($invoice['status']); ?>
                                            </span>
                                        </td>
                                        <td class="text-center">
                                            <a href="fee_voucher_print.php?invoice_id=<?php echo $invoice['id']; ?>" 
                                               target="_blank" class="btn btn-sm btn-outline-info">
                                                <i class="fas fa-print"></i>
                                            </a>
                                        </td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                                <tfoot>
                                    <tr class="table-warning">
                                        <td colspan="6" class="text-right font-weight-bold">Total Balance Due:</td>
                                        <td class="font-weight-bold text-danger text-right">
                                            Rs. <?php echo number_format($total_balance_due, 2); ?>
                                        </td>
                                        <td colspan="2"></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>

                <!-- Payment Form -->
                <?php if ($total_balance_due > 0): ?>
                <div class="card shadow mb-4">
                    <div class="card-header py-3 bg-success">
                        <h6 class="m-0 font-weight-bold text-white">
                            <i class="fas fa-money-bill-wave me-2"></i>Record Payment
                        </h6>
                    </div>
                    <div class="card-body">
                        <form action="fees_process.php" method="POST" id="paymentForm">
                            <input type="hidden" name="action" value="record_payment">
                            <input type="hidden" name="invoice_id" id="invoice_id">
                            
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="font-weight-bold text-primary">Selected Voucher:</label>
                                        <p id="selected_voucher" class="form-control-plaintext font-weight-bold text-primary">
                                            Please select an unpaid invoice above
                                        </p>
                                    </div>
                                    
                                    <div class="form-group">
                                        <label class="font-weight-bold text-primary">Selected Month:</label>
                                        <p id="selected_month" class="form-control-plaintext text-primary">-</p>
                                    </div>
                                    
                                    <div class="form-group">
                                        <label class="font-weight-bold text-danger">Balance Due:</label>
                                        <p id="balance_due" class="form-control-plaintext font-weight-bold text-danger">
                                            Rs. 0.00
                                        </p>
                                    </div>
                                    
                                    <div class="form-group">
                                        <label for="amount_received" class="font-weight-bold">Amount Receiving (Rs.):</label>
                                        <input type="number" step="0.01" name="amount_received" id="amount_received" 
                                               class="form-control form-control-lg" min="0" required disabled>
                                        <small class="form-text text-muted">Enter the amount you are receiving from student</small>
                                    </div>
                                </div>
                                
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="payment_date" class="font-weight-bold">Payment Date:</label>
                                        <input type="date" name="payment_date" class="form-control" value="<?php echo date('Y-m-d'); ?>" required>
                                    </div>
                                    
                                    <div class="form-group">
                                        <label for="payment_method" class="font-weight-bold">Payment Method:</label>
                                        <select name="payment_method" class="form-control" required>
                                            <option value="Cash">Cash</option>
                                            <option value="Bank Transfer">Bank Transfer</option>
                                            <option value="Cheque">Cheque</option>
                                            <option value="Online">Online</option>
                                            <option value="Other">Other</option>
                                        </select>
                                    </div>
                                    
                                    <div class="form-group">
                                        <label for="remarks" class="font-weight-bold">Remarks (Optional):</label>
                                        <input type="text" name="remarks" class="form-control" placeholder="Any additional notes">
                                    </div>

                                    <div class="form-group">
                                        <label for="receipt_no" class="font-weight-bold">Receipt No (Optional):</label>
                                        <input type="text" name="receipt_no" class="form-control" placeholder="Auto-generated if left empty">
                                    </div>
                                </div>
                            </div>
                            
                            <div class="text-center mt-4">
                                <button type="submit" class="btn btn-success btn-lg px-5" id="submitBtn" disabled>
                                    <i class="fas fa-check-circle me-2"></i> Submit Payment
                                </button>
                            </div>
                            
                            <div class="alert alert-info mt-4">
                                <i class="fas fa-info-circle me-2"></i>
                                <strong>Note:</strong> After payment, voucher status will be updated to 'paid' and student will be marked as fee paid for selected month.
                            </div>
                        </form>
                    </div>
                </div>
                <?php else: ?>
                <div class="card shadow mb-4 border-left-success">
                    <div class="card-body text-center py-5">
                        <i class="fas fa-check-circle fa-4x text-success mb-3"></i>
                        <h3 class="text-success">All Fees Paid</h3>
                        <p class="text-muted mb-4">This student has no pending fees. All invoices are fully paid.</p>
                        <a href="fees_vouchers.php" class="btn btn-primary">
                            <i class="fas fa-search me-2"></i> Search Another Student
                        </a>
                    </div>
                </div>
                <?php endif; ?>

            </div>
        </div>

    <?php elseif (isset($_POST['voucher_no']) || !empty($v_search)): ?>
        <!-- No Student Found -->
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-warning">
                    <i class="fas fa-search me-2"></i>Search Results
                </h6>
            </div>
            <div class="card-body text-center py-5">
                <i class="fas fa-search fa-4x text-warning mb-3"></i>
                <h3 class="text-warning">No Student Found</h3>
                <p class="text-muted mb-4">
                    No student found for "<strong><?php echo htmlspecialchars($voucher_no_search); ?></strong>" in the current session.
                </p>
                
                <div class="row justify-content-center">
                    <div class="col-md-8">
                        <div class="alert alert-light border">
                            <h6 class="alert-heading"><i class="fas fa-lightbulb me-2"></i>What to do next?</h6>
                            <ul class="mb-0 text-left">
                                <li>Check spelling of student name or voucher number</li>
                                <li>Verify student is enrolled in current session</li>
                                <li>Check <a href="fees_vouchers_list.php" class="alert-link">All Vouchers List</a> to see all generated vouchers</li>
                                <li>Make sure fee vouchers are generated for this student</li>
                            </ul>
                        </div>
                    </div>
                </div>
                
                <a href="fees_vouchers.php" class="btn btn-primary mt-3">
                    <i class="fas fa-redo me-2"></i> Try Another Search
                </a>
            </div>
        </div>
    <?php endif; ?>
</div>

<script>
// Update payment form when invoice is selected
function updatePaymentForm(radio) {
    const balanceDue = parseFloat(radio.getAttribute('data-balance'));
    const monthName = radio.getAttribute('data-month');
    const voucherNo = radio.getAttribute('data-voucher');
    const invoiceId = radio.value;
    
    document.getElementById('selected_voucher').textContent = voucherNo;
    document.getElementById('selected_month').textContent = monthName;
    document.getElementById('balance_due').textContent = 'Rs. ' + balanceDue.toLocaleString('en-PK', {minimumFractionDigits: 2});
    document.getElementById('invoice_id').value = invoiceId;
    
    const amountInput = document.getElementById('amount_received');
    amountInput.value = balanceDue;
    amountInput.max = balanceDue;
    amountInput.disabled = false;
    
    document.getElementById('submitBtn').disabled = false;
}

// Form validation
document.getElementById('paymentForm').addEventListener('submit', function(e) {
    const amountReceived = parseFloat(document.getElementById('amount_received').value);
    const balanceDue = parseFloat(document.getElementById('balance_due').textContent.replace('Rs. ', '').replace(/,/g, ''));
    
    if (amountReceived > balanceDue) {
        e.preventDefault();
        alert('Amount received cannot be greater than balance due!');
        return false;
    }
    
    if (amountReceived <= 0) {
        e.preventDefault();
        alert('Please enter a valid amount!');
        return false;
    }
});

// Auto focus on search input
document.addEventListener('DOMContentLoaded', function() {
    const searchInput = document.querySelector('input[name="voucher_no"]');
    if (searchInput && !searchInput.value) {
        searchInput.focus();
    }
});
</script>

<?php
include_once('includes/footer.php'); 
?>