<?php
// admin/fees_vouchers.php - COMPLETE CODE (FIXED: Student Name Issue)
session_start();
// Database connection aur zaroori functions ke liye
include_once('../config/db.php'); 

// Header aur Sidebar includes
include_once('includes/header.php'); 
include_once('includes/sidebar.php');

$conn = getDBConnection();
$message = $_GET['msg'] ?? '';
$error = $_GET['err'] ?? '';

// Current Session ID fetch karein
$settings_result = $conn->query("SELECT setting_value FROM settings WHERE setting_key='academic.active_session_id'");
$current_session_id = $settings_result->fetch_assoc()['setting_value'] ?? 1;

// Classes ko fetch karein dropdown ke liye
$classes_result = $conn->query("SELECT id, name FROM academic_classes ORDER BY order_no ASC");
$classes = $classes_result->fetch_all(MYSQLI_ASSOC);

// Sections ko fetch karein dropdown ke liye
$sections_result = $conn->query("SELECT id, name FROM academic_sections ORDER BY name ASC");
$sections = $sections_result->fetch_all(MYSQLI_ASSOC);

// Search parameters
$search_class = $_GET['class_id'] ?? '';
$search_section = $_GET['section_id'] ?? '';
$search_month = $_GET['month_year'] ?? date('Y-m');
$search_status = $_GET['status'] ?? '';

// Base query for vouchers - COMPLETELY FIXED
$vouchers_query = "
    SELECT 
        fi.id,
        fi.voucher_no,
        fi.month_year,
        fi.issue_date,
        fi.due_date,
        fi.total_amount,
        fi.amount_paid,
        fi.net_payable,
        fi.status,
        fi.student_id,
        s.first_name,
        s.last_name, 
        s.father_name,
        c.name as class_name,
        sec.name as section_name,
        en.roll_no
    FROM fee_invoices fi
    INNER JOIN students s ON fi.student_id = s.id
    INNER JOIN student_enrollments en ON s.id = en.student_id AND fi.session_id = en.session_id
    INNER JOIN academic_classes c ON en.class_id = c.id
    LEFT JOIN academic_sections sec ON en.section_id = sec.id
    WHERE fi.session_id = {$current_session_id}
";

// Apply search filters
if (!empty($search_class)) {
    $vouchers_query .= " AND en.class_id = " . intval($search_class);
}

if (!empty($search_section)) {
    $vouchers_query .= " AND en.section_id = " . intval($search_section);
}

if (!empty($search_month)) {
    $vouchers_query .= " AND fi.month_year = '" . $conn->real_escape_string($search_month) . "'";
}

if (!empty($search_status)) {
    $vouchers_query .= " AND fi.status = '" . $conn->real_escape_string($search_status) . "'";
}

$vouchers_query .= " ORDER BY fi.month_year DESC, c.name ASC, en.roll_no ASC, fi.id DESC";

// Debugging ke liye
// echo "<!-- Query: " . htmlspecialchars($vouchers_query) . " -->";

$vouchers_result = $conn->query($vouchers_query);

// FIX: fetch_all() ki jagah while loop use karein
$vouchers = [];
if ($vouchers_result) {
    while ($row = $vouchers_result->fetch_assoc()) {
        // Student name manually combine karein
        $row['student_name'] = $row['first_name'] . ' ' . $row['last_name'];
        $vouchers[] = $row;
    }
} else {
    // Query error check
    echo "<!-- Query Error: " . $conn->error . " -->";
}

// Debugging ke liye
// echo "<!-- Total Vouchers: " . count($vouchers) . " -->";
// echo "<!-- Sample Data: " . print_r($vouchers[0] ?? 'No data', true) . " -->";

$conn->close();
?>

<!-- Professional CSS Styles -->
<style>
.page-header {
    border-bottom: 1px solid #e3e6f0;
    padding-bottom: 1rem;
    margin-bottom: 2rem;
}

.search-card {
    border: 1px solid #e3e6f0;
    border-radius: 0.5rem;
    box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.15);
}

.search-card .card-header {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    border-radius: 0.5rem 0.5rem 0 0 !important;
    padding: 1rem 1.5rem;
}

.data-table-card {
    border: 1px solid #e3e6f0;
    border-radius: 0.5rem;
    box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.15);
}

.data-table-card .card-body {
    padding: 0;
}

.table th {
    background: #f8f9fc;
    color: #4e73df;
    font-weight: 700;
    border-bottom: 2px solid #e3e6f0;
    padding: 1rem 0.75rem;
    font-size: 0.85rem;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.table td {
    padding: 1rem 0.75rem;
    vertical-align: middle;
    border-color: #e3e6f0;
    font-size: 0.9rem;
}

.table-hover tbody tr:hover {
    background-color: #f8f9fc;
    transform: translateY(-1px);
    transition: all 0.2s ease;
}

.student-name-link {
    color: #4e73df;
    font-weight: 600;
    text-decoration: none;
    transition: color 0.2s ease;
}

.student-name-link:hover {
    color: #2e59d9;
    text-decoration: underline;
}

.badge {
    font-size: 0.75rem;
    font-weight: 600;
    padding: 0.35rem 0.65rem;
    border-radius: 0.35rem;
}

.btn-action {
    border-radius: 0.35rem;
    padding: 0.375rem 0.75rem;
    font-size: 0.8rem;
    margin: 0 2px;
    transition: all 0.2s ease;
}

.btn-action:hover {
    transform: translateY(-1px);
    box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.1);
}

.empty-state {
    padding: 3rem 1rem;
    text-align: center;
    color: #6c757d;
}

.empty-state i {
    font-size: 3rem;
    margin-bottom: 1rem;
    color: #dddfeb;
}

.filter-badge {
    background: #f8f9fc;
    border: 1px solid #e3e6f0;
    border-radius: 0.35rem;
    padding: 0.5rem 1rem;
    font-size: 0.85rem;
}

.form-control, .form-select {
    border: 1px solid #d1d3e2;
    border-radius: 0.35rem;
    padding: 0.75rem 1rem;
    font-size: 0.9rem;
    transition: border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out;
}

.form-control:focus, .form-select:focus {
    border-color: #4e73df;
    box-shadow: 0 0 0 0.2rem rgba(78, 115, 223, 0.25);
}

.btn-primary {
    background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);
    border: none;
    border-radius: 0.35rem;
    padding: 0.75rem 1.5rem;
    font-weight: 600;
    transition: all 0.2s ease;
}

.btn-primary:hover {
    transform: translateY(-1px);
    box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
}

.btn-outline-secondary {
    border: 1px solid #6c757d;
    color: #6c757d;
    border-radius: 0.35rem;
    padding: 0.75rem 1.5rem;
    font-weight: 600;
    transition: all 0.2s ease;
}

.btn-outline-secondary:hover {
    background-color: #6c757d;
    color: white;
    transform: translateY(-1px);
}

.status-unpaid {
    background: linear-gradient(135deg, #e74a3b 0%, #be2617 100%);
    color: white;
}

.status-paid {
    background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%);
    color: white;
}

.status-partial {
    background: linear-gradient(135deg, #f6c23e 0%, #dda20a 100%);
    color: white;
}

.status-pending {
    background: linear-gradient(135deg, #858796 0%, #60616f 100%);
    color: white;
}

.amount-paid {
    color: #1cc88a;
    font-weight: 600;
}

.amount-due {
    color: #e74a3b;
    font-weight: 600;
}

.voucher-count-badge {
    background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);
    color: white !important;
    font-size: 0.8rem;
    font-weight: 600;
    padding: 0.4rem 0.8rem;
    border-radius: 1rem;
    margin-left: 0.5rem;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

/* Header styles for better appearance */
.card-header {
    background: linear-gradient(135deg, #f8f9fc 0%, #e3e6f0 100%);
    border-bottom: 1px solid #e3e6f0;
}

/* Professional table enhancements */
.table-responsive {
    border-radius: 0.5rem;
}

.table > :not(caption) > * > * {
    padding: 1rem 0.75rem;
}

/* Action buttons group styling */
.btn-group .btn-action {
    border-radius: 0.25rem;
    margin: 0 1px;
}

/* Hover effects for better UX */
.card {
    transition: transform 0.2s ease, box-shadow 0.2s ease;
}

.card:hover {
    transform: translateY(-2px);
    box-shadow: 0 0.5rem 1.5rem rgba(0, 0, 0, 0.1);
}

/* Professional color scheme */
:root {
    --primary: #4e73df;
    --success: #1cc88a;
    --warning: #f6c23e;
    --danger: #e74a3b;
    --info: #36b9cc;
}

/* Button group spacing */
.btn-group {
    gap: 2px;
}
</style>

<div class="container-fluid">
    <!-- Page Header -->
    <div class="page-header">
        <div class="row align-items-center">
            <div class="col">
                <h1 class="h3 mb-0 text-gray-800">
                    <i class="fas fa-file-invoice-dollar me-2"></i>
                    Generated Fee Vouchers
                </h1>
                <p class="text-muted mb-0">View and manage all generated fee vouchers</p>
            </div>
            <div class="col-auto">
                <a href="fees_generate.php" class="btn btn-primary">
                    <i class="fas fa-plus me-2"></i>Generate New Vouchers
                </a>
            </div>
        </div>
    </div>

    <!-- Alert Messages -->
    <?php if ($message): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="fas fa-check-circle me-2"></i><?php echo htmlspecialchars($message); ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>
    
    <?php if ($error): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="fas fa-exclamation-triangle me-2"></i><?php echo htmlspecialchars($error); ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <!-- Search Filters Card -->
    <div class="card search-card mb-4">
        <div class="card-header">
            <h6 class="m-0 font-weight-bold">
                <i class="fas fa-filter me-2"></i>Search & Filter Vouchers
            </h6>
        </div>
        <div class="card-body">
            <form method="GET" action="fees_vouchers_list.php">
                <div class="row">
                    <div class="col-md-3">
                        <label class="form-label">Class</label>
                        <select name="class_id" class="form-select">
                            <option value="">All Classes</option>
                            <?php foreach ($classes as $class): ?>
                                <option value="<?php echo $class['id']; ?>" <?php echo ($search_class == $class['id']) ? 'selected' : ''; ?>>
                                    <?php echo htmlspecialchars($class['name']); ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">Section</label>
                        <select name="section_id" class="form-select">
                            <option value="">All Sections</option>
                            <?php foreach ($sections as $section): ?>
                                <option value="<?php echo $section['id']; ?>" <?php echo ($search_section == $section['id']) ? 'selected' : ''; ?>>
                                    <?php echo htmlspecialchars($section['name']); ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">Month</label>
                        <input type="month" name="month_year" class="form-control" value="<?php echo htmlspecialchars($search_month); ?>">
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">Status</label>
                        <select name="status" class="form-select">
                            <option value="">All Status</option>
                            <option value="unpaid" <?php echo ($search_status == 'unpaid') ? 'selected' : ''; ?>>Unpaid</option>
                            <option value="paid" <?php echo ($search_status == 'paid') ? 'selected' : ''; ?>>Paid</option>
                            <option value="partial" <?php echo ($search_status == 'partial') ? 'selected' : ''; ?>>Partial</option>
                            <option value="pending" <?php echo ($search_status == 'pending') ? 'selected' : ''; ?>>Pending</option>
                        </select>
                    </div>
                    <div class="col-md-3 d-flex align-items-end">
                        <button type="submit" class="btn btn-primary me-2">
                            <i class="fas fa-search me-2"></i>Search
                        </button>
                        <a href="fees_vouchers_list.php" class="btn btn-outline-secondary">
                            <i class="fas fa-redo me-2"></i>Reset
                        </a>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Vouchers Data Table Card -->
    <div class="card data-table-card">
        <div class="card-header py-3 d-flex justify-content-between align-items-center">
            <h6 class="m-0 font-weight-bold text-primary">
                <i class="fas fa-file-invoice me-2"></i>
                Generated Fee Vouchers
                <span class="voucher-count-badge"><?php echo count($vouchers); ?> Vouchers</span>
            </h6>
            <div>
                <?php if (!empty($search_class) || !empty($search_section) || !empty($search_month) || !empty($search_status)): ?>
                    <span class="filter-badge me-2">
                        <i class="fas fa-filter me-1"></i>Filters Applied
                    </span>
                <?php endif; ?>
            </div>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th width="80">Voucher No</th>
                            <th>Student Name</th>
                            <th>Father Name</th>
                            <th width="80">Roll No</th>
                            <th width="120">Class</th>
                            <th width="100">Section</th>
                            <th width="100">Month</th>
                            <th width="100">Due Date</th>
                            <th width="100">Total Amount</th>
                            <th width="100">Paid Amount</th>
                            <th width="100">Due Amount</th>
                            <th width="100">Status</th>
                            <th width="150" class="text-center">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (!empty($vouchers)): ?>
                            <?php foreach ($vouchers as $voucher): 
                                $due_amount = $voucher['net_payable'] - $voucher['amount_paid'];
                                $month_name = date('F Y', strtotime($voucher['month_year'] . '-01'));
                            ?>
                            <tr>
                                <td class="fw-semibold text-gray-600">
                                    <small><?php echo htmlspecialchars($voucher['voucher_no']); ?></small>
                                </td>
                                <td>
                                    <a href="student_profile.php?id=<?php echo $voucher['student_id']; ?>" class="student-name-link">
                                        <?php echo htmlspecialchars($voucher['student_name']); ?>
                                    </a>
                                </td>
                                <td class="text-gray-600"><?php echo htmlspecialchars($voucher['father_name']); ?></td>
                                <td>
                                    <span class="badge bg-light text-dark border"><?php echo htmlspecialchars($voucher['roll_no'] ?? '-'); ?></span>
                                </td>
                                <td class="text-gray-600"><?php echo htmlspecialchars($voucher['class_name']); ?></td>
                                <td>
                                    <span class="badge bg-light text-dark border"><?php echo htmlspecialchars($voucher['section_name'] ?? '-'); ?></span>
                                </td>
                                <td class="text-gray-600">
                                    <small><?php echo htmlspecialchars($month_name); ?></small>
                                </td>
                                <td class="text-gray-600">
                                    <small><?php echo date('d-M-Y', strtotime($voucher['due_date'])); ?></small>
                                </td>
                                <td class="fw-semibold text-gray-800">
                                    Rs. <?php echo number_format($voucher['total_amount'], 2); ?>
                                </td>
                                <td class="amount-paid">
                                    Rs. <?php echo number_format($voucher['amount_paid'], 2); ?>
                                </td>
                                <td class="amount-due">
                                    Rs. <?php echo number_format($due_amount, 2); ?>
                                </td>
                                <td>
                                    <?php
                                    $status_class = '';
                                    switch ($voucher['status']) {
                                        case 'paid': $status_class = 'status-paid'; break;
                                        case 'partial': $status_class = 'status-partial'; break;
                                        case 'pending': $status_class = 'status-pending'; break;
                                        default: $status_class = 'status-unpaid'; break;
                                    }
                                    ?>
                                    <span class="badge <?php echo $status_class; ?>">
                                        <?php echo ucfirst($voucher['status']); ?>
                                    </span>
                                </td>
                                <td class="text-center">
                                    <div class="btn-group" role="group">
                                        <!-- Print Voucher -->
                                        <a href="fee_voucher_print.php?invoice_id=<?php echo $voucher['id']; ?>" 
                                           class="btn btn-sm btn-primary btn-action" 
                                           target="_blank"
                                           title="Print Voucher">
                                            <i class="fas fa-print"></i>
                                        </a>
                                        
                                        <!-- Record Payment -->
                                        <button type="button" 
                                                class="btn btn-sm btn-success btn-action" 
                                                title="Record Payment"
                                                onclick="openPaymentModal(<?php echo $voucher['id']; ?>, '<?php echo $voucher['voucher_no']; ?>', <?php echo $due_amount; ?>)">
                                            <i class="fas fa-money-bill-wave"></i>
                                        </button>
                                        
                                        <!-- View Details -->
                                        <a href="voucher_details.php?id=<?php echo $voucher['id']; ?>" 
                                           class="btn btn-sm btn-info btn-action" 
                                           title="View Details">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        
                                        <!-- Delete Voucher -->
                                        <a href="fees_process.php?action=delete_voucher&id=<?php echo $voucher['id']; ?>" 
                                           class="btn btn-sm btn-danger btn-action" 
                                           onclick="return confirm('Kya aap yaqeeni hain ke aap yeh voucher delete karna chahte hain? Yeh action wapas nahi ho sakta.')" 
                                           title="Delete Voucher">
                                            <i class="fas fa-trash"></i>
                                        </a>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="13">
                                    <div class="empty-state">
                                        <i class="fas fa-file-invoice-dollar"></i>
                                        <h5 class="text-gray-500">No Vouchers Found</h5>
                                        <p class="text-muted">No fee vouchers match your search criteria.</p>
                                        <a href="fees_generate.php" class="btn btn-primary mt-2">
                                            <i class="fas fa-plus me-2"></i>Generate New Vouchers
                                        </a>
                                    </div>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Payment Modal -->
<div class="modal fade" id="paymentModal" tabindex="-1" aria-labelledby="paymentModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="paymentModalLabel">
                    <i class="fas fa-money-bill-wave me-2"></i>Record Fee Payment
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="paymentForm" action="fees_process.php" method="POST">
                <input type="hidden" name="action" value="record_payment">
                <input type="hidden" name="invoice_id" id="payment_invoice_id">
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Voucher No</label>
                        <p class="form-control-plaintext fw-bold" id="payment_voucher_no"></p>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Due Amount</label>
                        <p class="form-control-plaintext text-danger fw-bold" id="payment_due_amount"></p>
                    </div>
                    <div class="mb-3">
                        <label for="amount_received" class="form-label">Amount Received (Rs.)</label>
                        <input type="number" class="form-control" id="amount_received" name="amount_received" step="0.01" min="0" required>
                    </div>
                    <div class="mb-3">
                        <label for="payment_date" class="form-label">Payment Date</label>
                        <input type="date" class="form-control" id="payment_date" name="payment_date" value="<?php echo date('Y-m-d'); ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="payment_method" class="form-label">Payment Method</label>
                        <select class="form-select" id="payment_method" name="payment_method" required>
                            <option value="Cash">Cash</option>
                            <option value="Bank Transfer">Bank Transfer</option>
                            <option value="Cheque">Cheque</option>
                            <option value="Online">Online</option>
                            <option value="Other">Other</option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save me-2"></i>Record Payment
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
// Function to open payment modal
function openPaymentModal(invoiceId, voucherNo, dueAmount) {
    document.getElementById('payment_invoice_id').value = invoiceId;
    document.getElementById('payment_voucher_no').textContent = voucherNo;
    document.getElementById('payment_due_amount').textContent = 'Rs. ' + dueAmount.toLocaleString('en-PK');
    document.getElementById('amount_received').max = dueAmount;
    document.getElementById('amount_received').value = '';
    
    var modal = new bootstrap.Modal(document.getElementById('paymentModal'));
    modal.show();
}

// Form validation for payment
document.getElementById('paymentForm').addEventListener('submit', function(e) {
    var amountReceived = parseFloat(document.getElementById('amount_received').value);
    var dueAmount = parseFloat(document.getElementById('payment_due_amount').textContent.replace('Rs. ', '').replace(/,/g, ''));
    
    if (amountReceived > dueAmount) {
        e.preventDefault();
        alert('Amount received cannot be greater than due amount!');
        return false;
    }
    
    if (amountReceived <= 0) {
        e.preventDefault();
        alert('Please enter a valid amount!');
        return false;
    }
});
</script>

<?php
include_once('includes/footer.php'); 
?>