<?php
// admin/includes/sidebar.php - Menu structure file

// 1. Current page ka filename nikaalte hain (.php extension hata kar)
$current_page = basename($_SERVER['PHP_SELF'], '.php'); 

// 2. Active Parent Menu Tracking
$active_parent = '';
switch ($current_page) {
    case 'students':
    case 'student_leaving': 
    case 'generate_slc':
    case 'user_management':
        $active_parent = 'usersSubmenu';
        break;
    
    case 'teachers':
        $active_parent = 'teachersSubmenu';
        break;
    
    case 'sections':
    case 'subjects':
    case 'academic_sessions':
    case 'migrate_students':
    case 'edit_class':     
    case 'edit_section':   
        $active_parent = 'academicSubmenu';
        break;

    case 'add_exam':
    case 'manage_exams':
    case 'exam_structure':
    case 'marks_entry':
    case 'award_list':
    case 'print_result_card':
    case 'class_result_sheet':
    case 'print_session_result':
        $active_parent = 'examSubmenu';
        break;

    case 'attendance':
    case 'print_monthly_attendance':
        $active_parent = 'recordsSubmenu';
        break;

    case 'fees_config':
    case 'fees_generate':
    case 'fees_vouchers':
    case 'fee_report_monthly':
    case 'salary_generate':
    case 'financial_summary_report':
    case 'unpaid_fee_report':
    case 'fees_vouchers_list':
        $active_parent = 'financeSubmenu';
        break;
    
    case 'class_planner':
    case 'class_datesheet':
    case 'notice_board':
        $active_parent = 'composingSubmenu';
        break;
}
?>

<style>
/* Professional Light Sidebar Styling */
.sms-sidebar-wrapper {
    min-height: 100vh;
    background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
    box-shadow: 3px 0 25px rgba(0, 0, 0, 0.08);
    position: relative;
    z-index: 1000;
    border-right: 1px solid #dee2e6;
}

.sms-sidebar-menu {
    padding: 20px 0;
    margin: 0;
    list-style: none;
}

.sms-menu-item {
    margin-bottom: 3px;
    position: relative;
}

.sms-menu-item > a {
    display: flex;
    align-items: center;
    padding: 14px 25px;
    color: #495057;
    text-decoration: none;
    font-weight: 500;
    font-size: 15px;
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    border-left: 4px solid transparent;
    position: relative;
    overflow: hidden;
    border-radius: 0 8px 8px 0;
    margin: 2px 10px;
}

.sms-menu-item > a::before {
    content: '';
    position: absolute;
    left: 0;
    top: 0;
    height: 100%;
    width: 0;
    background: linear-gradient(90deg, rgba(13, 110, 253, 0.1) 0%, transparent 100%);
    transition: width 0.3s ease;
}

.sms-menu-item > a:hover {
    background: rgba(13, 110, 253, 0.08);
    color: #0d6efd;
    border-left-color: #0d6efd;
    padding-left: 28px;
    transform: translateX(5px);
}

.sms-menu-item > a:hover::before {
    width: 100%;
}

.sms-menu-item.active > a {
    background: linear-gradient(90deg, rgba(13, 110, 253, 0.12) 0%, transparent 100%);
    color: #0d6efd;
    border-left-color: #0d6efd;
    box-shadow: 0 2px 8px rgba(13, 110, 253, 0.15);
    font-weight: 600;
}

.sms-menu-item > a i {
    margin-right: 15px;
    font-size: 18px;
    width: 24px;
    text-align: center;
    transition: all 0.3s ease;
}

.sms-menu-item > a:hover i {
    transform: scale(1.1);
    color: #0d6efd;
}

/* Dropdown Toggle Styling */
.sms-menu-item > a[data-toggle="collapse"] {
    position: relative;
    padding-right: 50px;
}

.sms-menu-item > a[data-toggle="collapse"]::after {
    content: '\f107';
    font-family: 'Font Awesome 5 Free';
    font-weight: 900;
    border: none;
    position: absolute;
    right: 25px;
    top: 50%;
    transform: translateY(-50%);
    transition: all 0.3s ease;
    color: #6c757d;
    font-size: 14px;
}

.sms-menu-item > a[data-toggle="collapse"][aria-expanded="true"] {
    background: rgba(13, 110, 253, 0.1);
    color: #0d6efd;
}

.sms-menu-item > a[data-toggle="collapse"][aria-expanded="true"]::after {
    transform: translateY(-50%) rotate(-180deg);
    color: #0d6efd;
}

/* Submenu Styling */
.sms-submenu {
    background: rgba(255, 255, 255, 0.6);
    border-left: 3px solid #0d6efd;
    margin-left: 25px;
    border-radius: 0 0 0 12px;
    overflow: hidden;
    backdrop-filter: blur(10px);
}

.sms-submenu .sms-menu-item {
    margin-bottom: 0;
}

.sms-submenu .sms-menu-item a {
    padding: 12px 25px 12px 55px;
    font-size: 14px;
    font-weight: 400;
    color: #6c757d;
    border-left: none;
    background: transparent !important;
    position: relative;
    margin: 1px 5px;
    border-radius: 0 6px 6px 0;
}

.sms-submenu .sms-menu-item a::before {
    content: '';
    position: absolute;
    left: 35px;
    top: 50%;
    transform: translateY(-50%);
    width: 6px;
    height: 6px;
    background: #0d6efd;
    border-radius: 50%;
    opacity: 0;
    transition: all 0.3s ease;
}

.sms-submenu .sms-menu-item a:hover {
    background: rgba(13, 110, 253, 0.08) !important;
    color: #0d6efd;
    padding-left: 58px;
    transform: translateX(3px);
}

.sms-submenu .sms-menu-item a:hover::before {
    opacity: 1;
    transform: translateY(-50%) scale(1.2);
}

.sms-submenu .sms-menu-item.active a {
    background: rgba(13, 110, 253, 0.12) !important;
    color: #0d6efd;
    font-weight: 500;
}

.sms-submenu .sms-menu-item.active a::before {
    opacity: 1;
    transform: translateY(-50%) scale(1.2);
}

/* Color Coding for Main Menu Items */
.sms-menu-item:nth-child(2) > a { border-left-color: #0d6efd; } /* Users - Blue */
.sms-menu-item:nth-child(3) > a { border-left-color: #198754; } /* Teachers - Green */
.sms-menu-item:nth-child(4) > a { border-left-color: #6f42c1; } /* Academics - Purple */
.sms-menu-item:nth-child(5) > a { border-left-color: #fd7e14; } /* Exams - Orange */
.sms-menu-item:nth-child(6) > a { border-left-color: #dc3545; } /* Attendance - Red */
.sms-menu-item:nth-child(7) > a { border-left-color: #0dcaf0; } /* Finance - Teal */
.sms-menu-item:nth-child(8) > a { border-left-color: #20c997; } /* Composing - Success */

/* Logout Button Special Styling */
.sms-menu-item:last-child {
    margin-top: 25px;
    position: relative;
}

.sms-menu-item:last-child::before {
    content: '';
    position: absolute;
    top: -12px;
    left: 25px;
    right: 25px;
    height: 1px;
    background: linear-gradient(90deg, transparent 0%, #dee2e6 50%, transparent 100%);
}

.sms-menu-item:last-child a {
    background: rgba(220, 53, 69, 0.08);
    color: #dc3545;
    border-left-color: #dc3545;
    margin: 0 15px;
    border-radius: 8px;
    font-weight: 500;
}

.sms-menu-item:last-child a:hover {
    background: rgba(220, 53, 69, 0.15);
    color: #dc3545;
    border-left-color: #dc3545;
    transform: translateX(5px);
}

/* Settings Button Styling */
.sms-menu-item:nth-last-child(2) a {
    border-left-color: #ffc107;
}

.sms-menu-item:nth-last-child(2) a:hover {
    border-left-color: #ffc107;
}

/* Animation for dropdown */
.collapse {
    transition: all 0.3s ease !important;
}

.collapse.show {
    animation: slideDown 0.3s ease;
}

@keyframes slideDown {
    from {
        opacity: 0;
        transform: translateY(-10px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

/* Responsive Design */
@media (max-width: 768px) {
    .sms-sidebar-wrapper {
        min-height: auto;
    }
    
    .sms-menu-item > a {
        padding: 12px 20px;
        font-size: 14px;
        margin: 1px 5px;
    }
    
    .sms-submenu .sms-menu-item a {
        padding: 10px 20px 10px 45px;
    }
    
    .sms-menu-item > a:hover {
        padding-left: 23px;
    }
    
    .sms-submenu .sms-menu-item a:hover {
        padding-left: 48px;
    }
}

/* Scrollbar Styling */
.sms-sidebar-wrapper::-webkit-scrollbar {
    width: 6px;
}

.sms-sidebar-wrapper::-webkit-scrollbar-track {
    background: rgba(0, 0, 0, 0.05);
}

.sms-sidebar-wrapper::-webkit-scrollbar-thumb {
    background: rgba(0, 0, 0, 0.2);
    border-radius: 3px;
}

.sms-sidebar-wrapper::-webkit-scrollbar-thumb:hover {
    background: rgba(0, 0, 0, 0.3);
}

/* Ensure proper dropdown functionality */
.sms-submenu {
    transition: all 0.3s ease !important;
}
</style>

<div class="sms-sidebar-wrapper">
    <ul class="sms-sidebar-menu">
        
        <li class="sms-menu-item <?php echo ($current_page == 'dashboard') ? 'active' : ''; ?>">
            <a href="dashboard.php">
                <i class="fas fa-tachometer-alt"></i> Dashboard
            </a>
        </li>

        <?php if (isset($user_role_id) && $user_role_id == 1): ?>
        
        <!-- Users & Personnel -->
        <li class="sms-menu-item <?php echo ($active_parent == 'usersSubmenu') ? 'active' : ''; ?>">
            <a href="#usersSubmenu" data-toggle="collapse" aria-expanded="<?php echo ($active_parent == 'usersSubmenu') ? 'true' : 'false'; ?>">
                <i class="fas fa-users"></i> Student Management
            </a>
            <ul class="collapse sms-submenu <?php echo ($active_parent == 'usersSubmenu') ? 'show' : ''; ?>" id="usersSubmenu">
                <li class="sms-menu-item <?php echo ($current_page == 'students') ? 'active' : ''; ?>">
                    <a href="students.php">Students Management</a>
                </li>
				<li class="sms-menu-item <?php echo ($current_page == 'manual_admission_form') ? 'active' : ''; ?>">
                    <a href="manual_admission_form.php">Print Admission Form</a>
                </li>
                <li class="sms-menu-item <?php echo ($current_page == 'student_leaving') ? 'active' : ''; ?>">
                    <a href="student_leaving.php">Student Leaving</a>
                </li>
                <li class="sms-menu-item <?php echo ($current_page == 'generate_slc') ? 'active' : ''; ?>">
                    <a href="generate_slc.php">Print Leaving Certificate</a>
                </li>
                <li class="sms-menu-item <?php echo ($current_page == 'user_management') ? 'active' : ''; ?>">
                    <a href="user_management.php">User Roles</a>
                </li>
            </ul>
        </li>

        <!-- Teachers Management -->
        <li class="sms-menu-item <?php echo ($active_parent == 'teachersSubmenu') ? 'active' : ''; ?>">
            <a href="#teachersSubmenu" data-toggle="collapse" aria-expanded="<?php echo ($active_parent == 'teachersSubmenu') ? 'true' : 'false'; ?>">
                <i class="fas fa-chalkboard-teacher"></i> Teachers Management
            </a>
            <ul class="collapse sms-submenu <?php echo ($active_parent == 'teachersSubmenu') ? 'show' : ''; ?>" id="teachersSubmenu">
                <li class="sms-menu-item <?php echo ($current_page == 'teachers') ? 'active' : ''; ?>">
                    <a href="teachers.php">Teachers Management</a>
                </li>
				<li class="sms-menu-item <?php echo ($current_page == 'salary_generate') ? 'active' : ''; ?>">
                    <a href="salary_generate.php">Generate Staff Salary</a>
                </li>
            </ul>
        </li>

        <!-- Academics Setup -->
        <li class="sms-menu-item <?php echo ($active_parent == 'academicSubmenu') ? 'active' : ''; ?>">
            <a href="#academicSubmenu" data-toggle="collapse" aria-expanded="<?php echo ($active_parent == 'academicSubmenu') ? 'true' : 'false'; ?>">
                <i class="fas fa-graduation-cap"></i> Academics Setup
            </a>
            <ul class="collapse sms-submenu <?php echo ($active_parent == 'academicSubmenu') ? 'show' : ''; ?>" id="academicSubmenu">
                <li class="sms-menu-item <?php echo ($current_page == 'sections' || $current_page == 'edit_class' || $current_page == 'edit_section') ? 'active' : ''; ?>">
                    <a href="sections.php">Classes & Sections</a>
                </li> 
                <li class="sms-menu-item <?php echo ($current_page == 'subjects') ? 'active' : ''; ?>">
                    <a href="subjects.php">Subjects</a>
                </li>
                <li class="sms-menu-item <?php echo ($current_page == 'academic_sessions') ? 'active' : ''; ?>">
                    <a href="academic_sessions.php">Academic Sessions</a>
                </li>
            </ul>
        </li>

        <!-- Exam Management -->
        <li class="sms-menu-item <?php echo ($active_parent == 'examSubmenu') ? 'active' : ''; ?>">
            <a href="#examSubmenu" data-toggle="collapse" aria-expanded="<?php echo ($active_parent == 'examSubmenu') ? 'true' : 'false'; ?>">
                <i class="fas fa-file-alt"></i> Exam Management
            </a>
            <ul class="collapse sms-submenu <?php echo ($active_parent == 'examSubmenu') ? 'show' : ''; ?>" id="examSubmenu">
                <li class="sms-menu-item <?php echo ($current_page == 'add_exam') ? 'active' : ''; ?>">
                    <a href="add_exam.php">Add New Exam</a>
                </li>
                <li class="sms-menu-item <?php echo ($current_page == 'manage_exams') ? 'active' : ''; ?>">
                    <a href="manage_exams.php">Manage Exams (List)</a>
                </li>
                <li class="sms-menu-item <?php echo ($current_page == 'exam_structure') ? 'active' : ''; ?>">
                    <a href="exam_structure.php">Manage Marks Assign</a>
                </li>
                <li class="sms-menu-item <?php echo ($current_page == 'marks_entry') ? 'active' : ''; ?>">
                    <a href="marks_entry.php">Exam Marks Entry</a>
                </li>
                <li class="sms-menu-item <?php echo ($current_page == 'award_list') ? 'active' : ''; ?>">
                    <a href="award_list.php">Print Award List</a>
                </li>
                <li class="sms-menu-item <?php echo ($current_page == 'print_result_card') ? 'active' : ''; ?>">
                    <a href="print_result_card.php">Print Result Cards</a>
                </li>
                <li class="sms-menu-item <?php echo ($current_page == 'class_result_sheet') ? 'active' : ''; ?>">
                    <a href="class_result_sheet.php">Print Class Wise Result</a>
                </li>
                <li class="sms-menu-item <?php echo ($current_page == 'print_session_result') ? 'active' : ''; ?>">
                    <a href="print_session_result.php">Print Session Result</a>
                </li>
            </ul>
        </li>
        
        <!-- Attendance Records -->
        <li class="sms-menu-item <?php echo ($active_parent == 'recordsSubmenu') ? 'active' : ''; ?>">
            <a href="#recordsSubmenu" data-toggle="collapse" aria-expanded="<?php echo ($active_parent == 'recordsSubmenu') ? 'true' : 'false'; ?>">
                <i class="fas fa-clipboard-list"></i> Attendance Records
            </a>
            <ul class="collapse sms-submenu <?php echo ($active_parent == 'recordsSubmenu') ? 'show' : ''; ?>" id="recordsSubmenu">
                <li class="sms-menu-item <?php echo ($current_page == 'attendance') ? 'active' : ''; ?>">
                    <a href="attendance.php">Daily Attendance</a>
                </li>
                <li class="sms-menu-item <?php echo ($current_page == 'print_monthly_attendance') ? 'active' : ''; ?>">
                    <a href="print_monthly_attendance.php">Monthly Attendance Print</a>
                </li>
            </ul>
        </li>
        
        <!-- Fees & Payments -->
        <li class="sms-menu-item <?php echo ($active_parent == 'financeSubmenu') ? 'active' : ''; ?>">
            <a href="#financeSubmenu" data-toggle="collapse" aria-expanded="<?php echo ($active_parent == 'financeSubmenu') ? 'true' : 'false'; ?>">
                <i class="fas fa-money-bill-wave"></i> Fees & Payments
            </a>
            <ul class="collapse sms-submenu <?php echo ($active_parent == 'financeSubmenu') ? 'show' : ''; ?>" id="financeSubmenu">
                <li class="sms-menu-item <?php echo ($current_page == 'fees_generate') ? 'active' : ''; ?>">
                    <a href="fees_generate.php">Generate Fee Vouchers</a>
                </li>
                <li class="sms-menu-item <?php echo ($current_page == 'fees_vouchers_list') ? 'active' : ''; ?>">
                    <a href="fees_vouchers_list.php">Fee Vouchers List</a>
                </li>
                <li class="sms-menu-item <?php echo ($current_page == 'fees_vouchers') ? 'active' : ''; ?>">
                    <a href="fees_vouchers.php">Collect Fee Payment</a>
                </li>
                <li class="sms-menu-item <?php echo ($current_page == 'fee_report_monthly') ? 'active' : ''; ?>">
                    <a href="fee_report_monthly.php">Monthly Fee Report</a>
                </li>
                <li class="sms-menu-item <?php echo ($current_page == 'unpaid_fee_report') ? 'active' : ''; ?>">
                    <a href="unpaid_fee_report.php">Fee Defaulters</a>
                </li>
                
                <li class="sms-menu-item <?php echo ($current_page == 'financial_summary_report') ? 'active' : ''; ?>">
                    <a href="financial_summary_report.php">Financial Summary Report</a>
                </li>
            </ul>
        </li>
        
        <!-- Composing -->
        <li class="sms-menu-item <?php echo ($active_parent == 'composingSubmenu') ? 'active' : ''; ?>">
            <a href="#composingSubmenu" data-toggle="collapse" aria-expanded="<?php echo ($active_parent == 'composingSubmenu') ? 'true' : 'false'; ?>">
                <i class="fas fa-edit"></i> Composing
            </a>
            <ul class="collapse sms-submenu <?php echo ($active_parent == 'composingSubmenu') ? 'show' : ''; ?>" id="composingSubmenu">
                <li class="sms-menu-item <?php echo ($current_page == 'class_planner') ? 'active' : ''; ?>">
                    <a href="class_planner.php">Class Weekly Planner</a>
                </li>
                <li class="sms-menu-item <?php echo ($current_page == 'class_datesheet') ? 'active' : ''; ?>">
                    <a href="class_datesheet.php">Class Datesheet</a>
                </li>
                <li class="sms-menu-item <?php echo ($current_page == 'notice_board') ? 'active' : ''; ?>">
                    <a href="notice_board.php">Notice Board</a>
                </li>
				<li class="sms-menu-item <?php echo ($current_page == 'notice_board') ? 'active' : ''; ?>">
                    <a href="syllabus.php">Syllabus</a>
                </li>
            </ul>
        </li>
        
        <!-- System Settings -->
        <li class="sms-menu-item <?php echo ($current_page == 'settings') ? 'active' : ''; ?>">
            <a href="settings.php">
                <i class="fas fa-cogs"></i> System Settings
            </a>
        </li>

        <?php endif; ?>

        <!-- Logout -->
        <li class="sms-menu-item">
            <a href="logout.php">
                <i class="fas fa-sign-out-alt"></i> Logout
            </a>
        </li>

    </ul>
</div>

<!-- Bootstrap & jQuery for dropdown functionality -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.0/dist/js/bootstrap.bundle.min.js"></script>

<script>
// Additional JavaScript to ensure smooth dropdown functionality
$(document).ready(function() {
    // Close other dropdowns when one is opened
    $('.sms-menu-item > a[data-toggle="collapse"]').on('click', function() {
        var target = $(this).attr('href');
        $('.sms-submenu').not(target).collapse('hide');
    });
    
    // Add smooth transition to dropdowns
    $('.sms-submenu').on('show.bs.collapse', function() {
        $(this).parent().find('> a').addClass('dropdown-open');
    });
    
    $('.sms-submenu').on('hide.bs.collapse', function() {
        $(this).parent().find('> a').removeClass('dropdown-open');
    });
});
</script>