<?php
// admin/marks_entry.php - Exam Marks Entry (Restored Student-wise Search Page)

session_start();
ob_start(); 
include_once('../config/db.php');
include_once('includes/header.php'); 
include_once('includes/sidebar.php'); 

$conn = getDBConnection();

$message = $_GET['msg'] ?? '';
$error = $_GET['err'] ?? '';

// NOTE: Assuming $settings is loaded.
$current_session_id = $settings['academic.active_session_id'] ?? 1;

// Fetch current session name
$session_query = "SELECT id, name FROM academic_sessions WHERE id = ?";
$session_stmt = $conn->prepare($session_query);
$session_stmt->bind_param("i", $current_session_id);
$session_stmt->execute();
$current_session = $session_stmt->get_result()->fetch_assoc();
$session_stmt->close();

// 1. Fetch Active Exam and other data
$active_exam_query = "SELECT id, name, status FROM exams WHERE session_id = {$current_session_id} AND status = 'active' LIMIT 1";
$active_exam_result = $conn->query($active_exam_query);
$active_exam = $active_exam_result->fetch_assoc();

// Get selected exam ID - use active exam if available
$selected_exam_id = $_GET['exam_id'] ?? ($active_exam['id'] ?? null);
$selected_class_id = $_GET['class_id'] ?? null;
$selected_section_id = $_GET['section_id'] ?? null; 

// Fetch other exams for fallback (if no active exam)
$exams_result = $conn->query("SELECT id, name, status FROM exams WHERE session_id = {$current_session_id} AND status IN ('upcoming', 'active', 'finished') ORDER BY id DESC");
$exams = $exams_result->fetch_all(MYSQLI_ASSOC);
$classes_result = $conn->query("SELECT id, name FROM academic_classes ORDER BY order_no ASC");
$classes = $classes_result->fetch_all(MYSQLI_ASSOC);
$sections_result = $conn->query("SELECT id, name FROM academic_sections WHERE status='active' ORDER BY name ASC");
$sections = $sections_result->fetch_all(MYSQLI_ASSOC);

// Initialization and Data Loading Logic
$students_data = [];
$exam_name = '';
$class_name = '';
$section_name = 'ALL';

// This check is the main entry point logic
if ($selected_exam_id && $selected_class_id) {
    $exam_id = (int)$selected_exam_id;
    $class_id = (int)$selected_class_id;
    $section_id = $selected_section_id ? (int)$selected_section_id : NULL;

    // --- START: Name Fetch Logic ---
    $exam_stmt = $conn->prepare("SELECT name FROM exams WHERE id = ?");
    $exam_stmt->bind_param("i", $exam_id);
    $exam_stmt->execute();
    if ($exam_data = $exam_stmt->get_result()->fetch_assoc()) {
        $exam_name = $exam_data['name'];
    }
    $exam_stmt->close();

    $class_stmt = $conn->prepare("SELECT name FROM academic_classes WHERE id = ?");
    $class_stmt->bind_param("i", $class_id);
    $class_stmt->execute();
    if ($class_data = $class_stmt->get_result()->fetch_assoc()) {
        $class_name = $class_data['name'];
    }
    $class_stmt->close();

    if ($section_id) {
        $section_stmt = $conn->prepare("SELECT name FROM academic_sections WHERE id = ?");
        $section_stmt->bind_param("i", $section_id);
        $section_stmt->execute();
        if ($section_data = $section_stmt->get_result()->fetch_assoc()) {
            $section_name = $section_data['name'];
        }
        $section_stmt->close();
    }
    // --- END: Name Fetch Logic ---


    // Fetch Enrolled Students and check if they have marks
    $students_query = "
        SELECT 
            s.id, s.first_name, s.last_name, en.roll_no,
            (SELECT COUNT(em.id) FROM exam_marks em WHERE em.student_id = s.id AND em.exam_id = ? AND em.class_id = ?) AS has_marks
        FROM students s
        JOIN student_enrollments en ON s.id = en.student_id
        WHERE en.session_id = ? AND en.class_id = ? AND s.status = 'active'
    ";
    
    // Section filter
    if ($section_id !== NULL) {
         $students_query .= " AND en.section_id = ?";
         $students_query .= " ORDER BY en.roll_no ASC";
         $students_stmt = $conn->prepare($students_query);
         $students_stmt->bind_param("iiiii", $exam_id, $class_id, $current_session_id, $class_id, $section_id);
    } else {
         $students_query .= " ORDER BY en.roll_no ASC";
         $students_stmt = $conn->prepare($students_query);
         $students_stmt->bind_param("iiii", $exam_id, $class_id, $current_session_id, $class_id);
    }

    $students_stmt->execute();
    $students_result = $students_stmt->get_result();
    $students_data = $students_result->fetch_all(MYSQLI_ASSOC);
    $students_stmt->close();
}

if (isset($conn) && is_object($conn)) {
    $conn->close();
}
?>

<h1 class="mb-4">Exam Marks Entry <i class="fas fa-edit"></i></h1>

<?php if ($message): ?>
    <div class="alert alert-success"><?php echo htmlspecialchars($message); ?></div>
<?php endif; ?>
<?php if ($error): ?>
    <div class="alert alert-danger"><?php echo htmlspecialchars($error); ?></div>
<?php endif; ?>

<div class="card p-3 mb-4 shadow-sm">
    <h5 class="card-title">Select Exam, Class & Section</h5>
    <form method="GET" action="marks_entry.php" class="form-inline">
        <div class="form-group mr-3 mb-2">
            <label class="mr-2">Session:</label>
            <?php if ($current_session): ?>
                <input type="hidden" name="session_id" value="<?php echo $current_session['id']; ?>">
                <select class="form-control" disabled>
                    <option value="<?php echo $current_session['id']; ?>" selected>
                        <?php echo htmlspecialchars($current_session['name']); ?> (Current Session)
                    </option>
                </select>
            <?php else: ?>
                <select name="session_id" class="form-control" required>
                    <option value="">-- Select Session --</option>
                    <?php foreach ($sessions as $session): ?>
                        <option value="<?php echo $session['id']; ?>" <?php echo $current_session_id == $session['id'] ? 'selected' : ''; ?>>
                            <?php echo htmlspecialchars($session['name']); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
                <div class="alert alert-warning mt-2">No active session found. Please select a session manually.</div>
            <?php endif; ?>
        </div>
        <div class="form-group mr-3 mb-2">
            <label class="mr-2">Exam:</label>
            <?php if ($active_exam): ?>
                <input type="hidden" name="exam_id" value="<?php echo $active_exam['id']; ?>">
                <select class="form-control" disabled>
                    <option value="<?php echo $active_exam['id']; ?>" selected>
                        <?php echo htmlspecialchars($active_exam['name']); ?> (Active)
                    </option>
                </select>
            <?php else: ?>
                <select name="exam_id" class="form-control" required>
                    <option value="">-- Select Exam --</option>
                    <?php foreach ($exams as $exam): ?>
                        <option value="<?php echo $exam['id']; ?>" <?php echo $selected_exam_id == $exam['id'] ? 'selected' : ''; ?>>
                            <?php echo htmlspecialchars($exam['name']); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
                <div class="alert alert-warning mt-2">No active exam found. Please select an exam manually.</div>
            <?php endif; ?>
        </div>
        <div class="form-group mr-3 mb-2">
            <label class="mr-2">Class:</label>
            <select name="class_id" id="class_id" class="form-control" required>
                <option value="">-- Select Class --</option>
                <?php foreach ($classes as $class): ?>
                    <option value="<?php echo $class['id']; ?>" <?php echo $selected_class_id == $class['id'] ? 'selected' : ''; ?>>
                        <?php echo htmlspecialchars($class['name']); ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="form-group mr-3 mb-2">
            <label class="mr-2">Section:</label>
            <select name="section_id" id="section_id" class="form-control">
                <option value="">-- All Sections --</option>
                <?php foreach ($sections as $section): ?>
                    <option value="<?php echo $section['id']; ?>" <?php echo $selected_section_id == $section['id'] ? 'selected' : ''; ?>>
                        <?php echo htmlspecialchars($section['name']); ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
        
        <button type="submit" class="btn btn-info mb-2"><i class="fas fa-search"></i> Load Students</button>
    </form>
</div>

<?php if ($selected_exam_id && $selected_class_id && $exam_name && $class_name): ?>

    <h4 class="mb-3">Students for: **<?php echo htmlspecialchars($exam_name); ?>** - **<?php echo htmlspecialchars($class_name); ?> / <?php echo htmlspecialchars($section_name); ?>**</h4>
    
    <?php if (count($students_data) > 0): ?>
        
        <div class="table-responsive">
        <table class="table table-bordered table-striped table-hover table-sm">
            <thead class="thead-dark">
                <tr>
                    <th style="width: 50px;">Roll No</th>
                    <th>Student Name</th>
                    <th style="width: 280px;">Action</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($students_data as $student): 
                    // Direct Delete URL (Final Fix)
                    $delete_url = "delete_marks_process.php?student_id={$student['id']}&exam_id={$selected_exam_id}&class_id={$selected_class_id}";
                ?>
                <tr>
                    <td><?php echo htmlspecialchars($student['roll_no'] ?? '-'); ?></td>
                    <td><?php echo htmlspecialchars($student['first_name'] . ' ' . $student['last_name']); ?></td>
                    <td>
                        <a href="student_marks_entry.php?exam_id=<?php echo $selected_exam_id; ?>&class_id=<?php echo $selected_class_id; ?>&student_id=<?php echo $student['id']; ?>" 
                            class="btn btn-sm btn-primary mr-2">
                            <i class="fas fa-pencil-alt"></i> Add/Edit Marks
                        </a>
                        
                        <?php if ($student['has_marks'] > 0): ?>
                        <a href="<?php echo $delete_url; ?>" 
                            class="btn btn-sm btn-danger delete-marks-btn"
                            data-student-name="<?php echo htmlspecialchars($student['first_name'] . ' ' . $student['last_name']); ?>">
                            <i class="fas fa-trash"></i> Delete Result
                        </a>
                        <?php else: ?>
                            <span class="badge badge-secondary">No Marks Yet</span>
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
        </div>
        
    <?php else: ?>
        <div class="alert alert-warning">Is Class/Section mein koi active student enroll nahi mila.</div>
    <?php endif; ?>
    
<?php else: ?>
    <div class="alert alert-info">Barah-e-meherbani Exam, Class, aur Section select karke **Load Students** button dabayein.</div>
<?php endif; ?>

<script>
$(document).ready(function() {
    $('.delete-marks-btn').on('click', function(e) {
        
        let studentName = $(this).data('student-name');
        
        let confirmation = confirm("WARNING: Are you sure you want to PERMANENTLY DELETE ALL MARKS for student: " + studentName + "?\nThis action cannot be undone.");
        
        if (confirmation) {
            return true; 
        } else {
            e.preventDefault(); 
        }
        
    });
});
</script>


<?php
include_once('includes/footer.php'); 
ob_end_flush();
?>