<?php
// admin/migrate_students.php - Student Class Migration/Promotion Page

include_once('includes/header.php'); 
$conn = getDBConnection(); // Database connection object

// --- Initial Setup and Data Fetching ---
// Active Session aur Next Session fetch karein.
$current_session_id = $settings['academic.active_session_id'] ?? 1;

// Next Session ID find karein (Assuming sessions have ascending IDs)
$next_session_result = $conn->query("SELECT id FROM academic_sessions WHERE id > {$current_session_id} ORDER BY id ASC LIMIT 1");
$next_session_id = $next_session_result->num_rows > 0 ? $next_session_result->fetch_assoc()['id'] : null;

// Classes fetch karein
$classes_result = $conn->query("SELECT id, name FROM academic_classes ORDER BY order_no ASC");
$classes = $classes_result->fetch_all(MYSQLI_ASSOC);

$message = '';
$error = '';

// --- Migration/Promotion Logic ---
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['migrate_students'])) {
    
    // Authorization Check (Make sure only Admin can do this critical task)
    if ($user_role_id != 1) {
        $error = "Error: Aapke paas yeh action perform karne ki ijazat nahi hai.";
    } else {
        $from_class_id = (int)$_POST['from_class_id'];
        $to_class_id = (int)$_POST['to_class_id'];

        if (empty($from_class_id) || empty($to_class_id) || $from_class_id == $to_class_id) {
            $error = "Error: Please source aur target class theek se select karein. Classes same nahi ho sakti.";
        } elseif (!$next_session_id) {
            $error = "Error: Agla academic session system mein set nahi hai. Pehle naya session banayein.";
        } else {
            // 1. Fetch all students currently enrolled in the FROM Class in the current session.
            $stmt = $conn->prepare("SELECT id FROM students WHERE class_id = ? AND session_id = ? AND status = 'active'");
            $stmt->bind_param("ii", $from_class_id, $current_session_id);
            $stmt->execute();
            $students_result = $stmt->get_result();
            $stmt->close();

            $migrated_count = 0;
            $failed_count = 0;
            $total_students = $students_result->num_rows;
            $student_ids = [];
            while ($row = $students_result->fetch_assoc()) {
                $student_ids[] = (int)$row['id'];
            }

            if (empty($student_ids)) {
                $message = "Is class se migrate karne ke liye koi active student nahi mila.";
            } else {
                // 2. Perform Migration (Update student records)
                // Sabhi students ki class_id aur session_id ko naye values se update karein.
                
                // Note: Agar aap naye records banana chahte hain instead of update, toh logic badlega.
                // Abhi hum assume kar rahe hain ki existing records ko update karna hai (simple promotion).

                $student_id_list = implode(',', $student_ids);
                
                $update_sql = "
                    UPDATE students 
                    SET 
                        class_id = ?, 
                        session_id = ?, 
                        // Status 'promoted' ya 'active' rakh sakte hain. Active rakhte hain.
                        status = 'active' 
                    WHERE 
                        id IN ({$student_id_list}) 
                        AND class_id = ? 
                        AND session_id = ?
                ";

                $stmt = $conn->prepare($update_sql);
                // Parameters: iiis (new class, new session, old class, old session)
                $stmt->bind_param("iiii", $to_class_id, $next_session_id, $from_class_id, $current_session_id);
                
                if ($stmt->execute()) {
                    $migrated_count = $stmt->affected_rows;
                    $message = "✅ **Mubarak ho!** {$migrated_count} students ko naye class mein (Session ID: {$next_session_id}) safaltapoorvak migrate kar diya gaya hai.";
                } else {
                    $error = "Migration karte waqt database error aayi: " . $conn->error;
                }
                $stmt->close();
            }
        }
    }
}
?>

<div class="container-fluid">
    <div class="row">
        <div class="col-lg-12">
            <h2 class="mb-4"><i class="fas fa-exchange-alt"></i> Student Class Migration & Promotion</h2>
            <hr>
            
            <?php if ($message): ?>
                <div class="alert alert-success"><?php echo $message; ?></div>
            <?php endif; ?>
            <?php if ($error): ?>
                <div class="alert alert-danger"><?php echo $error; ?></div>
            <?php endif; ?>

            <?php if (!$next_session_id): ?>
                <div class="alert alert-warning">
                    **Warning:** Agla Academic Session system mein define nahi hai. Promotion/Migration ke liye zaruri hai.
                </div>
            <?php endif; ?>
            
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Class Promotion Setup</h6>
                </div>
                <div class="card-body">
                    <p class="text-info">
                        **Important Note:** Yeh tool students ko current session se naye class aur automatically **agley academic session (ID: <?php echo $next_session_id ?? 'Not Set'; ?>)** mein promote kar dega. Yeh action reversible (undo) nahi hai.
                    </p>

                    <form method="POST" action="migrate_students.php" onsubmit="return confirm('Kya aap yaqeen rakhte hain ki aap is class ke sabhi students ko agli class mein promote karna chahte hain? Yeh action waapas nahi liya ja sakta.');">
                        <input type="hidden" name="migrate_students" value="1">

                        <div class="form-row">
                            <div class="form-group col-md-4">
                                <label for="from_class_id">Migrate **FROM** Class:</label>
                                <select name="from_class_id" id="from_class_id" class="form-control" required>
                                    <option value="">-- Select Current Class --</option>
                                    <?php foreach ($classes as $class): ?>
                                        <option value="<?php echo $class['id']; ?>">
                                            <?php echo htmlspecialchars($class['name']); ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                                <small class="form-text text-muted">Students is class se liye jayenge.</small>
                            </div>

                            <div class="form-group col-md-4">
                                <label for="to_class_id">Migrate **TO** Class:</label>
                                <select name="to_class_id" id="to_class_id" class="form-control" required>
                                    <option value="">-- Select New Class --</option>
                                    <?php foreach ($classes as $class): ?>
                                        <option value="<?php echo $class['id']; ?>">
                                            <?php echo htmlspecialchars($class['name']); ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                                <small class="form-text text-muted">Students is class mein promote kiye jayenge.</small>
                            </div>
                        </div>

                        <button type="submit" class="btn btn-success mt-3" <?php echo !$next_session_id ? 'disabled' : ''; ?>>
                            <i class="fas fa-forward"></i> Promote All Students to Next Class
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<?php
include_once('includes/footer.php');
// Connection close header mein hona chahiye tha, but yahan bhi close kar dete hain agar open reh gaya ho.
if (isset($conn) && $conn) {
    // $conn->close(); // Header mein close ho chuka hai, avoid double close.
}
?>