 <?php
// FILE: admin/notice_board.php

session_start();
ob_start();
include_once('../config/db.php');

$conn = getDBConnection();
$message = '';

// Delete notice functionality
if (isset($_GET['delete_id'])) {
    $delete_id = intval($_GET['delete_id']);
    $stmt = $conn->prepare("DELETE FROM notices WHERE id = ?");
    if ($stmt) {
        $stmt->bind_param("i", $delete_id);
        if ($stmt->execute()) {
            $message = '<div class="alert alert-success">Notice deleted successfully!</div>';
        } else {
            $message = '<div class="alert alert-danger">Error deleting notice: ' . $stmt->error . '</div>';
        }
        $stmt->close();
    }
}

// Add new notice functionality
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['add_notice'])) {
    $title = $_POST['title'] ?? '';
    $description = $_POST['description'] ?? '';
    $notice_date = $_POST['notice_date'] ?? date('Y-m-d');
    $is_active = isset($_POST['is_active']) ? 1 : 0;

    // Validation
    if (empty($title) || empty($notice_date)) {
        $message = '<div class="alert alert-danger">Please fill all required fields.</div>';
    } else {
        $stmt = $conn->prepare("INSERT INTO notices (title, description, notice_date, is_active) VALUES (?, ?, ?, ?)");
        if ($stmt) {
            $stmt->bind_param("sssi", $title, $description, $notice_date, $is_active);
            if ($stmt->execute()) {
                $message = '<div class="alert alert-success">Notice added successfully!</div>';
                // Clear form after success
                $_POST = array();
            } else {
                $message = '<div class="alert alert-danger">Error adding notice: ' . $stmt->error . '</div>';
            }
            $stmt->close();
        } else {
            $message = '<div class="alert alert-danger">Database error: ' . $conn->error . '</div>';
        }
    }
}

// Update notice functionality
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['update_notice'])) {
    $notice_id = intval($_POST['notice_id']);
    $title = $_POST['title'] ?? '';
    $description = $_POST['description'] ?? '';
    $notice_date = $_POST['notice_date'] ?? date('Y-m-d');
    $is_active = isset($_POST['is_active']) ? 1 : 0;

    if (empty($title) || empty($notice_date)) {
        $message = '<div class="alert alert-danger">Please fill all required fields.</div>';
    } else {
        $stmt = $conn->prepare("UPDATE notices SET title = ?, description = ?, notice_date = ?, is_active = ? WHERE id = ?");
        if ($stmt) {
            $stmt->bind_param("sssii", $title, $description, $notice_date, $is_active, $notice_id);
            if ($stmt->execute()) {
                $message = '<div class="alert alert-success">Notice updated successfully!</div>';
            } else {
                $message = '<div class="alert alert-danger">Error updating notice: ' . $stmt->error . '</div>';
            }
            $stmt->close();
        }
    }
}

// Fetch all notices for the table
$notices = [];
$notices_query = "SELECT * FROM notices ORDER BY notice_date DESC, created_at DESC";
$notices_result = $conn->query($notices_query);
if ($notices_result && $notices_result->num_rows > 0) {
    while ($row = $notices_result->fetch_assoc()) {
        $notices[] = $row;
    }
}

// Includes for Page Layout
include('includes/header.php'); 
include_once('includes/sidebar.php');
?>

<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">📌 Notice Board</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="dashboard.php">Home</a></li>
                        <li class="breadcrumb-item active">Notice Board</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    
    <section class="content">
        <div class="container-fluid">
            <?php echo $message; ?>

            <!-- Add Notice Form -->
            <div class="card card-primary">
                <div class="card-header">
                    <h3 class="card-title">➕ Add New Notice</h3>
                    <div class="card-tools">
                        <button type="button" class="btn btn-tool" data-card-widget="collapse">
                            <i class="fas fa-minus"></i>
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <form method="POST" action="notice_board.php">
                        <input type="hidden" name="add_notice" value="1">
                        <div class="row">
                            <div class="form-group col-md-6">
                                <label for="title">Notice Title: <span class="text-danger">*</span></label>
                                <input type="text" name="title" id="title" class="form-control" 
                                       value="<?php echo htmlspecialchars($_POST['title'] ?? ''); ?>" 
                                       placeholder="Enter notice title" required>
                            </div>
                            
                            <div class="form-group col-md-6">
                                <label for="notice_date">Notice Date: <span class="text-danger">*</span></label>
                                <input type="date" name="notice_date" id="notice_date" class="form-control" 
                                       value="<?php echo htmlspecialchars($_POST['notice_date'] ?? date('Y-m-d')); ?>" required>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="description">Notice Description:</label>
                            <textarea name="description" id="description" class="form-control" rows="4" 
                                      placeholder="Enter detailed notice description..."><?php echo htmlspecialchars($_POST['description'] ?? ''); ?></textarea>
                        </div>
                        
                        <div class="form-group">
                            <div class="custom-control custom-switch">
                                <input type="checkbox" class="custom-control-input" id="is_active" name="is_active" value="1" 
                                       <?php echo isset($_POST['is_active']) ? 'checked' : 'checked'; ?>>
                                <label class="custom-control-label" for="is_active">Active Notice</label>
                            </div>
                        </div>
                        
                        <button type="submit" class="btn btn-success">
                            <i class="fas fa-save"></i> Save Notice
                        </button>
                        <button type="reset" class="btn btn-secondary">
                            <i class="fas fa-undo"></i> Reset
                        </button>
                    </form>
                </div>
            </div>

            <!-- Notices List Table -->
            <div class="card card-info mt-4">
                <div class="card-header">
                    <h3 class="card-title">📋 All Notices</h3>
                    <div class="card-tools">
                        <span class="badge badge-light">Total: <?php echo count($notices); ?> notices</span>
                    </div>
                </div>
                <div class="card-body">
                    <?php if (empty($notices)): ?>
                        <div class="alert alert-info text-center">
                            <i class="fas fa-info-circle"></i> No notices found. Add your first notice above.
                        </div>
                    <?php else: ?>
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped table-hover">
                                <thead class="thead-dark">
                                    <tr>
                                        <th width="5%">#</th>
                                        <th width="20%">Title</th>
                                        <th width="35%">Description</th>
                                        <th width="10%">Date</th>
                                        <th width="10%">Status</th>
                                        <th width="15%">Created</th>
                                        <th width="15%">Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($notices as $index => $notice): ?>
                                    <tr>
                                        <td><?php echo $index + 1; ?></td>
                                        <td>
                                            <strong><?php echo htmlspecialchars($notice['title']); ?></strong>
                                        </td>
                                        <td>
                                            <?php 
                                            $description = $notice['description'];
                                            if (strlen($description) > 100) {
                                                echo htmlspecialchars(substr($description, 0, 100)) . '...';
                                            } else {
                                                echo htmlspecialchars($description);
                                            }
                                            ?>
                                        </td>
                                        <td><?php echo date('d M Y', strtotime($notice['notice_date'])); ?></td>
                                        <td class="text-center">
                                            <?php if ($notice['is_active'] == 1): ?>
                                                <span class="badge badge-success">Active</span>
                                            <?php else: ?>
                                                <span class="badge badge-secondary">Inactive</span>
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo date('d M Y', strtotime($notice['created_at'])); ?></td>
                                        <td>
                                            <div class="btn-group btn-group-sm">
                                                <!-- Edit Button -->
                                                <button type="button" class="btn btn-warning" 
                                                        onclick="editNotice(<?php echo $notice['id']; ?>)"
                                                        data-toggle="modal" data-target="#editNoticeModal">
                                                    <i class="fas fa-edit"></i> Edit
                                                </button>
                                                <!-- Delete Button -->
                                                <a href="notice_board.php?delete_id=<?php echo $notice['id']; ?>" 
                                                   class="btn btn-danger" 
                                                   onclick="return confirm('Are you sure you want to delete this notice?')">
                                                    <i class="fas fa-trash"></i> Delete
                                                </a>
                                            </div>
                                        </td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
            
        </div>
    </section>
</div>

<!-- Edit Notice Modal -->
<div class="modal fade" id="editNoticeModal" tabindex="-1" role="dialog" aria-labelledby="editNoticeModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editNoticeModalLabel">✏️ Edit Notice</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form id="editNoticeForm" method="POST" action="notice_board.php">
                    <input type="hidden" name="update_notice" value="1">
                    <input type="hidden" name="notice_id" id="edit_notice_id">
                    
                    <div class="form-group">
                        <label for="edit_title">Notice Title: <span class="text-danger">*</span></label>
                        <input type="text" name="title" id="edit_title" class="form-control" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="edit_description">Notice Description:</label>
                        <textarea name="description" id="edit_description" class="form-control" rows="4"></textarea>
                    </div>
                    
                    <div class="row">
                        <div class="form-group col-md-6">
                            <label for="edit_notice_date">Notice Date: <span class="text-danger">*</span></label>
                            <input type="date" name="notice_date" id="edit_notice_date" class="form-control" required>
                        </div>
                        
                        <div class="form-group col-md-6">
                            <label>Status:</label>
                            <div class="custom-control custom-switch mt-2">
                                <input type="checkbox" class="custom-control-input" id="edit_is_active" name="is_active" value="1">
                                <label class="custom-control-label" for="edit_is_active">Active Notice</label>
                            </div>
                        </div>
                    </div>
                    
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-primary">Update Notice</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
// Function to populate edit form with notice data
function editNotice(noticeId) {
    // You can implement AJAX here to fetch notice data
    // For now, we'll use a simple approach - you can enhance with AJAX later
    console.log('Editing notice ID: ' + noticeId);
    
    // In a real implementation, you would fetch data via AJAX and populate the form
    // This is a placeholder for the actual implementation
}

// Auto-hide alerts after 5 seconds
setTimeout(function() {
    $('.alert').fadeOut('slow');
}, 5000);

// Initialize tooltips
$(function () {
    $('[data-toggle="tooltip"]').tooltip();
});
</script>

<?php 
// Connection Closure 
if (isset($conn) && $conn instanceof mysqli) {
    //@$conn->close();
}

include_once('includes/footer.php'); 
ob_end_flush();
?>