<?php
// FILE: admin/print_session_result.php - Combined Session Result Card View (Class/Section Filter)

session_start();
ob_start();
include_once('../config/db.php');
include_once('includes/header.php'); // Aapke system ka header

$conn = getDBConnection();

// --- START: Settings Fetch Logic (Robust version) ---
$settings_data = [];
$settings_query = $conn->query("SELECT setting_key, setting_value FROM settings");
if ($settings_query) {
    while ($row = $settings_query->fetch_assoc()) {
        $settings_data[trim($row['setting_key'])] = trim($row['setting_value']);
    }
}

// Map possible keys to standardized $settings array:
$settings['institute_name'] = $settings_data['institute.name'] ?? $settings_data['institute name'] ?? $settings_data['institute_name'] ?? "SCHOOL NAME (UPDATE SETTINGS)";
$settings['institute_address'] = $settings_data['institute.address'] ?? $settings_data['institute address'] ?? $settings_data['institute_address'] ?? "Address Not Set";
$settings['institute_phone'] = $settings_data['institute.phone'] ?? $settings_data['institute phone'] ?? $settings_data['institute_phone'] ?? ""; 
$current_session_id = $settings_data['academic.active_session_id'] ?? 1;

// Logo URL
$rawLogoPath = $settings_data['institute.logo_path'] ?? $settings_data['institute logo path'] ?? '';
$logoPathParts = explode('|', $rawLogoPath);
$cleanLogoPath = trim($logoPathParts[0]);
$settings['logo_url'] = !empty($cleanLogoPath) ? '../' . $cleanLogoPath : null;
// --- END: Settings Fetch Logic ---

// Fetch all sessions for dropdown
$sessions_result = $conn->query("SELECT id, name FROM academic_sessions ORDER BY id DESC");
$sessions = $sessions_result->fetch_all(MYSQLI_ASSOC);

$selected_session_id = $_GET['session_id'] ?? $current_session_id;
$selected_class_id = $_GET['class_id'] ?? null;
$selected_section_id = $_GET['section_id'] ?? null;

// Filter options
$exams = $conn->query("SELECT id, name FROM exams WHERE session_id = {$selected_session_id} ORDER BY id ASC")->fetch_all(MYSQLI_ASSOC); 
$classes = $conn->query("SELECT id, name FROM academic_classes ORDER BY order_no ASC")->fetch_all(MYSQLI_ASSOC);
$sections = $conn->query("SELECT id, name FROM academic_sections WHERE status='active' ORDER BY name ASC")->fetch_all(MYSQLI_ASSOC);

$students_to_list = [];

if ($selected_class_id) {
    $class_id = (int)$selected_class_id;
    $section_id = $selected_section_id ? (int)$selected_section_id : NULL;

    // Fetch Students List
    $query = "
        SELECT 
            s.id, s.first_name, s.last_name, s.father_name, s.phone,
            en.roll_no, 
            ac.name as class_name, 
            asec.name as section_name
        FROM students s
        JOIN student_enrollments en ON s.id = en.student_id
        JOIN academic_classes ac ON en.class_id = ac.id
        LEFT JOIN academic_sections asec ON en.section_id = asec.id
        WHERE en.session_id = ? AND en.class_id = ? AND s.status = 'active'
    ";
    $params = [$selected_session_id, $class_id];
    $types = "ii";

    if ($section_id !== NULL) {
        $query .= " AND en.section_id = ?";
        $params[] = $section_id;
        $types .= "i";
    }
    
    $query .= " ORDER BY en.roll_no ASC";
    
    $stmt = $conn->prepare($query);
    $stmt->bind_param($types, ...$params);
    $stmt->execute();
    $students_to_list = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
    $stmt->close();
}
?>

<h1 class="mb-4">Print Student Session Result <i class="fas fa-chart-line"></i></h1>

<div class="card p-3 mb-4 shadow-sm">
    <h5 class="card-title">Select Session, Class and Section</h5>
    <form method="GET" action="print_session_result.php" class="form-inline">
        <div class="form-group mr-3 mb-2">
            <label class="mr-2">Session:</label>
            <select name="session_id" class="form-control" required onchange="this.form.submit()">
                <option value="">-- Select Session --</option>
                <?php foreach ($sessions as $session): ?>
                    <option value="<?php echo $session['id']; ?>" <?php echo $selected_session_id == $session['id'] ? 'selected' : ''; ?>>
                        <?php echo htmlspecialchars($session['name']); ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="form-group mr-3 mb-2">
            <label class="mr-2">Class:</label>
            <select name="class_id" class="form-control" required>
                <option value="">-- Select Class --</option>
                <?php foreach ($classes as $class): ?>
                    <option value="<?php echo $class['id']; ?>" <?php echo $selected_class_id == $class['id'] ? 'selected' : ''; ?>>
                        <?php echo htmlspecialchars($class['name']); ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="form-group mr-3 mb-2">
            <label class="mr-2">Section (Optional):</label>
            <select name="section_id" class="form-control">
                <option value="">-- All Sections --</option>
                <?php foreach ($sections as $section): ?>
                    <option value="<?php echo $section['id']; ?>" <?php echo $selected_session_id == $section['id'] ? 'selected' : ''; ?>>
                        <?php echo htmlspecialchars($section['name']); ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
        
        <button type="submit" class="btn btn-primary mb-2"><i class="fas fa-search"></i> Generate List</button>
    </form>
</div>

<?php if ($selected_class_id && count($students_to_list) > 0): ?>
    
    <div class="alert alert-info">
        Found **<?php echo count($students_to_list); ?>** student(s) in the selected class/section.
    </div>

    <a href="print_session_class_view.php?session_id=<?php echo htmlspecialchars($selected_session_id); ?>&class_id=<?php echo htmlspecialchars($selected_class_id); ?>&section_id=<?php echo htmlspecialchars($selected_section_id); ?>" target="_blank" class="btn btn-success mb-4">
        <i class="fas fa-print"></i> Print Class Result (All Students)
    </a>

    
    <div class="card p-4 shadow-sm">
        <h5>Student List</h5>
        <table class="table table-bordered table-striped">
            <thead>
                <tr>
                    <th>Roll No</th>
                    <th>Student Name</th>
                    <th>Father Name</th>
                    <th>Class/Section</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($students_to_list as $student): ?>
                <tr>
                    <td><?php echo htmlspecialchars($student['roll_no']); ?></td>
                    <td><?php echo htmlspecialchars($student['first_name'] . ' ' . $student['last_name']); ?></td>
                    <td><?php echo htmlspecialchars($student['father_name']); ?></td>
                    <td><?php echo htmlspecialchars($student['class_name']) . " (" . htmlspecialchars($student['section_name'] ?? 'A') . ")"; ?></td>
                    <td>
                        <a href="print_session_individual_view.php?session_id=<?php echo htmlspecialchars($selected_session_id); ?>&class_id=<?php echo htmlspecialchars($selected_class_id); ?>&student_id=<?php echo $student['id']; ?>" target="_blank" class="btn btn-sm btn-info">
                            <i class="fas fa-id-card"></i> Print Result
                        </a>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>

<?php elseif ($selected_class_id): ?>
    <div class="alert alert-danger">No active students found in the selected class/section.</div>
<?php else: ?>
    <div class="alert alert-warning">Please select the **Session**, **Class** and click **Generate List** to view students.</div>
<?php endif; ?>

<?php
if (isset($conn) && is_object($conn)) {
    $conn->close();
}
include_once('includes/footer.php');
ob_end_flush();
?>