 <?php
include_once('includes/header.php'); 
include_once('includes/sidebar.php'); 

$conn = getDBConnection();
$message = $_GET['msg'] ?? '';

// --- Filters Setup ---
$current_session_id = $settings['academic.active_session_id'];
$start_date = $_GET['start_date'] ?? date('Y-m-01');
$end_date = $_GET['end_date'] ?? date('Y-m-d');
$selected_class_id = $_GET['class_id'] ?? null;

// Classes list for filter
$classes_result = $conn->query("SELECT id, name FROM academic_classes ORDER BY order_no ASC");
$classes = $classes_result->fetch_all(MYSQLI_ASSOC);

$attendance_summary = [];

if ($selected_class_id) {
    $class_id = (int)$selected_class_id;

    // 1. Total working days in selected range for this class
    $total_days_query = "
        SELECT COUNT(DISTINCT attendance_date) AS total_days
        FROM daily_attendance_sheets
        WHERE session_id = {$current_session_id} AND class_id = {$class_id}
          AND attendance_date BETWEEN '{$start_date}' AND '{$end_date}'
    ";
    $total_days_result = $conn->query($total_days_query);
    $total_working_days = $total_days_result->fetch_assoc()['total_days'] ?? 0;

    // 2. Student-wise Attendance Summary
    if ($total_working_days > 0) {
        $summary_query = "
            SELECT 
                s.id AS student_id, 
                s.first_name, 
                s.last_name, 
                en.roll_no,
                SUM(CASE WHEN dar.status = 'Present' THEN 1 ELSE 0 END) AS present_count,
                SUM(CASE WHEN dar.status = 'Absent' THEN 1 ELSE 0 END) AS absent_count,
                SUM(CASE WHEN dar.status = 'Leave' THEN 1 ELSE 0 END) AS leave_count
            FROM students s
            JOIN student_enrollments en ON s.id = en.student_id AND en.session_id = {$current_session_id} AND en.class_id = {$class_id}
            JOIN daily_attendance_sheets das ON das.session_id = en.session_id AND das.class_id = en.class_id AND das.section_id = en.section_id
            LEFT JOIN daily_attendance_records dar ON dar.sheet_id = das.id AND dar.student_id = s.id
            WHERE s.status = 'active'
              AND das.attendance_date BETWEEN '{$start_date}' AND '{$end_date}'
            GROUP BY s.id, s.first_name, s.last_name, en.roll_no
            ORDER BY en.roll_no ASC
        ";
        $summary_result = $conn->query($summary_query);
        $attendance_summary = $summary_result->fetch_all(MYSQLI_ASSOC);
    }
}

$conn->close();
?>

<h1 class="mb-4">Attendance Summary Report 📅</h1>

<div class="card p-3 mb-4">
    <h5 class="card-title">Select Class & Date Range</h5>
    <form method="GET" action="reports_attendance.php" class="form-inline">
        <div class="form-group mr-3">
            <label class="mr-2">Class:</label>
            <select name="class_id" class="form-control" required>
                <option value="">-- Select Class --</option>
                <?php foreach ($classes as $class): ?>
                    <option value="<?php echo $class['id']; ?>" <?php echo $selected_class_id == $class['id'] ? 'selected' : ''; ?>><?php echo htmlspecialchars($class['name']); ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="form-group mr-3">
            <label class="mr-2">From Date:</label>
            <input type="date" name="start_date" class="form-control" value="<?php echo htmlspecialchars($start_date); ?>" required>
        </div>
        <div class="form-group mr-3">
            <label class="mr-2">To Date:</label>
            <input type="date" name="end_date" class="form-control" value="<?php echo htmlspecialchars($end_date); ?>" required>
        </div>
        <button type="submit" class="btn btn-info">Generate Report</button>
    </form>
</div>

<?php if ($selected_class_id): ?>
    
    <h4 class="mt-4">Attendance Analysis (Total Days: **<?php echo $total_working_days ?? 0; ?>**)</h4>
    
    <?php if ($total_working_days == 0): ?>
        <div class="alert alert-warning">Is class ke liye selected date range mein koi attendance record nahi mila.</div>
    <?php elseif (count($attendance_summary) > 0): ?>
        
        <div class="table-responsive">
            <table class="table table-bordered table-striped table-sm">
                <thead>
                    <tr class="bg-secondary text-white">
                        <th>Roll No</th>
                        <th>Student Name</th>
                        <th>Present (Days)</th>
                        <th>Absent (Days)</th>
                        <th>Leave (Days)</th>
                        <th>Attendance %</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($attendance_summary as $summary): ?>
                    <?php 
                        $total_days = $summary['present_count'] + $summary['absent_count'] + $summary['leave_count'];
                        // Agar total days record mein kam hain to working days use karein
                        $base_days = ($total_days < $total_working_days) ? $total_working_days : $total_days; 
                        $attendance_perc = ($base_days > 0) ? ($summary['present_count'] / $base_days) * 100 : 0;
                    ?>
                    <tr>
                        <td><?php echo htmlspecialchars($summary['roll_no']); ?></td>
                        <td><?php echo htmlspecialchars($summary['first_name'] . ' ' . $summary['last_name']); ?></td>
                        <td><?php echo $summary['present_count']; ?></td>
                        <td><span class="text-danger"><?php echo $summary['absent_count']; ?></span></td>
                        <td><?php echo $summary['leave_count']; ?></td>
                        <td class="font-weight-bold <?php echo ($attendance_perc < 75) ? 'text-danger' : 'text-success'; ?>">
                            <?php echo number_format($attendance_perc, 2) . ' %'; ?>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    <?php else: ?>
        <div class="alert alert-warning">Is Class mein koi active student nahi mila.</div>
    <?php endif; ?>
<?php else: ?>
    <div class="alert alert-info">Barah-e-meherbani class aur date range select karein.</div>
<?php endif; ?>

<?php
include_once('includes/footer.php'); 
?>