 <?php
include_once('includes/header.php'); 
include_once('includes/sidebar.php'); 

$conn = getDBConnection();
$message = $_GET['msg'] ?? '';

// --- Data Fetching ---
$current_session_id = $settings['academic.active_session_id'];

// 1. Fetch relevant data (Invoices, Payments, Students)
$fees_report_query = "
    SELECT 
        ac.name AS class_name,
        ac.order_no,
        COUNT(fi.id) AS total_vouchers,
        SUM(fi.total_amount) AS gross_fee,
        SUM(fi.net_payable) AS net_fee_payable,
        SUM(fi.amount_paid) AS total_paid,
        SUM(fi.net_payable - fi.amount_paid) AS total_due
    FROM fee_invoices fi
    JOIN student_enrollments en ON fi.student_id = en.student_id AND fi.session_id = en.session_id
    JOIN academic_classes ac ON en.class_id = ac.id
    WHERE fi.session_id = {$current_session_id}
    GROUP BY ac.name, ac.order_no
    ORDER BY ac.order_no ASC
";
$report_result = $conn->query($fees_report_query);
$fees_summary = $report_result->fetch_all(MYSQLI_ASSOC);

// 2. Fetch overall totals
$overall_totals_query = "
    SELECT 
        COUNT(id) AS total_invoices,
        SUM(net_payable) AS grand_net_payable,
        SUM(amount_paid) AS grand_total_paid,
        SUM(net_payable - amount_paid) AS grand_total_due
    FROM fee_invoices 
    WHERE session_id = {$current_session_id}
";
$overall_totals_result = $conn->query($overall_totals_query);
$overall_totals = $overall_totals_result->fetch_assoc();

$conn->close();
?>

<h1 class="mb-4">Fees Collection Report 💰</h1>

<?php if ($message): ?>
    <div class="alert alert-success"><?php echo htmlspecialchars($message); ?></div>
<?php endif; ?>

<div class="card p-3 mb-4">
    <h5 class="card-title">Overall Summary (Current Session)</h5>
    <div class="row">
        <div class="col-md-3">**Total Payable:** Rs. <?php echo number_format($overall_totals['grand_net_payable'] ?? 0); ?></div>
        <div class="col-md-3">**Total Collected:** Rs. <?php echo number_format($overall_totals['grand_total_paid'] ?? 0); ?></div>
        <div class="col-md-3">**Total Dues:** Rs. <?php echo number_format($overall_totals['grand_total_due'] ?? 0); ?></div>
        <div class="col-md-3">**Total Vouchers:** <?php echo number_format($overall_totals['total_invoices'] ?? 0); ?></div>
    </div>
</div>

<h4 class="mt-4">Fees Summary By Class</h4>
<div class="table-responsive">
    <table class="table table-bordered table-striped table-sm">
        <thead>
            <tr class="bg-primary text-white">
                <th>Class Name</th>
                <th>Vouchers</th>
                <th>Net Fee Payable</th>
                <th>Total Collected</th>
                <th>**Total Dues**</th>
                <th>Collection %</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($fees_summary as $summary): ?>
            <tr>
                <td>**<?php echo htmlspecialchars($summary['class_name']); ?>**</td>
                <td><?php echo number_format($summary['total_vouchers']); ?></td>
                <td>Rs. <?php echo number_format($summary['net_fee_payable']); ?></td>
                <td>Rs. <?php echo number_format($summary['total_paid']); ?></td>
                <td class="font-weight-bold text-danger">Rs. <?php echo number_format($summary['total_due']); ?></td>
                <td>
                    <?php 
                        $collection_perc = ($summary['net_fee_payable'] > 0) ? ($summary['total_paid'] / $summary['net_fee_payable']) * 100 : 0;
                        echo number_format($collection_perc, 2) . ' %'; 
                    ?>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<?php
include_once('includes/footer.php'); 
?>