<?php
// admin/reports_results.php - Exam Result Reports (Class-wise Summary)

session_start();
include_once('../config/db.php');
include_once('includes/header.php'); 
include_once('includes/sidebar.php'); 

$conn = getDBConnection();
$message = $_GET['msg'] ?? '';

// --- Data Fetching ---
// Assumption: $settings array header.php ya kisi aur file se available hai.
$current_session_id = $settings['academic.active_session_id'] ?? 1;

// Exams list for filter (Only exams jinka status 'completed' hai)
// FIX/CONFIRMATION: Yeh query sirf un exams ko load karegi jinka result lock ho chuka hai.
$exams_result = $conn->query("SELECT id, name FROM exams WHERE session_id = {$current_session_id} AND status='completed' ORDER BY id DESC");
$exams = $exams_result->fetch_all(MYSQLI_ASSOC);

$selected_exam_id = $_GET['exam_id'] ?? null;
$result_analysis = [];
$exam_name = '';

if ($selected_exam_id) {
    $exam_id = (int)$selected_exam_id;
    
    $exam_name_res = $conn->query("SELECT name FROM exams WHERE id = {$exam_id}");
    $exam_name = $exam_name_res->fetch_assoc()['name'] ?? 'Selected Exam';

    // 1. Class-wise Result Analysis (Data comes from student_results after calculation)
    $analysis_query = "
        SELECT 
            ac.name AS class_name,
            ac.order_no,
            COUNT(sr.student_id) AS total_students_resulted,
            SUM(CASE WHEN sr.result_status = 'Pass' THEN 1 ELSE 0 END) AS pass_count,
            SUM(CASE WHEN sr.result_status = 'Fail' THEN 1 ELSE 0 END) AS fail_count,
            SUM(CASE WHEN sr.result_status = 'Incomplete' THEN 1 ELSE 0 END) AS incomplete_count,
            AVG(sr.final_percentage) AS average_percentage
        FROM student_results sr
        JOIN academic_classes ac ON sr.class_id = ac.id
        WHERE sr.exam_id = {$exam_id}
        GROUP BY sr.class_id, ac.name, ac.order_no
        ORDER BY ac.order_no ASC
    ";
    $analysis_result = $conn->query($analysis_query);
    if ($analysis_result) {
        $result_analysis = $analysis_result->fetch_all(MYSQLI_ASSOC);
    }
}

$conn->close();
?>

<h1 class="mb-4">Result Reports (Class Summary) <i class="fas fa-chart-bar"></i></h1>

<?php if ($message): ?>
    <div class="alert alert-success"><?php echo htmlspecialchars($message); ?></div>
<?php endif; ?>

<div class="card p-3 mb-4 shadow-sm">
    <h5 class="card-title">Select Exam for Report</h5>
    <form method="GET" action="reports_results.php" class="form-inline">
        <div class="form-group mr-3 mb-2">
            <label class="mr-2">Finalized Exam:</label>
            <select name="exam_id" class="form-control" required>
                <option value="">-- Select Exam --</option>
                <?php foreach ($exams as $exam): ?>
                    <option value="<?php echo $exam['id']; ?>" <?php echo $selected_exam_id == $exam['id'] ? 'selected' : ''; ?>><?php echo htmlspecialchars($exam['name']); ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <button type="submit" class="btn btn-info mb-2"><i class="fas fa-search"></i> Show Report</button>
    </form>
</div>

<?php if ($selected_exam_id): ?>
    <h3 class="mb-3">Summary for: **<?php echo htmlspecialchars($exam_name); ?>**</h3>
    
    <?php if (count($result_analysis) > 0): ?>
        <div class="table-responsive">
            <table class="table table-bordered table-striped table-hover table-sm">
                <thead class="thead-dark">
                    <tr>
                        <th>Class</th>
                        <th>Total Students</th>
                        <th>Passed</th>
                        <th>Failed</th>
                        <th>Incomplete</th>
                        <th>Pass Percentage</th>
                        <th>Class Average %</th>
                    </tr>
                </thead>
                <tbody>
                    <?php 
                    $grand_total = 0;
                    $grand_pass = 0;
                    foreach ($result_analysis as $analysis): 
                        $pass_perc = ($analysis['total_students_resulted'] > 0) ? ($analysis['pass_count'] / $analysis['total_students_resulted']) * 100 : 0;
                        $grand_total += $analysis['total_students_resulted'];
                        $grand_pass += $analysis['pass_count'];
                    ?>
                    <tr>
                        <td class="font-weight-bold"><?php echo htmlspecialchars($analysis['class_name']); ?></td>
                        <td><?php echo $analysis['total_students_resulted']; ?></td>
                        <td><span class="text-success font-weight-bold"><?php echo $analysis['pass_count']; ?></span></td>
                        <td><span class="text-danger"><?php echo $analysis['fail_count']; ?></span></td>
                        <td><span class="text-warning"><?php echo $analysis['incomplete_count']; ?></span></td>
                        <td class="font-weight-bold"><?php echo number_format($pass_perc, 2) . ' %'; ?></td>
                        <td><?php echo number_format($analysis['average_percentage'], 2) . ' %'; ?></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
                <tfoot>
                    <tr class="table-info font-weight-bold">
                        <td>**GRAND TOTAL**</td>
                        <td><?php echo $grand_total; ?></td>
                        <td><?php echo $grand_pass; ?></td>
                        <td><?php echo $grand_total - $grand_pass; ?></td>
                        <td>-</td>
                        <td><?php echo number_format(($grand_total > 0) ? ($grand_pass / $grand_total) * 100 : 0, 2) . ' %'; ?></td>
                        <td>-</td>
                    </tr>
                </tfoot>
            </table>
        </div>
        
        <p class="mt-4"><a href="detailed_result.php?exam_id=<?php echo $selected_exam_id; ?>" class="btn btn-primary"><i class="fas fa-eye"></i> View Detailed Result (Student Wise)</a></p>
        
    <?php else: ?>
        <div class="alert alert-warning">Is Exam ka koi final result record nahi mila. Barah-e-meherbani Result Generate page se result calculate karein.</div>
    <?php endif; ?>
<?php else: ?>
    <div class="alert alert-info">Barah-e-meherbani finalized exam select karein.</div>
<?php endif; ?>

<?php
include_once('includes/footer.php'); 
?>