<?php
// admin/result_generate.php - Result Generation & Calculation Interface

session_start();
include_once('../config/db.php'); // Connection ke liye zaroori
include_once('includes/header.php'); 
include_once('includes/sidebar.php'); 

// Connection establish karein.
$conn = getDBConnection();
$message = $_GET['msg'] ?? '';
$error = $_GET['err'] ?? '';

// --- Data Fetching ---
// Assumption: $settings array header.php ya kisi aur file se available hai.
$current_session_id = $settings['academic.active_session_id'] ?? 1;

// Fetch Exams jo marks entry ke liye available hain ya ho chuke hain, lekin result lock nahi hua.
// Hum 'active' exams ko target karenge. 'completed' exams yahan show nahi hone chahiye.
$exams_result = $conn->query("SELECT id, name FROM exams WHERE session_id = {$current_session_id} AND status = 'active' ORDER BY id DESC");
$exams = $exams_result->fetch_all(MYSQLI_ASSOC);

$conn->close();
?>

<h1 class="mb-4">Result Generation & Calculation <i class="fas fa-calculator"></i></h1>

<?php if ($message): ?>
    <div class="alert alert-success"><?php echo htmlspecialchars($message); ?></div>
<?php endif; ?>
<?php if ($error): ?>
    <div class="alert alert-danger"><?php echo htmlspecialchars($error); ?></div>
<?php endif; ?>

<div class="card p-4 shadow-sm">
    <h4 class="card-title">Generate and Lock Results</h4>
    <p class="text-info">Is process se selected Exam ke tamam students ke marks calculate honge, result status (Pass/Fail) determine hoga aur final result database mein save hoga. **Yeh process marks entry ke baad sirf ek baar chalaya jaana chahiye.**</p>
    
    <form action="exams_process.php" method="POST">
        <input type="hidden" name="action" value="calculate_results">
        <input type="hidden" name="session_id" value="<?php echo $current_session_id; ?>">

        <div class="form-group col-md-6">
            <label>Select Exam to Finalize:</label>
            <select name="exam_id" class="form-control" required>
                <option value="">-- Select Exam --</option>
                <?php foreach ($exams as $exam): ?>
                    <option value="<?php echo $exam['id']; ?>"><?php echo htmlspecialchars($exam['name']); ?></option>
                <?php endforeach; ?>
            </select>
        </div>

        <?php if (count($exams) > 0): ?>
            <button type="submit" class="btn btn-danger btn-lg mt-3" onclick="return confirm('WARNING: Kya aap waqai is Exam ka final result calculate aur save karna chahte hain? Mark entry iske baad nahi hogi aur Exam status COMPLETED ho jayega!');">
                <i class="fas fa-calculator"></i> Calculate & Lock Result
            </button>
        <?php else: ?>
            <div class="alert alert-warning">Koi **Active** Exam Result Generation ke liye available nahi hai. Pehle Exam Add karein aur use Marks Entry ke liye **Active** karein.</div>
        <?php endif; ?>
    </form>
</div>

<?php
include_once('includes/footer.php'); 
?>