<?php
// admin/student_edit.php (Complete Edit Form View)
session_start();
include_once('includes/header.php'); 
include_once('includes/sidebar.php'); 
// Ensure your database connection and helper functions are available
$conn = getDBConnection(); 

$student_id = (int)($_GET['id'] ?? 0);
$message = $_GET['msg'] ?? '';
$error = $_GET['err'] ?? '';

if ($student_id == 0) {
    header('Location: students.php?err=' . urlencode('Invalid Student ID for editing.'));
    exit;
}

// --- Data Fetching ---

// 1. Fetch Student Basic Details
$student_query = "SELECT * FROM students WHERE id = {$student_id}";
$student_result = $conn->query($student_query);
$student = $student_result->fetch_assoc();

if (!$student) {
    header('Location: students.php?err=' . urlencode('Student record not found.'));
    exit;
}

// 2. Fetch Current Enrollment Details
$current_session_id = $settings['academic.active_session_id'];
$enrollment_query = "SELECT * FROM student_enrollments WHERE student_id = {$student_id} AND session_id = {$current_session_id}";
$enrollment_result = $conn->query($enrollment_query);
$enrollment = $enrollment_result->fetch_assoc(); // Agar current session mein enrolled nahi hai, to null aayega

// 3. Fetch all Classes and Sessions for dropdowns
$classes_result = $conn->query("SELECT id, name FROM academic_classes ORDER BY order_no ASC");
$classes = $classes_result->fetch_all(MYSQLI_ASSOC);

$sessions_result = $conn->query("SELECT id, name FROM academic_sessions ORDER BY id DESC");
$sessions = $sessions_result->fetch_all(MYSQLI_ASSOC);


$conn->close(); 
?>

<h1 class="mb-4">Edit Student: <?php echo htmlspecialchars($student['first_name'] . ' ' . $student['last_name']); ?></h1>

<?php if ($message): ?>
    <div class="alert alert-success"><?php echo htmlspecialchars($message); ?></div>
<?php endif; ?>
<?php if ($error): ?>
    <div class="alert alert-danger"><?php echo htmlspecialchars($error); ?></div>
<?php endif; ?>

<div class="card p-4">
    <h4 class="card-title">Update Student Information</h4>
    
    <form action="students_process.php" method="POST">
        <input type="hidden" name="action" value="update_student">
        <input type="hidden" name="student_id" value="<?php echo $student['id']; ?>">

        <h5 class="mt-4 mb-3 text-primary">A. Personal Details</h5>
        <div class="form-row">
            <div class="form-group col-md-4">
                <label>First Name:</label>
                <input type="text" name="first_name" class="form-control" value="<?php echo htmlspecialchars($student['first_name']); ?>" required>
            </div>
            <div class="form-group col-md-4">
                <label>Last Name:</label>
                <input type="text" name="last_name" class="form-control" value="<?php echo htmlspecialchars($student['last_name']); ?>">
            </div>
            <div class="form-group col-md-4">
                <label>Father Name:</label>
                <input type="text" name="father_name" class="form-control" value="<?php echo htmlspecialchars($student['father_name']); ?>" required>
            </div>
        </div>
        
        <div class="form-row">
            <div class="form-group col-md-3">
                <label>Date of Birth:</label>
                <input type="date" name="dob" class="form-control" value="<?php echo htmlspecialchars($student['dob']); ?>">
            </div>
            <div class="form-group col-md-3">
                <label>Phone No:</label>
                <input type="text" name="phone" class="form-control" value="<?php echo htmlspecialchars($student['phone']); ?>">
            </div>
            <div class="form-group col-md-3">
                <label>Admission Date:</label>
                <input type="date" name="admission_date" class="form-control" value="<?php echo htmlspecialchars($student['admission_date']); ?>" required>
            </div>
            <div class="form-group col-md-3">
                <label>Status:</label>
                
                <select name="status" class="form-control" 
                    <?php 
                        // Agar status 'withdrawn' hai, to dropdown ko disable kar dein
                        if ($student['status'] == 'withdrawn') {
                            echo 'disabled'; 
                        }
                    ?>>
                    
                    <?php if ($student['status'] == 'withdrawn'): ?>
                        <option value="withdrawn" selected>Inactive (Withdrawn)</option>
                    <?php else: ?>
                        <option value="active" <?php echo ($student['status'] == 'active') ? 'selected' : ''; ?>>Active</option>
                        <option value="inactive" <?php echo ($student['status'] == 'inactive') ? 'selected' : ''; ?>>Inactive</option>
                    <?php endif; ?>

                </select>
                
                <?php if ($student['status'] == 'withdrawn'): ?>
                    <input type="hidden" name="status" value="withdrawn"> <small class="form-text text-danger">
                        ⚠️ Status 'Withdrawn' hai aur yahan se badla nahi ja sakta.
                    </small>
                <?php endif; ?>
                </div>
        </div>

        <div class="form-group">
            <label>Address:</label>
            <textarea name="address" class="form-control"><?php echo htmlspecialchars($student['address']); ?></textarea>
        </div>

        <h5 class="mt-4 mb-3 text-primary">B. Current Enrollment Details (Session ID: <?php echo $current_session_id; ?>)</h5>
        
        <div class="alert alert-info">
            **Voucher Fix:** Fees Voucher generate karne ke liye, student ka Enrollment **Active Session ID (<?php echo $current_session_id; ?>)** mein hona zaroori hai. Neeche Enrollment Session aur Class theek karein.
        </div>
        
        <div class="form-row">
            <div class="form-group col-md-4">
                <label>Enrollment Session:</label>
                <select name="enrollment_session_id" class="form-control" required>
                    <?php foreach ($sessions as $session): ?>
                        <option value="<?php echo $session['id']; ?>" 
                            <?php 
                                // Fix karne ke liye, hum Active Session ID ko default select karte hain
                                if ($session['id'] == $current_session_id) { echo 'selected'; } 
                                // Agar student already enrolled hai, to uski enrollment session ID select karein
                                elseif ($enrollment && $session['id'] == $enrollment['session_id']) { echo 'selected'; }
                            ?>>
                            <?php echo htmlspecialchars($session['name']); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
                <input type="hidden" name="old_enrollment_id" value="<?php echo $enrollment['id'] ?? 0; ?>">
            </div>
            
            <div class="form-group col-md-4">
                <label>Enrollment Class:</label>
                <select name="enrollment_class_id" class="form-control" required>
                    <option value="">-- Select Class --</option>
                    <?php 
                    $selected_class_id = $enrollment['class_id'] ?? null;
                    foreach ($classes as $class): ?>
                        <option value="<?php echo $class['id']; ?>" <?php echo ($selected_class_id == $class['id']) ? 'selected' : ''; ?>>
                            <?php echo htmlspecialchars($class['name']); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            
            <div class="form-group col-md-4">
                <label>Roll No (Optional):</label>
                <input type="text" name="roll_no" class="form-control" value="<?php echo htmlspecialchars($enrollment['roll_no'] ?? ''); ?>">
            </div>
        </div>

        <button type="submit" class="btn btn-primary btn-lg mt-3">
            <i class="fas fa-save"></i> Save All Changes
        </button>
        <a href="students.php" class="btn btn-secondary mt-3">Cancel</a>
    </form>
</div>

<?php
include_once('includes/footer.php'); 
?>