<?php
// FILE: admin/student_fee_status_list.php - **CORRECTED** Class aur Current Month ke hisaab se Student List
session_start();
include_once('../config/db.php');
include_once('includes/header.php'); 
include_once('includes/sidebar.php'); 

$conn = getDBConnection();

// [ ... existing code for fetching $classes, $selected_class_id, $current_month, $current_year ... ]
// (Line 15 tak ka code wahi rahega)

// Classes fetch karein
$classes_query = $conn->query("SELECT id, name FROM academic_classes ORDER BY id");
$classes = $classes_query->fetch_all(MYSQLI_ASSOC);

$selected_class_id = (int)($_POST['class_id'] ?? 0);
$current_month = date('n');
$current_year = date('Y');

$student_list = [];
$class_name = "All Classes"; // Default

if ($selected_class_id > 0) {
    // Current Class ka naam
    $class_info = array_filter($classes, function($class) use ($selected_class_id) {
        return $class['id'] == $selected_class_id;
    });
    if (!empty($class_info)) {
        $class_name = array_values($class_info)[0]['name'];
    }

    // Student list aur current month fee status fetch karne ki query
    $query = "
        SELECT 
            s.id AS student_id,
            s.roll_no, 
            CONCAT(s.first_name, ' ', s.last_name) AS student_name,
            ac.name AS class_name,
            
            fi.id AS invoice_id,
            
            -- Check for Payment against that Invoice
            fp.id IS NOT NULL AS is_paid
            
        FROM 
            students s
        JOIN 
            academic_classes ac ON s.class_id = ac.id
            
        -- 1. Check for the Monthly Invoice
        LEFT JOIN 
            fee_invoices fi ON s.id = fi.student_id 
                           AND fi.class_id = ?
                           AND fi.month = ? 
                           AND fi.year = ?
                           
        -- 2. Check for Payment against that Invoice
        LEFT JOIN 
            fee_payments fp ON fi.id = fp.invoice_id
            
        WHERE 
            s.class_id = ?
            AND s.status = 'active' 
            
        GROUP BY
            s.id, fi.id
            
        ORDER BY 
            s.roll_no
    ";
    
    $stmt = $conn->prepare($query);
    $stmt->bind_param("iiii", $selected_class_id, $current_month, $current_year, $selected_class_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $student_list = $result->fetch_all(MYSQLI_ASSOC);
    $stmt->close();
}
// [ ... remaining HTML and PHP code for the list page ... ]

?>

<div class="content-wrapper">
    <div class="container-fluid">
        <h1 class="mt-4"><i class="fas fa-users"></i> Student Fee Status List</h1>
        <ol class="breadcrumb mb-4">
            <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
            <li class="breadcrumb-item active">Student Fee Status</li>
        </ol>

        <div class="card mb-4">
            <div class="card-header"><i class="fas fa-filter"></i> Select Class</div>
            <div class="card-body">
                <form method="POST" action="student_fee_status_list.php" class="form-row">
                    <div class="col-md-6 mb-2">
                        <label for="class_id">Select Class:</label>
                        <select name="class_id" id="class_id" class="form-control" required>
                            <option value="">-- Select Class --</option>
                            <?php foreach ($classes as $class): ?>
                                <option value="<?php echo $class['id']; ?>" 
                                    <?php echo ($selected_class_id == $class['id']) ? 'selected' : ''; ?>>
                                    <?php echo htmlspecialchars($class['name']); ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <div class="col-md-3 mb-2 d-flex align-items-end">
                        <button type="submit" class="btn btn-success btn-block"><i class="fas fa-list-alt"></i> Generate List</button>
                    </div>
                </form>
            </div>
        </div>

        <?php if ($selected_class_id > 0): ?>
            <div class="alert alert-info">
                Showing Fee Status for **<?php echo $class_name; ?>** for the current month: **<?php echo date('F Y'); ?>**.
            </div>

            <?php if (!empty($student_list)): ?>
                <div class="card mb-4">
                    <div class="card-header">
                        <i class="fas fa-users"></i> Students in <?php echo htmlspecialchars($class_name); ?>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-bordered" id="studentListTable" width="100%" cellspacing="0">
                                <thead>
                                    <tr>
                                        <th>Roll No.</th>
                                        <th>Student Name</th>
                                        <th>Class</th>
                                        <th>Fee Status (Current Month)</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($student_list as $student): ?>
                                    <tr>
                                        <td><?php echo htmlspecialchars($student['roll_no']); ?></td>
                                        <td><?php echo htmlspecialchars($student['student_name']); ?></td>
                                        <td><?php echo htmlspecialchars($student['class_name']); ?></td>
                                        <td>
                                            <?php 
                                            // Status check: Invoice found AND Payment found (is_paid is TRUE)
                                            if ($student['invoice_id'] && $student['is_paid']): 
                                            ?>
                                                <span class="badge badge-success"><i class="fas fa-check"></i> PAID HO GAI HAI</span>
                                            <?php 
                                            // Status check: Invoice found BUT NO Payment found
                                            elseif ($student['invoice_id'] && !$student['is_paid']):
                                            ?>
                                                <span class="badge badge-danger"><i class="fas fa-exclamation-triangle"></i> UNPAID HAI</span>
                                            <?php 
                                            // Status check: NO Invoice found
                                            else:
                                            ?>
                                                <span class="badge badge-warning"><i class="fas fa-info-circle"></i> INVOICE PENDING</span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php if ($student['invoice_id']): ?>
                                                <a href="fee_collection.php?invoice_id=<?php echo $student['invoice_id']; ?>" class="btn btn-sm btn-info">
                                                    <i class="fas fa-eye"></i> View/Update Fee
                                                </a>
                                            <?php else: ?>
                                                <a href="create_invoice.php?student_id=<?php echo $student['student_id']; ?>&month=<?php echo $current_month; ?>&year=<?php echo $current_year; ?>" class="btn btn-sm btn-warning">
                                                    <i class="fas fa-file-invoice"></i> Create Invoice
                                                </a>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            <?php else: ?>
                <div class="alert alert-danger">Is Class mein koi student nahi mila.</div>
            <?php endif; ?>
        <?php else: ?>
            <div class="alert alert-warning">Kripya **Class** select karke **Generate List** par click karein.</div>
        <?php endif; ?>

    </div>
</div>

<?php
include_once('includes/footer.php'); 
?>