<?php
// student_leaving.php

include_once('includes/header.php'); 
include_once('includes/sidebar.php'); 
include_once('../config/db.php'); 
$conn = getDBConnection();

$message = $_GET['msg'] ?? '';
$error = $_GET['err'] ?? '';

$settings = [];
$settings_query = $conn->query("SELECT setting_key, setting_value FROM settings");
while ($row = $settings_query->fetch_assoc()) {
    $settings[$row['setting_key']] = $row['setting_value'];
}
$active_session_id = $settings['academic.active_session_id'] ?? 1;

// Fetch Classes
$classes_result = $conn->query("SELECT id, name FROM academic_classes ORDER BY order_no ASC");
$classes_array = $classes_result->fetch_all(MYSQLI_ASSOC);
$classes = array_column($classes_array, 'name', 'id'); 

// Fetch Sections
$sections_result = $conn->query("SELECT id, name FROM academic_sections ORDER BY name ASC");
$sections_array = $sections_result->fetch_all(MYSQLI_ASSOC);
$sections = array_column($sections_array, 'name', 'id'); 

$students = [];
$selected_class_id = (int)($_GET['class_id'] ?? 0);
$selected_section_id = (int)($_GET['section_id'] ?? 0);

if ($selected_class_id > 0 && $selected_section_id > 0) {
    
    // CORRECTED QUERY: Added session_id condition
    $students_query = "
        SELECT 
            s.id, 
            CONCAT(s.first_name, ' ', COALESCE(s.last_name, '')) AS full_name, 
            se.roll_no                                           
        FROM students s
        JOIN student_enrollments se ON s.id = se.student_id
        WHERE se.class_id = ? 
          AND se.section_id = ?
          AND se.session_id = ?  -- ADDED THIS LINE
          AND s.status = 'active'               
        ORDER BY se.roll_no ASC
    ";
    
    $student_stmt = $conn->prepare($students_query);
    $student_stmt->bind_param("iii", $selected_class_id, $selected_section_id, $active_session_id); 
    $student_stmt->execute();
    $students = $student_stmt->get_result()->fetch_all(MYSQLI_ASSOC);
    $student_stmt->close();
}

$conn->close();
?>

<h1 class="mb-4">School Leaving / Withdrawal Management</h1>

<?php if ($message): ?>
    <div class="alert alert-success"><?php echo htmlspecialchars($message); ?></div>
<?php endif; ?>

<?php if ($error): ?>
    <div class="alert alert-danger"><?php echo htmlspecialchars($error); ?></div>
<?php endif; ?>

<div class="card mb-4">
    <div class="card-header">Select Class and Section</div>
    <div class="card-body">
        <form method="GET" action="student_leaving.php">
            <div class="form-row">
                <div class="form-group col-md-4">
                    <label for="class_id">Select Class:</label>
                    <select name="class_id" id="class_id" class="form-control" required>
                        <option value="">-- Select Class --</option>
                        <?php foreach ($classes_array as $class): ?>
                            <option value="<?php echo $class['id']; ?>" <?php echo ($selected_class_id == $class['id']) ? 'selected' : ''; ?>>
                                <?php echo htmlspecialchars($class['name']); ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="form-group col-md-4">
                    <label for="section_id">Select Section:</label>
                    <select name="section_id" id="section_id" class="form-control" required>
                        <option value="">-- Select Section --</option>
                        <?php foreach ($sections_array as $section): ?>
                            <option value="<?php echo $section['id']; ?>" <?php echo ($selected_section_id == $section['id']) ? 'selected' : ''; ?>>
                                <?php echo htmlspecialchars($section['name']); ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="form-group col-md-4 align-self-end">
                    <button type="submit" class="btn btn-primary">Load Students</button>
                </div>
            </div>
        </form>
    </div>
</div>

<?php if ($selected_class_id > 0 && $selected_section_id > 0): ?>
    <div class="card">
        <div class="card-header">
            Students in Class <?php echo htmlspecialchars($classes[$selected_class_id] ?? 'N/A'); ?> - Section <?php echo htmlspecialchars($sections[$selected_section_id] ?? 'N/A'); ?>
            (<?php echo count($students); ?> Active Students)
        </div>
        <div class="card-body">
            <?php if (count($students) > 0): ?>
                <table class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th>Roll No.</th>
                            <th>Student Name</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($students as $student): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($student['roll_no']); ?></td> 
                            <td><?php echo htmlspecialchars($student['full_name']); ?></td>
                            <td>
                                <a href="student_leaving_confirm.php?student_id=<?php echo $student['id']; ?>&name=<?php echo urlencode($student['full_name']); ?>&roll=<?php echo urlencode($student['roll_no']); ?>" 
                                   class="btn btn-danger btn-sm">
                                    School Leave
                                </a>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            <?php else: ?>
                <div class="alert alert-info">
                    No active students found in this Class/Section for current academic session.
                    <br><small>Check if students are enrolled in current session.</small>
                </div>
            <?php endif; ?>
        </div>
    </div>
<?php endif; ?>

<?php include_once('includes/footer.php'); ?>