<?php
// student_leaving_process.php
// Final code for processing the withdrawal

session_start();

// DB connection file (path is relative to student_leaving_process.php which is in admin/)
// Is file mein sirf ek baar getDBConnection() function define hona chahiye.
include_once('../config/db.php'); 

// Redirect function is file mein hi define hogi
function redirect($page, $message, $type = 'success') {
    $param = ($type === 'success') ? 'msg' : 'err';
    // Redirect hamesha same folder ki file par hoga
    header('Location: ' . $page . '?' . $param . '=' . urlencode($message)); 
    exit;
}

$conn = getDBConnection(); // Yahan function use ho raha hai
if (!$conn) {
    redirect('student_leaving.php', 'Database connection failed!', 'err');
}

$action = $_POST['action'] ?? '';
$student_id = (int)($_POST['student_id'] ?? 0);

if ($action === 'leave_student' && $_SERVER['REQUEST_METHOD'] === 'POST') {
    
    $fees_cleared = (int)($_POST['fees_cleared'] ?? 0);
    $reason = trim($_POST['reason'] ?? '');
    
    if ($student_id <= 0 || empty($reason)) {
        redirect('student_leaving.php', 'Invalid request parameters or Reason is empty.', 'err');
    }
    
    // --- Security Re-check fees ---
    // (Fees check logic yahan assume kiya gaya hai)
    $check_fees_query = "SELECT id FROM fee_invoices WHERE student_id = ? AND (status = 'unpaid' OR status = 'partial') AND due_date <= CURDATE()";
    $stmt_check = $conn->prepare($check_fees_query);
    $stmt_check->bind_param("i", $student_id);
    $stmt_check->execute();
    
    if ($stmt_check->get_result()->num_rows > 0) {
        $stmt_check->close();
        redirect('student_leaving_confirm.php', 'Fees pending, please clear first.', 'err');
    }
    $stmt_check->close();
    
    // --- Student Status Update ---
    $leaving_date = date('Y-m-d');
    $user_id = $_SESSION['user_id'] ?? 0;
    $status = 'withdrawn'; 

    $stmt_update = $conn->prepare("
        UPDATE students 
        SET status = ?, leaving_date = ?, leaving_reason = ?, withdrawn_by_user_id = ?
        WHERE id = ?
    ");
    
    // status (s), leaving_date (s), leaving_reason (s), withdrawn_by_user_id (i), id (i)
    $stmt_update->bind_param("sssii", $status, $leaving_date, $reason, $user_id, $student_id);

    if ($stmt_update->execute()) {
        $stmt_update->close();
        // Success Message
        redirect('student_leaving.php', "Student unregistered successfully. Student ID **{$student_id}** marked as withdrawn.", 'success');
    } else {
        $stmt_update->close();
        redirect('student_leaving.php', "Error processing leaving record: " . $conn->error, 'err');
    }
} else {
    redirect('student_leaving.php', 'Invalid form submission.', 'err');
}

$conn->close();
?>