<?php
// admin/student_marks_entry.php - Individual Student Marks Entry Form (FINAL WORKING SUBJECT FIX)

session_start();
ob_start(); 
include_once('../config/db.php');
include_once('includes/header.php'); 
include_once('includes/sidebar.php'); 

$conn = getDBConnection();

$message = $_GET['msg'] ?? '';
$error = $_GET['err'] ?? '';

$exam_id = (int)($_GET['exam_id'] ?? 0);
$class_id = (int)($_GET['class_id'] ?? 0);
$student_id = (int)($_GET['student_id'] ?? 0);

if ($exam_id === 0 || $class_id === 0 || $student_id === 0) {
    // Ye check zaroori hai agar koi student_id miss ho jaaye to.
    header("Location: marks_entry.php?err=" . urlencode("Invalid parameters provided."));
    exit;
}

// --- 1. Fetch Student, Exam, Class Details ---
$details = [];
$details_stmt = $conn->prepare("
    SELECT 
        s.first_name, s.last_name, en.roll_no, 
        e.name as exam_name, 
        ac.name as class_name 
    FROM students s
    JOIN student_enrollments en ON s.id = en.student_id
    JOIN exams e ON e.id = ?
    JOIN academic_classes ac ON ac.id = ?
    WHERE s.id = ?
");
$details_stmt->bind_param("iii", $exam_id, $class_id, $student_id);
$details_stmt->execute();
$details = $details_stmt->get_result()->fetch_assoc();
$details_stmt->close();

if (!$details) {
    header("Location: marks_entry.php?err=" . urlencode("Student/Exam/Class not found."));
    exit;
}


// --- 2. Fetch Subject Structure (Max/Passing Marks) and Existing Marks ---
$subjects_data = [];
$subjects_query = "
    SELECT 
        acs.id AS subject_id, acs.name AS subject_name,
        ces.total_marks, ces.passing_marks,
        em.marks_obtained, em.is_absent, 
        CASE 
            WHEN em.is_absent = 1 THEN 'Absent'
            WHEN ces.total_marks IS NULL OR ces.total_marks = 0 THEN 'N/A'
            WHEN em.marks_obtained IS NULL THEN 'Pending'
            WHEN em.marks_obtained >= ces.passing_marks THEN 'Pass'
            ELSE 'Fail' 
        END AS initial_status
    FROM subjects acs 
    
    /* FIX: course_allocation (ca) se subjects uthao jo is class ko assigned hain (Jaisa exam_structure.php mein hota hai) */
    INNER JOIN course_allocation ca ON ca.subject_id = acs.id
    
    /* Max Marks structure (ces) ko LEFT JOIN rakha taaki agar marks set na hon tab bhi subject list mein rahe */
    LEFT JOIN class_exam_structure ces 
        ON ces.subject_id = acs.id AND ces.exam_id = ? AND ces.class_id = ?
    
    /* Existing Marks (em) */
    LEFT JOIN exam_marks em 
        ON em.subject_id = acs.id AND em.student_id = ? AND em.exam_id = ? AND em.class_id = ?

    /* Filter: SIRF WOH SUBJECTS DEKHAO JO ca.class_id (yaani selected class) ko assigned hain */
    WHERE ca.class_id = ? 
    ORDER BY acs.name ASC
";

$subjects_stmt = $conn->prepare($subjects_query);
// Binding: exam_id, class_id, student_id, exam_id, class_id, class_id (Total 6 parameters)
$subjects_stmt->bind_param("iiiiii", $exam_id, $class_id, $student_id, $exam_id, $class_id, $class_id);
$subjects_stmt->execute();
$subjects_data = $subjects_stmt->get_result()->fetch_all(MYSQLI_ASSOC);
$subjects_stmt->close();


$conn->close(); 
?>

<h1 class="mb-4">Marks Entry: Individual Student <i class="fas fa-user-edit"></i></h1>

<?php if ($message): ?>
    <div class="alert alert-success"><?php echo htmlspecialchars($message); ?></div>
<?php endif; ?>
<?php if ($error): ?>
    <div class="alert alert-danger"><?php echo htmlspecialchars($error); ?></div>
<?php endif; ?>

<div class="card p-3 mb-4 shadow-sm">
    <h5 class="card-title">Student Details:</h5>
    <p>**Exam:** <?php echo htmlspecialchars($details['exam_name']); ?></p>
    <p>**Class:** <?php echo htmlspecialchars($details['class_name']); ?></p>
    <p>**Student:** <?php echo htmlspecialchars($details['first_name'] . ' ' . $details['last_name']); ?> (Roll No: <?php echo htmlspecialchars($details['roll_no']); ?>)</p>
</div>

<form method="POST" action="student_marks_process.php">
    <input type="hidden" name="action" value="save_student_marks_batch">
    <input type="hidden" name="exam_id" value="<?php echo $exam_id; ?>">
    <input type="hidden" name="class_id" value="<?php echo $class_id; ?>">
    <input type="hidden" name="student_id" value="<?php echo $student_id; ?>">
    <input type="hidden" name="session_id" value="1"> 
    
    <div class="table-responsive">
        <table class="table table-bordered table-striped table-hover table-sm">
            <thead class="thead-dark">
                <tr>
                    <th>Subject</th>
                    <th>Max Marks</th>
                    <th>Passing Marks</th>
                    <th>Marks Obtained</th>
                    <th>Absent</th>
                    <th>Status</th>
                </tr>
            </thead>
            <tbody>
                <?php $total_marks_obtained = 0; $total_max_marks = 0; ?>
                <?php if (empty($subjects_data)): ?>
                    <tr>
                        <td colspan="6" class="text-center text-danger font-weight-bold">
                            Warning: Is Class (<?php echo htmlspecialchars($details['class_name']); ?>) ko koi subject **assign nahi** kiya gaya hai.
                        </td>
                    </tr>
                <?php else: ?>
                    <?php foreach ($subjects_data as $subject): 
                        $max_marks = (int)$subject['total_marks'];
                        $passing_marks = (int)$subject['passing_marks'];
                        $marks_obtained = $subject['marks_obtained'] !== NULL ? $subject['marks_obtained'] : '';
                        $is_absent = (int)$subject['is_absent'];
                        $status = $subject['initial_status'];

                        // Calculate Summary
                        if ($max_marks > 0) {
                            $total_max_marks += $max_marks;
                            if (!$is_absent) {
                                $total_marks_obtained += (float)$marks_obtained; 
                            }
                        }
                        
                        // Determine status color
                        $status_class = '';
                        if ($status == 'Pass') {
                            $status_class = 'badge-success';
                        } elseif ($status == 'Fail') {
                            $status_class = 'badge-danger';
                        } elseif ($status == 'Absent') {
                            $status_class = 'badge-warning';
                        } else {
                            $status_class = 'badge-secondary';
                        }
                    ?>
                    <tr>
                        <td><?php echo htmlspecialchars($subject['subject_name']); ?></td>
                        <td><?php echo $max_marks > 0 ? $max_marks : 'N/A'; ?></td>
                        <td><?php echo $passing_marks > 0 ? $passing_marks : 'N/A'; ?></td>
                        
                        <td>
                            <?php if ($max_marks > 0): ?>
                                <input type="number" step="0.01" min="0" max="<?php echo $max_marks; ?>" 
                                    name="subjects[<?php echo $subject['subject_id']; ?>][marks]" 
                                    class="form-control form-control-sm marks-input"
                                    value="<?php echo htmlspecialchars($marks_obtained); ?>"
                                    data-subject-id="<?php echo $subject['subject_id']; ?>"
                                    <?php echo $is_absent ? 'disabled' : ''; ?> 
                                    style="width: 100px;">
                            <?php else: ?>
                                <span class="text-danger small">Define Max Marks</span>
                            <?php endif; ?>
                        </td>
                        
                        <td>
                            <input type="checkbox" 
                                    name="subjects[<?php echo $subject['subject_id']; ?>][absent]" 
                                    value="1" 
                                    class="absent-checkbox"
                                    data-subject-id="<?php echo $subject['subject_id']; ?>"
                                    <?php echo $is_absent ? 'checked' : ''; ?>>
                        </td>
                        
                        <td>
                            <span class="badge <?php echo $status_class; ?> status-badge-<?php echo $subject['subject_id']; ?>">
                                <?php echo htmlspecialchars($status); ?>
                            </span>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <div class="mt-4">
        <button type="submit" class="btn btn-success" id="save-marks-btn"><i class="fas fa-save"></i> Save All Subject Marks</button>
        <a href="marks_entry.php?exam_id=<?php echo $exam_id; ?>&class_id=<?php echo $class_id; ?>" class="btn btn-secondary">Back to Student List</a>
    </div>

</form>

<div class="card p-3 mt-4">
    <h6>Result Summary:</h6>
    <p>**Total Marks Obtained:** <?php echo $total_marks_obtained; ?> / <?php echo $total_max_marks; ?></p>
</div>

<script>
$(document).ready(function() {
    // Function to toggle marks input based on absent checkbox
    function toggleMarksInput(checkbox) {
        let subjectId = $(checkbox).data('subject-id');
        let marksInput = $('input[name="subjects[' + subjectId + '][marks]"]');
        
        if ($(checkbox).is(':checked')) {
            // Absent is checked
            marksInput.val(''); // Clear the marks
            marksInput.prop('disabled', true); // Disable the field
            marksInput.prop('required', false); // Remove required attribute
        } else {
            // Absent is unchecked
            marksInput.prop('disabled', false); // Enable the field
        }
    }

    // 1. On page load, apply the rule to all checkboxes
    $('.absent-checkbox').each(function() {
        toggleMarksInput(this);
    });

    // 2. On checkbox change, apply the rule
    $('.absent-checkbox').on('change', function() {
        toggleMarksInput(this);
    });
});
</script>

<?php
include_once('includes/footer.php'); 
ob_end_flush();
?>