<?php
// admin/student_profile.php - FINAL WORKING CODE (Blank Data & Header Fix)

// =========================================================
// 1. FIX: Output Buffering for Header Error
// =========================================================
ob_start(); 

session_start();
include_once('../config/db.php');
include_once('includes/header.php');

$conn = getDBConnection();
$student_id = $_GET['id'] ?? null;
$message = $_GET['msg'] ?? '';

// Check if form was submitted for update
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['update_student'])) {
    
    // ----------------------------------------------------
    // A. Personal Details Update
    // ----------------------------------------------------
    $first_name = $_POST['first_name'];
    $last_name = $_POST['last_name'];
    $father_name = $_POST['father_name'];
    $dob = $_POST['dob'];
    $phone = $_POST['phone'];
    $address = $_POST['address'];
    $status = $_POST['status'];

    $stmt = $conn->prepare("UPDATE students SET first_name=?, last_name=?, father_name=?, dob=?, phone=?, address=?, status=? WHERE id=?");
    $stmt->bind_param("sssssssi", $first_name, $last_name, $father_name, $dob, $phone, $address, $status, $student_id);
    $stmt->execute();
    $stmt->close();

    // ----------------------------------------------------
    // B. Enrollment Details Update (student_enrollments table)
    // ----------------------------------------------------
    $session_id = $_POST['session_id']; 
    $class_id = $_POST['class_id'];
    $section_id = $_POST['section_id'] ?? 0;
    $roll_no = $_POST['roll_no'] ?? null;
    $enrollment_status = 'active'; 

    $enroll_stmt = $conn->prepare("UPDATE student_enrollments SET class_id=?, section_id=?, roll_no=?, status=? WHERE student_id=? AND session_id=?");
    $enroll_stmt->bind_param("iisisi", $class_id, $section_id, $roll_no, $enrollment_status, $student_id, $session_id);
    $enroll_stmt->execute();
    $enroll_stmt->close();


    // ----------------------------------------------------
    // FIX: Connection close nahi kiya gaya taake redirection ke baad dobara data fetch ho sake.
    // ----------------------------------------------------
    header("Location: student_profile.php?id=" . $student_id . "&msg=Student+record+successfully+updated");
    exit(); 
}


// ----------------------------------------------------
// Data Fetching for Display (Yeh section update ke baad data ko dobara load karega)
// ----------------------------------------------------

// Student Personal Details
$student_result = $conn->query("SELECT * FROM students WHERE id=" . (int)$student_id);
$student = $student_result->fetch_assoc();

// Student Current Enrollment Details
$enrollment_result = $conn->query("SELECT * FROM student_enrollments WHERE student_id=" . (int)$student_id . " ORDER BY id DESC LIMIT 1");
$enrollment = $enrollment_result->fetch_assoc();

// Classes, Sections, Sessions for Dropdowns
$classes_result = $conn->query("SELECT id, name FROM academic_classes ORDER BY order_no ASC");
$classes = $classes_result->fetch_all(MYSQLI_ASSOC);

$sections_result = $conn->query("SELECT id, name FROM academic_sections ORDER BY name ASC");
$sections = $sections_result->fetch_all(MYSQLI_ASSOC);

$sessions_result = $conn->query("SELECT id, name FROM academic_sessions ORDER BY id DESC");
$sessions = $sessions_result->fetch_all(MYSQLI_ASSOC);


// Get current active session ID
$current_session_id = $enrollment['session_id'] ?? 1;


/*
// 'Student not found' message ko comment kar diya gaya hai. 
// Agar data display ho raha hai to iski zaroorat nahi hai.
if (!$student) {
    echo "<div class='alert alert-danger'>Student not found.</div>";
    include_once('includes/footer.php');
    exit();
}
*/
?>

<h1 class="mb-4">Update Student Information <i class="fas fa-user-edit"></i></h1>

<?php if ($message): ?>
    <div class="alert alert-success"><?php echo htmlspecialchars(str_replace('+', ' ', $message)); ?></div>
<?php endif; ?>


<form action="student_profile.php?id=<?php echo $student_id; ?>" method="POST">
    <input type="hidden" name="update_student" value="1">
    <input type="hidden" name="session_id" value="<?php echo $current_session_id; ?>"> 

    <div class="card p-4 mb-4">
        <h3 class="card-title">A. Personal Details</h3>
        <div class="form-row">
            <div class="form-group col-md-3">
                <label>First Name:</label>
                <input type="text" name="first_name" class="form-control" value="<?php echo htmlspecialchars($student['first_name'] ?? ''); ?>" required>
            </div>
            <div class="form-group col-md-3">
                <label>Last Name:</label>
                <input type="text" name="last_name" class="form-control" value="<?php echo htmlspecialchars($student['last_name'] ?? ''); ?>">
            </div>
            <div class="form-group col-md-3">
                <label>Father Name:</label>
                <input type="text" name="father_name" class="form-control" value="<?php echo htmlspecialchars($student['father_name'] ?? ''); ?>" required>
            </div>
            <div class="form-group col-md-3">
                <label>Date of Birth:</label>
                <input type="date" name="dob" class="form-control" value="<?php echo htmlspecialchars($student['dob'] ?? ''); ?>">
            </div>
            <div class="form-group col-md-3">
                <label>Phone No:</label>
                <input type="text" name="phone" class="form-control" value="<?php echo htmlspecialchars($student['phone'] ?? ''); ?>">
            </div>
            <div class="form-group col-md-3">
                <label>Status:</label>
                <select name="status" class="form-control">
                    <option value="active" <?php echo (($student['status'] ?? '') == 'active' ? 'selected' : ''); ?>>Active</option>
                    <option value="inactive" <?php echo (($student['status'] ?? '') == 'inactive' ? 'selected' : ''); ?>>Inactive</option>
                </select>
            </div>
             <div class="form-group col-md-6">
                <label>Address:</label>
                <textarea name="address" class="form-control" rows="1"><?php echo htmlspecialchars($student['address'] ?? ''); ?></textarea>
            </div>
        </div>
    </div>
    
    <div class="card p-4 mb-4">
        <h3 class="card-title">B. Current Enrollment Details (Session ID: <?php echo $current_session_id; ?>)</h3>
        <p class="text-danger">**Voucher Fix** Fees Voucher generate karne ke liye, student ka Enrollment **Active Session ID (<?php echo $current_session_id; ?>)** mein hona zaroori hai. Neeche Enrollment Session aur Class theek karein.</p>
        <div class="form-row">
            <div class="form-group col-md-4">
                <label>Enrollment Session:</label>
                <select name="enrollment_session_id" class="form-control" disabled>
                    <?php foreach ($sessions as $session): ?>
                        <option value="<?php echo $session['id']; ?>" <?php echo ($session['id'] == $current_session_id ? 'selected' : ''); ?>>
                            <?php echo htmlspecialchars($session['name']); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
                <small class="form-text text-muted">Active Session hi use kiya ja raha hai.</small>
            </div>

            <div class="form-group col-md-4">
                <label>Enrollment Class:</label>
                <select name="class_id" class="form-control" required>
                    <option value="">Select Class</option>
                    <?php foreach ($classes as $class): ?>
                        <option value="<?php echo $class['id']; ?>" <?php echo (($enrollment['class_id'] ?? '') == $class['id'] ? 'selected' : ''); ?>>
                            <?php echo htmlspecialchars($class['name']); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
             <div class="form-group col-md-4">
                <label>Enrollment Section:</label>
                <select name="section_id" class="form-control">
                    <option value="0">No Section</option>
                    <?php foreach ($sections as $section): ?>
                        <option value="<?php echo $section['id']; ?>" <?php echo (($enrollment['section_id'] ?? '') == $section['id'] ? 'selected' : ''); ?>>
                            <?php echo htmlspecialchars($section['name']); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            
            <div class="form-group col-md-4">
                <label>Roll No (Optional):</label>
                <input type="text" name="roll_no" class="form-control" value="<?php echo htmlspecialchars($enrollment['roll_no'] ?? ''); ?>">
            </div>
            
        </div>
    </div>

    <button type="submit" class="btn btn-primary btn-lg"><i class="fas fa-save"></i> Save All Changes</button>
    <a href="students.php" class="btn btn-secondary">Cancel</a>
</form>

<?php
// Connection close karne ka amal file ke aakhir mein hi theek hai.
$conn->close();
include_once('includes/footer.php');
?>