<?php
// admin/students.php (Complete List View with Actions)
session_start();
// Zaroori files shamil karein
include_once('includes/header.php'); 
include_once('includes/sidebar.php'); 
// Database connection shamil karein
$conn = getDBConnection();

$message = $_GET['msg'] ?? '';
$error = $_GET['err'] ?? '';

// --- Data Fetching ---
// $settings variable header.php se available hoga.
$current_session_id = $settings['academic.active_session_id'];

// Classes aur sections fetch karein for dropdowns - specific order me
$classes_query = "SELECT id, name FROM academic_classes ORDER BY 
                  CASE 
                    WHEN name LIKE '%Play Group%' THEN 1
                    WHEN name LIKE '%Nursery%' THEN 2  
                    WHEN name LIKE '%Prep%' THEN 3
                    WHEN name LIKE '%One%' THEN 4
                    WHEN name LIKE '%Two%' THEN 5
                    WHEN name LIKE '%Three%' THEN 6
                    WHEN name LIKE '%Four%' THEN 7
                    WHEN name LIKE '%Five%' THEN 8
                    WHEN name LIKE '%Six%' THEN 9
                    WHEN name LIKE '%Seven%' THEN 10
                    WHEN name LIKE '%Eight%' THEN 11
                    WHEN name LIKE '%Nine%' THEN 12
                    WHEN name LIKE '%Ten%' THEN 13
                    ELSE 14
                  END ASC, order_no ASC";
$classes_result = $conn->query($classes_query);
$classes = $classes_result->fetch_all(MYSQLI_ASSOC);

// Search parameters
$search_class = $_GET['class'] ?? '';
$search_section = $_GET['section'] ?? '';
$search_name = $_GET['name'] ?? '';

// Base query - academic_sections table use karein
$students_query = "
    SELECT 
        s.id, s.first_name, s.last_name, s.father_name, s.status, s.admission_date,
        en.roll_no, 
        ac.name as class_name,
        asec.name as section_name,
        en.class_id,
        en.section_id
    FROM students s
    LEFT JOIN student_enrollments en ON s.id = en.student_id AND en.session_id = {$current_session_id}
    LEFT JOIN academic_classes ac ON en.class_id = ac.id
    LEFT JOIN academic_sections asec ON en.section_id = asec.id
    WHERE 1=1
";

// Search filters apply karein
if (!empty($search_class)) {
    $students_query .= " AND en.class_id = " . intval($search_class);
}

if (!empty($search_section)) {
    $students_query .= " AND en.section_id = " . intval($search_section);
}

if (!empty($search_name)) {
    $students_query .= " AND (s.first_name LIKE '%" . $conn->real_escape_string($search_name) . "%' 
                          OR s.last_name LIKE '%" . $conn->real_escape_string($search_name) . "%'
                          OR CONCAT(s.first_name, ' ', s.last_name) LIKE '%" . $conn->real_escape_string($search_name) . "%')";
}

$students_query .= " ORDER BY 
    CASE 
        WHEN ac.name LIKE '%Play Group%' THEN 1
        WHEN ac.name LIKE '%Nursery%' THEN 2  
        WHEN ac.name LIKE '%Prep%' THEN 3
        WHEN ac.name LIKE '%One%' THEN 4
        WHEN ac.name LIKE '%Two%' THEN 5
        WHEN ac.name LIKE '%Three%' THEN 6
        WHEN ac.name LIKE '%Four%' THEN 7
        WHEN ac.name LIKE '%Five%' THEN 8
        WHEN ac.name LIKE '%Six%' THEN 9
        WHEN ac.name LIKE '%Seven%' THEN 10
        WHEN ac.name LIKE '%Eight%' THEN 11
        WHEN ac.name LIKE '%Nine%' THEN 12
        WHEN ac.name LIKE '%Ten%' THEN 13
        ELSE 14
    END ASC, 
    ac.order_no ASC, en.roll_no ASC, s.id DESC";

$students_result = $conn->query($students_query);
$students = $students_result->fetch_all(MYSQLI_ASSOC);

// Sections fetch karein - academic_sections table se
$sections_query = "SELECT id, name FROM academic_sections WHERE status = 'active' ORDER BY name ASC";
$sections_result = $conn->query($sections_query);
$sections = $sections_result->fetch_all(MYSQLI_ASSOC);

// Naya query for class-section summary
$class_section_query = "
    SELECT 
        ac.id as class_id,
        ac.name as class_name,
        asec.id as section_id, 
        asec.name as section_name,
        COUNT(en.student_id) as student_count
    FROM academic_classes ac
    CROSS JOIN academic_sections asec
    LEFT JOIN student_enrollments en ON ac.id = en.class_id AND asec.id = en.section_id AND en.session_id = {$current_session_id}
    WHERE asec.status = 'active'
    GROUP BY ac.id, ac.name, asec.id, asec.name
    ORDER BY 
        CASE 
            WHEN ac.name LIKE '%Play Group%' THEN 1
            WHEN ac.name LIKE '%Nursery%' THEN 2  
            WHEN ac.name LIKE '%Prep%' THEN 3
            WHEN ac.name LIKE '%One%' THEN 4
            WHEN ac.name LIKE '%Two%' THEN 5
            WHEN ac.name LIKE '%Three%' THEN 6
            WHEN ac.name LIKE '%Four%' THEN 7
            WHEN ac.name LIKE '%Five%' THEN 8
            WHEN ac.name LIKE '%Six%' THEN 9
            WHEN ac.name LIKE '%Seven%' THEN 10
            WHEN ac.name LIKE '%Eight%' THEN 11
            WHEN ac.name LIKE '%Nine%' THEN 12
            WHEN ac.name LIKE '%Ten%' THEN 13
            ELSE 14
        END ASC,
        ac.order_no ASC, asec.name ASC
";

$class_section_result = $conn->query($class_section_query);
$class_sections = $class_section_result->fetch_all(MYSQLI_ASSOC);

// IMPROVED: Student fees status check karein - BOTH student_fees AND fee_invoices tables se
$student_fees_status = [];
$student_assigned_fees = [];

if (!empty($students)) {
    $student_ids = array_column($students, 'id');
    if (!empty($student_ids)) {
        $student_ids_str = implode(',', $student_ids);
        
        // 1. Pending fees check karein - fee_invoices table se (ACTUAL PENDING FEES)
        $pending_fees_query = "
            SELECT 
                student_id,
                COUNT(*) as total_invoices,
                SUM(net_payable - amount_paid) as total_pending_amount,
                SUM(CASE WHEN status = 'unpaid' OR status = 'partial' THEN 1 ELSE 0 END) as pending_count
            FROM fee_invoices 
            WHERE student_id IN ($student_ids_str) 
            AND session_id = {$current_session_id}
            GROUP BY student_id
        ";
        
        $pending_fees_result = $conn->query($pending_fees_query);
        if ($pending_fees_result) {
            while ($row = $pending_fees_result->fetch_assoc()) {
                $student_fees_status[$row['student_id']] = [
                    'total_invoices' => $row['total_invoices'],
                    'total_pending_amount' => $row['total_pending_amount'] ?? 0,
                    'pending_count' => $row['pending_count'] ?? 0,
                    'has_pending_fees' => ($row['pending_count'] ?? 0) > 0
                ];
            }
        }
        
        // 2. Assigned fees ke liye detailed query - student_fees table se
        $assigned_fees_query = "
            SELECT 
                sf.student_id,
                sf.fee_type,
                sf.amount,
                sf.month,
                sf.examination_type,
                sf.notes as fee_notes,
                sf.created_at
            FROM student_fees sf
            WHERE sf.student_id IN ($student_ids_str)
            ORDER BY sf.student_id, sf.fee_type, sf.month
        ";
        
        $assigned_fees_result = $conn->query($assigned_fees_query);
        if ($assigned_fees_result) {
            while ($row = $assigned_fees_result->fetch_assoc()) {
                $student_id = $row['student_id'];
                
                if (!isset($student_assigned_fees[$student_id])) {
                    $student_assigned_fees[$student_id] = [
                        'has_assigned_fees' => true,
                        'monthly_fee' => 0,
                        'admission_fee' => 0,
                        'examination_fee' => 0,
                        'assigned_months' => [],
                        'examination_type' => '',
                        'fee_notes' => ''
                    ];
                }
                
                // Fee type ke hisaab se amounts set karein
                switch($row['fee_type']) {
                    case 'admission':
                        $student_assigned_fees[$student_id]['admission_fee'] = $row['amount'];
                        break;
                    case 'examination':
                        $student_assigned_fees[$student_id]['examination_fee'] = $row['amount'];
                        $student_assigned_fees[$student_id]['examination_type'] = $row['examination_type'] ?? '';
                        break;
                    case 'monthly':
                        $student_assigned_fees[$student_id]['monthly_fee'] = $row['amount'];
                        if ($row['month']) {
                            $student_assigned_fees[$student_id]['assigned_months'][] = $row['month'];
                        }
                        break;
                    default:
                        // Other fee types
                        break;
                }
                
                // Notes set karein
                if ($row['fee_notes']) {
                    $student_assigned_fees[$student_id]['fee_notes'] = $row['fee_notes'];
                }
            }
            
            // Months ko comma separated string mein convert karein
            foreach ($student_assigned_fees as &$fee_data) {
                if (!empty($fee_data['assigned_months'])) {
                    $fee_data['assigned_months'] = implode(', ', array_unique($fee_data['assigned_months']));
                }
            }
        }
        
        // 3. Agar koi student ke paas assigned fees nahi hai, to unke liye empty data set karein
        foreach ($student_ids as $student_id) {
            if (!isset($student_fees_status[$student_id])) {
                $student_fees_status[$student_id] = [
                    'total_invoices' => 0,
                    'total_pending_amount' => 0,
                    'pending_count' => 0,
                    'has_pending_fees' => false
                ];
            }
            
            if (!isset($student_assigned_fees[$student_id])) {
                $student_assigned_fees[$student_id] = [
                    'has_assigned_fees' => false,
                    'monthly_fee' => 0,
                    'admission_fee' => 0,
                    'examination_fee' => 0,
                    'assigned_months' => [],
                    'examination_type' => '',
                    'fee_notes' => ''
                ];
            }
        }
    }
}

$conn->close();

// Check if we're viewing a specific class-section
$viewing_specific_class = !empty($search_class) && !empty($search_section);
?>

<!-- Professional CSS Styles -->
<style>
.page-header {
    border-bottom: 1px solid #e3e6f0;
    padding-bottom: 1rem;
    margin-bottom: 2rem;
}

.search-card {
    border: 1px solid #e3e6f0;
    border-radius: 0.5rem;
    box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.15);
}

.search-card .card-header {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    border-radius: 0.5rem 0.5rem 0 0 !important;
    padding: 1rem 1.5rem;
}

.data-table-card {
    border: 1px solid #e3e6f0;
    border-radius: 0.5rem;
    box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.15);
}

.data-table-card .card-body {
    padding: 0;
}

.table th {
    background: #f8f9fc;
    color: #4e73df;
    font-weight: 700;
    border-bottom: 2px solid #e3e6f0;
    padding: 1rem 0.75rem;
    font-size: 0.85rem;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.table td {
    padding: 1rem 0.75rem;
    vertical-align: middle;
    border-color: #e3e6f0;
    font-size: 0.9rem;
}

.table-hover tbody tr:hover {
    background-color: #f8f9fc;
    transform: translateY(-1px);
    transition: all 0.2s ease;
}

.student-name-link {
    color: #4e73df;
    font-weight: 600;
    text-decoration: none;
    transition: color 0.2s ease;
}

.student-name-link:hover {
    color: #2e59d9;
    text-decoration: underline;
}

.badge {
    font-size: 0.75rem;
    font-weight: 600;
    padding: 0.35rem 0.65rem;
    border-radius: 0.35rem;
}

.btn-action {
    border-radius: 0.35rem;
    padding: 0.375rem 0.75rem;
    font-size: 0.8rem;
    margin: 0 2px;
    transition: all 0.2s ease;
}

.btn-action:hover {
    transform: translateY(-1px);
    box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.1);
}

.empty-state {
    padding: 3rem 1rem;
    text-align: center;
    color: #6c757d;
}

.empty-state i {
    font-size: 3rem;
    margin-bottom: 1rem;
    color: #dddfeb;
}

.filter-badge {
    background: #f8f9fc;
    border: 1px solid #e3e6f0;
    border-radius: 0.35rem;
    padding: 0.5rem 1rem;
    font-size: 0.85rem;
}

.form-control, .form-select {
    border: 1px solid #d1d3e2;
    border-radius: 0.35rem;
    padding: 0.75rem 1rem;
    font-size: 0.9rem;
    transition: border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out;
}

.form-control:focus, .form-select:focus {
    border-color: #4e73df;
    box-shadow: 0 0 0 0.2rem rgba(78, 115, 223, 0.25);
}

.btn-primary {
    background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);
    border: none;
    border-radius: 0.35rem;
    padding: 0.75rem 1.5rem;
    font-weight: 600;
    transition: all 0.2s ease;
}

.btn-primary:hover {
    transform: translateY(-1px);
    box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
}

.btn-outline-secondary {
    border: 1px solid #6c757d;
    color: #6c757d;
    border-radius: 0.35rem;
    padding: 0.75rem 1.5rem;
    font-weight: 600;
    transition: all 0.2s ease;
}

.btn-outline-secondary:hover {
    background-color: #6c757d;
    color: white;
    transform: translateY(-1px);
}

.status-active {
    background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%);
}

.status-inactive {
    background: linear-gradient(135deg, #f6c23e 0%, #dda20a 100%);
}

.status-withdrawn {
    background: linear-gradient(135deg, #e74a3b 0%, #be2617 100%);
}

.status-secondary {
    background: linear-gradient(135deg, #858796 0%, #60616f 100%);
}

.enrollment-count {
    font-size: 1.1rem;
    font-weight: 700;
    color: #2e59d9;
}

.back-button {
    margin-bottom: 1rem;
}

/* Naye buttons ke liye styles */
.btn-promote {
    background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%);
    border: none;
    color: white;
}

.btn-demote {
    background: linear-gradient(135deg, #f6c23e 0%, #dda20a 100%);
    border: none;
    color: white;
}

.btn-retain {
    background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);
    border: none;
    color: white;
}

/* Fee Assignment Button */
.btn-fee {
    background: linear-gradient(135deg, #36b9cc 0%, #258391 100%);
    border: none;
    color: white;
}

/* Student Count Badge - FIXED WHITE TEXT */
.student-count-badge {
    background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);
    color: white !important;
    font-size: 0.8rem;
    font-weight: 600;
    padding: 0.4rem 0.8rem;
    border-radius: 1rem;
    margin-left: 0.5rem;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

/* Header styles for better appearance */
.card-header {
    background: linear-gradient(135deg, #f8f9fc 0%, #e3e6f0 100%);
    border-bottom: 1px solid #e3e6f0;
}

/* Professional table enhancements */
.table-responsive {
    border-radius: 0.5rem;
}

.table > :not(caption) > * > * {
    padding: 1rem 0.75rem;
}

/* Action buttons group styling */
.btn-group .btn-action {
    border-radius: 0.25rem;
    margin: 0 1px;
}

/* Hover effects for better UX */
.card {
    transition: transform 0.2s ease, box-shadow 0.2s ease;
}

.card:hover {
    transform: translateY(-2px);
    box-shadow: 0 0.5rem 1.5rem rgba(0, 0, 0, 0.1);
}

/* Status badges improvements */
.badge {
    font-size: 0.7rem;
    padding: 0.4rem 0.7rem;
}

/* Professional color scheme */
:root {
    --primary: #4e73df;
    --success: #1cc88a;
    --warning: #f6c23e;
    --danger: #e74a3b;
    --info: #36b9cc;
}

/* Button group spacing */
.btn-group {
    gap: 2px;
}

/* Modal Styles */
.modal-header {
    background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);
    color: white;
}

.fee-type-section {
    border: 1px solid #e3e6f0;
    border-radius: 0.5rem;
    padding: 1rem;
    margin-bottom: 1rem;
    background: #f8f9fc;
}

.fee-type-section h6 {
    color: #4e73df;
    margin-bottom: 1rem;
    padding-bottom: 0.5rem;
    border-bottom: 1px solid #e3e6f0;
}

.month-checkboxes {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 0.5rem;
    margin-top: 0.5rem;
}

.month-checkbox-item {
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.month-checkbox-item input[type="checkbox"] {
    width: 1rem;
    height: 1rem;
}

/* Pending fees warning style */
.pending-fees-warning {
    background: linear-gradient(135deg, #e74a3b 0%, #be2617 100%) !important;
    color: white !important;
}

.pending-fees-warning:hover {
    background: linear-gradient(135deg, #be2617 0%, #9c1c10 100%) !important;
    transform: none !important;
    cursor: not-allowed !important;
}

/* Fee status badges */
.fee-status-badge {
    font-size: 0.7rem;
    padding: 0.3rem 0.6rem;
    border-radius: 0.25rem;
}

.fee-pending {
    background: linear-gradient(135deg, #e74a3b 0%, #be2617 100%);
    color: white;
}

.fee-paid {
    background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%);
    color: white;
}

.fee-partial {
    background: linear-gradient(135deg, #f6c23e 0%, #dda20a 100%);
    color: white;
}

.fee-not-assigned-badge {
    background: linear-gradient(135deg, #6c757d 0%, #495057 100%);
    color: white;
}

/* Locked input fields */
.locked-field {
    background-color: #f8f9fc !important;
    border-color: #d1d3e2 !important;
    color: #6c757d !important;
    cursor: not-allowed !important;
}

.locked-field:focus {
    box-shadow: none !important;
    border-color: #d1d3e2 !important;
}

/* Fee status display */
.fee-status-display {
    font-size: 0.85rem;
    padding: 0.5rem;
    border-radius: 0.35rem;
    margin-top: 0.5rem;
}

.fee-assigned {
    background: #e8f5e8;
    color: #2e7d32;
    border: 1px solid #c8e6c9;
}

.fee-not-assigned {
    background: #fff3e0;
    color: #ef6c00;
    border: 1px solid #ffe0b2;
}

/* Fee summary card */
.fee-summary-card {
    background: linear-gradient(135deg, #f8f9fc 0%, #e3e6f0 100%);
    border: 1px solid #e3e6f0;
    border-radius: 0.5rem;
    padding: 1rem;
    margin-bottom: 1rem;
}

.fee-summary-item {
    display: flex;
    justify-content: between;
    align-items: center;
    padding: 0.5rem 0;
    border-bottom: 1px solid #e3e6f0;
}

.fee-summary-item:last-child {
    border-bottom: none;
}

/* Disabled buttons styling */
.btn-disabled {
    opacity: 0.6;
    cursor: not-allowed !important;
}

.btn-disabled:hover {
    transform: none !important;
    box-shadow: none !important;
}
</style>

<!-- Fee Assignment Modal -->
<div class="modal fade" id="feeAssignmentModal" tabindex="-1" aria-labelledby="feeAssignmentModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="feeAssignmentModalLabel">
                    <i class="fas fa-money-bill-wave me-2"></i>
                    Student Fee Assignment
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="feeAssignmentForm" action="students_process.php" method="POST">
                <div class="modal-body">
                    <input type="hidden" name="action" value="assign_fees">
                    <input type="hidden" name="student_id" id="student_id">
                    
                    <!-- Student Information -->
                    <div class="row mb-4">
                        <div class="col-md-6">
                            <label class="form-label fw-semibold">Student Name</label>
                            <p class="form-control-plaintext" id="student_name_display"></p>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label fw-semibold">Class & Section</label>
                            <p class="form-control-plaintext" id="student_class_display"></p>
                        </div>
                    </div>

                    <!-- Fee Status Summary -->
                    <div class="fee-summary-card" id="feeSummarySection">
                        <h6 class="fw-semibold text-primary mb-3">
                            <i class="fas fa-chart-bar me-2"></i>Current Fee Status
                        </h6>
                        <div id="feeStatusContent">
                            <!-- Fee status yahan dynamically load hoga -->
                        </div>
                    </div>

                    <!-- Admission Fee (One-time) -->
                    <div class="fee-type-section">
                        <h6 class="fw-semibold">
                            <i class="fas fa-user-graduate me-2"></i>
                            Admission Fee (One-time)
                        </h6>
                        <div class="row">
                            <div class="col-md-6">
                                <label class="form-label">Admission Fee Amount</label>
                                <input type="number" class="form-control" name="admission_fee" id="admission_fee" min="0" step="0.01" placeholder="0.00">
                                <div class="form-text text-muted">
                                    Yeh fee sirf pehle voucher mein assign hogi
                                </div>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Admission Fee Status</label>
                                <div class="fee-status-display fee-not-assigned" id="admissionStatusDisplay">
                                    Not Assigned
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Monthly Fee -->
                    <div class="fee-type-section">
                        <h6 class="fw-semibold">
                            <i class="fas fa-calendar-alt me-2"></i>
                            Monthly Fee
                        </h6>
                        <div class="row">
                            <div class="col-md-6">
                                <label class="form-label">Monthly Fee Amount</label>
                                <input type="number" class="form-control" name="monthly_fee" id="monthly_fee" min="0" step="0.01" placeholder="0.00">
                                <div class="form-text text-muted">
                                    Yeh fee har month ke voucher mein assign hogi
                                </div>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Select Months</label>
                                <div class="month-checkboxes" id="monthsContainer">
                                    <?php
                                    $months = [
                                        'January', 'February', 'March', 'April', 'May', 'June',
                                        'July', 'August', 'September', 'October', 'November', 'December'
                                    ];
                                    foreach ($months as $month) {
                                        echo '<div class="month-checkbox-item">';
                                        echo '<input type="checkbox" name="months[]" value="' . $month . '" id="month_' . strtolower($month) . '">';
                                        echo '<label for="month_' . strtolower($month) . '">' . $month . '</label>';
                                        echo '</div>';
                                    }
                                    ?>
                                </div>
                                <button type="button" class="btn btn-sm btn-outline-primary mt-2" onclick="selectAllMonths()">Select All</button>
                                <button type="button" class="btn btn-sm btn-outline-secondary mt-2" onclick="clearAllMonths()">Clear All</button>
                            </div>
                        </div>
                    </div>

                    <!-- Examination Fee -->
                    <div class="fee-type-section">
                        <h6 class="fw-semibold">
                            <i class="fas fa-file-alt me-2"></i>
                            Examination Fee
                        </h6>
                        <div class="row">
                            <div class="col-md-6">
                                <label class="form-label">Examination Fee Amount</label>
                                <input type="number" class="form-control" name="examination_fee" id="examination_fee" min="0" step="0.01" placeholder="0.00">
                                <div class="form-text text-muted">
                                    Yeh fee selected months ke vouchers mein assign hogi
                                </div>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Examination Type</label>
                                <select class="form-select" name="examination_type" id="examination_type">
                                    <option value="mid_term">Mid Term Examination</option>
                                    <option value="final">Final Examination</option>
                                    <option value="monthly_test">Monthly Test</option>
                                    <option value="other">Annual Fee Fund</option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <!-- Additional Notes -->
                    <div class="mb-3">
                        <label for="fee_notes" class="form-label">Additional Notes</label>
                        <textarea class="form-control" id="fee_notes" name="fee_notes" rows="2" placeholder="Any additional notes about fees..."></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary" id="submitFeeBtn">
                        <i class="fas fa-save me-2"></i>Assign Fees
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
// Global variable to track if fees are already assigned
let feesAlreadyAssigned = false;
let currentStudentId = null;

// Function to open fee assignment modal
function openFeeModal(studentId, studentName, className, sectionName) {
    try {
        console.log('Opening fee modal for student:', studentId, studentName);
        
        // Set student information in modal
        currentStudentId = studentId;
        document.getElementById('student_id').value = studentId;
        document.getElementById('student_name_display').textContent = studentName;
        document.getElementById('student_class_display').textContent = className + ' - ' + sectionName;
        
        // Reset form initially
        resetFeeForm();
        
        // Load existing fee data from PHP arrays
        loadStudentFeeData(studentId);
        
        // Show modal
        var modalElement = document.getElementById('feeAssignmentModal');
        if (modalElement) {
            var modal = new bootstrap.Modal(modalElement);
            modal.show();
        } else {
            console.error('Modal element not found');
        }
    } catch (error) {
        console.error('Error opening fee modal:', error);
        alert('Error opening fee assignment modal. Please check console for details.');
    }
}

// Function to load existing fee data from PHP arrays
function loadStudentFeeData(studentId) {
    try {
        // PHP arrays se data lein
        const feeStatus = <?php echo json_encode($student_fees_status); ?>;
        const assignedFees = <?php echo json_encode($student_assigned_fees); ?>;
        
        const currentStudentFeeData = {
            has_assigned_fees: assignedFees[studentId]?.has_assigned_fees || false,
            has_pending_fees: feeStatus[studentId]?.has_pending_fees || false,
            pending_count: feeStatus[studentId]?.pending_count || 0,
            pending_amount: feeStatus[studentId]?.total_pending_amount || 0,
            monthly_fee: assignedFees[studentId]?.monthly_fee || 0,
            admission_fee: assignedFees[studentId]?.admission_fee || 0,
            examination_fee: assignedFees[studentId]?.examination_fee || 0,
            assigned_months: assignedFees[studentId]?.assigned_months || '',
            examination_type: assignedFees[studentId]?.examination_type || '',
            fee_notes: assignedFees[studentId]?.fee_notes || ''
        };
        
        displayExistingFeeData(currentStudentFeeData);
    } catch (error) {
        console.error('Error loading fee data:', error);
    }
}

// Function to display existing fee data
function displayExistingFeeData(data) {
    let summaryHTML = '';
    
    if (data.has_pending_fees) {
        summaryHTML = `
            <div class="alert alert-warning">
                <i class="fas fa-exclamation-triangle me-2"></i>
                <strong>Fees Not Paid!</strong><br>
                Total Pending: Rs. ${(data.pending_amount || 0).toLocaleString('en-PK', {minimumFractionDigits: 2})}<br>
                Pending Months: ${data.pending_count || 0}<br>
                Pehle pending fees clear karein, phir modify kar sakte hain.
            </div>
        `;
        feesAlreadyAssigned = true;
        
        // Pending fees hone par fields disable karein
        disableAllFields();
        
    } else if (data.has_assigned_fees) {
        let assignedDetails = '';
        if (data.monthly_fee > 0) {
            assignedDetails += `<strong>Monthly Fee:</strong> Rs. ${data.monthly_fee.toLocaleString('en-PK', {minimumFractionDigits: 2})}<br>`;
        }
        if (data.admission_fee > 0) {
            assignedDetails += `<strong>Admission Fee:</strong> Rs. ${data.admission_fee.toLocaleString('en-PK', {minimumFractionDigits: 2})}<br>`;
        }
        if (data.examination_fee > 0) {
            assignedDetails += `<strong>Examination Fee:</strong> Rs. ${data.examination_fee.toLocaleString('en-PK', {minimumFractionDigits: 2})}<br>`;
        }
        if (data.assigned_months) {
            assignedDetails += `<strong>Months:</strong> ${data.assigned_months}`;
        }
        
        summaryHTML = `
            <div class="alert alert-info">
                <i class="fas fa-check-circle me-2"></i>
                <strong>Fees Already Assigned</strong><br>
                ${assignedDetails || 'Fees assigned but details not available'}
            </div>
        `;
        feesAlreadyAssigned = true;
        
        // Fees assigned hone par fields disable karein
        disableAllFields();
        
    } else {
        summaryHTML = `
            <div class="alert alert-secondary">
                <i class="fas fa-info-circle me-2"></i>
                <strong>Fee Not Assigned</strong><br>
                Is student ko abhi tak koi fees assign nahi ki gayi hai.<br>
                Aap fees assign kar sakte hain.
            </div>
        `;
        feesAlreadyAssigned = false;
        
        // Fees assign nahi hone par fields enable karein
        enableAllFields();
    }
    
    document.getElementById('feeStatusContent').innerHTML = summaryHTML;
    
    // Populate form fields with existing data
    if (data.has_assigned_fees) {
        if (data.admission_fee > 0) {
            document.getElementById('admission_fee').value = data.admission_fee;
            document.getElementById('admissionStatusDisplay').textContent = 'Assigned: Rs. ' + data.admission_fee.toLocaleString('en-PK', {minimumFractionDigits: 2});
            document.getElementById('admissionStatusDisplay').className = 'fee-status-display fee-assigned';
        }
        
        if (data.monthly_fee > 0) {
            document.getElementById('monthly_fee').value = data.monthly_fee;
        }
        
        if (data.examination_fee > 0) {
            document.getElementById('examination_fee').value = data.examination_fee;
        }
        
        if (data.examination_type) {
            document.getElementById('examination_type').value = data.examination_type;
        }
        
        if (data.fee_notes) {
            document.getElementById('fee_notes').value = data.fee_notes;
        }
        
        // Check assigned months
        if (data.assigned_months) {
            const months = data.assigned_months.split(',');
            months.forEach(month => {
                const monthTrimmed = month.trim();
                if (monthTrimmed) {
                    const checkbox = document.getElementById('month_' + monthTrimmed.toLowerCase());
                    if (checkbox) {
                        checkbox.checked = true;
                    }
                }
            });
        }
    }
}

// Function to disable all form fields
function disableAllFields() {
    document.getElementById('admission_fee').disabled = true;
    document.getElementById('monthly_fee').disabled = true;
    document.getElementById('examination_fee').disabled = true;
    document.getElementById('examination_type').disabled = true;
    document.getElementById('fee_notes').disabled = true;
    
    // Disable all month checkboxes
    const checkboxes = document.querySelectorAll('input[name="months[]"]');
    checkboxes.forEach(checkbox => {
        checkbox.disabled = true;
    });
    
    // Disable select all/clear all buttons
    const selectAllBtn = document.querySelector('button[onclick="selectAllMonths()"]');
    const clearAllBtn = document.querySelector('button[onclick="clearAllMonths()"]');
    if (selectAllBtn) selectAllBtn.disabled = true;
    if (clearAllBtn) clearAllBtn.disabled = true;
    
    // Disable submit button
    const submitBtn = document.getElementById('submitFeeBtn');
    if (submitBtn) {
        submitBtn.disabled = true;
        submitBtn.innerHTML = '<i class="fas fa-lock me-2"></i>Fees Already Assigned';
        submitBtn.className = 'btn btn-secondary';
    }
}

// Function to enable all form fields
function enableAllFields() {
    document.getElementById('admission_fee').disabled = false;
    document.getElementById('monthly_fee').disabled = false;
    document.getElementById('examination_fee').disabled = false;
    document.getElementById('examination_type').disabled = false;
    document.getElementById('fee_notes').disabled = false;
    
    // Enable all month checkboxes
    const checkboxes = document.querySelectorAll('input[name="months[]"]');
    checkboxes.forEach(checkbox => {
        checkbox.disabled = false;
    });
    
    // Enable select all/clear all buttons
    const selectAllBtn = document.querySelector('button[onclick="selectAllMonths()"]');
    const clearAllBtn = document.querySelector('button[onclick="clearAllMonths()"]');
    if (selectAllBtn) selectAllBtn.disabled = false;
    if (clearAllBtn) clearAllBtn.disabled = false;
    
    // Enable submit button
    const submitBtn = document.getElementById('submitFeeBtn');
    if (submitBtn) {
        submitBtn.disabled = false;
        submitBtn.innerHTML = '<i class="fas fa-save me-2"></i>Assign Fees';
        submitBtn.className = 'btn btn-primary';
    }
}

// Function to reset fee form
function resetFeeForm() {
    feesAlreadyAssigned = false;
    
    // Reset all checkboxes
    const checkboxes = document.querySelectorAll('input[name="months[]"]');
    checkboxes.forEach(checkbox => {
        checkbox.checked = false;
    });
    
    // Reset form values
    document.getElementById('admission_fee').value = '';
    document.getElementById('monthly_fee').value = '';
    document.getElementById('examination_fee').value = '';
    document.getElementById('examination_type').value = 'mid_term';
    document.getElementById('fee_notes').value = '';
    
    // Reset admission status
    document.getElementById('admissionStatusDisplay').textContent = 'Not Assigned';
    document.getElementById('admissionStatusDisplay').className = 'fee-status-display fee-not-assigned';
    
    // Enable all fields by default
    enableAllFields();
}

// Function to select all months
function selectAllMonths() {
    if (!feesAlreadyAssigned) {
        var checkboxes = document.querySelectorAll('input[name="months[]"]');
        checkboxes.forEach(function(checkbox) {
            if (!checkbox.disabled) {
                checkbox.checked = true;
            }
        });
    }
}

// Function to clear all months
function clearAllMonths() {
    if (!feesAlreadyAssigned) {
        var checkboxes = document.querySelectorAll('input[name="months[]"]');
        checkboxes.forEach(function(checkbox) {
            if (!checkbox.disabled) {
                checkbox.checked = false;
            }
        });
    }
}

// Function to check pending fees before promotion/demotion/retention
function checkFeesBeforeAction(action, studentId, studentName) {
    // Simple check using existing PHP data
    const feeStatus = <?php echo json_encode($student_fees_status); ?>[studentId] || {};
    const hasPendingFees = feeStatus.has_pending_fees || false;
    
    if (hasPendingFees) {
        // Show pending fees warning
        alert(`❌ ${studentName} ki fees pending hain!\n\nPending Amount: Rs. ${(feeStatus.total_pending_amount || 0).toLocaleString('en-PK', {minimumFractionDigits: 2})}\nPending Months: ${feeStatus.pending_count || 0}\n\nPehle pending fees clear karein, phir ${action} kar sakte hain.`);
        return false;
    } else {
        // No pending fees, proceed with action
        let confirmMessage = '';
        switch(action) {
            case 'promote':
                confirmMessage = `Kya aap yaqeeni hain ke aap ${studentName} ko agli class mein promote karna chahte hain?`;
                break;
            case 'demote':
                confirmMessage = `Kya aap yaqeeni hain ke aap ${studentName} ko pichli class mein demote karna chahte hain?`;
                break;
            case 'retain':
                confirmMessage = `Kya aap yaqeeni hain ke aap ${studentName} ko isi class mein retain karna chahte hain?`;
                break;
        }
        
        if (confirm(confirmMessage)) {
            window.location.href = `students_process.php?action=${action}_student&id=${studentId}`;
        }
    }
    
    return false;
}

// Form submission handler
document.addEventListener('DOMContentLoaded', function() {
    const feeForm = document.getElementById('feeAssignmentForm');
    if (feeForm) {
        feeForm.addEventListener('submit', function(e) {
            if (feesAlreadyAssigned) {
                e.preventDefault();
                alert('Fees already assigned for this student. Cannot modify assigned fees.');
                return false;
            }
        });
    }
});
</script>

<div class="container-fluid">
    <!-- Page Header -->
    <div class="page-header">
        <div class="row align-items-center">
            <div class="col">
                <h1 class="h3 mb-0 text-gray-800">
                    <i class="fas fa-users me-2"></i>
                    <?php if ($viewing_specific_class): ?>
                        Students List - 
                        <?php 
                        $class_name = '';
                        $section_name = '';
                        foreach ($classes as $class) {
                            if ($class['id'] == $search_class) {
                                $class_name = $class['name'];
                                break;
                            }
                        }
                        foreach ($sections as $section) {
                            if ($section['id'] == $search_section) {
                                $section_name = $section['name'];
                                break;
                            }
                        }
                        echo htmlspecialchars($class_name) . " - " . htmlspecialchars($section_name);
                        ?>
                    <?php else: ?>
                        Students Management
                    <?php endif; ?>
                </h1>
                <p class="text-muted mb-0">Active Session: <?php echo $current_session_id; ?></p>
            </div>
            <div class="col-auto">
                <?php if ($viewing_specific_class): ?>
                    <a href="students.php" class="btn btn-outline-secondary">
                        <i class="fas fa-arrow-left me-2"></i>Back to Class & Section Summary
                    </a>
                <?php else: ?>
                    <a href="student_add.php" class="btn btn-primary">
                        <i class="fas fa-plus me-2"></i>Add New Student
                    </a>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <!-- Alert Messages -->
    <?php if ($message): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="fas fa-check-circle me-2"></i><?php echo htmlspecialchars($message); ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>
    
    <?php if ($error): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="fas fa-exclamation-triangle me-2"></i><?php echo htmlspecialchars($error); ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <!-- Class-Section Summary Card (Only show when NOT viewing specific class) -->
    <?php if (!$viewing_specific_class): ?>
    <div class="card data-table-card mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">
                <i class="fas fa-layer-group me-2"></i>Class & Section Summary
            </h6>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th width="60">Sr.</th>
                            <th>Class</th>
                            <th>Section</th>
                            <th width="120">Enrollment</th>
                            <th width="100" class="text-center">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (!empty($class_sections)): ?>
                            <?php $counter = 1; ?>
                            <?php foreach ($class_sections as $cs): ?>
                            <tr>
                                <td class="fw-semibold text-gray-600"><?php echo $counter++; ?></td>
                                <td class="text-gray-600">
                                    <i class="fas fa-graduation-cap me-2 text-primary"></i>
                                    <?php echo htmlspecialchars($cs['class_name']); ?>
                                </td>
                                <td class="text-gray-600">
                                    <i class="fas fa-layer-group me-2 text-info"></i>
                                    <?php echo htmlspecialchars($cs['section_name']); ?>
                                </td>
                                <td>
                                    <span class="enrollment-count"><?php echo $cs['student_count']; ?></span>
                                    <span class="text-muted small"> students</span>
                                </td>
                                <td class="text-center">
                                    <a href="students.php?class=<?php echo $cs['class_id']; ?>&section=<?php echo $cs['section_id']; ?>" 
                                       class="btn btn-sm btn-primary btn-action" 
                                       title="View Students">
                                        <i class="fas fa-eye me-1"></i>View
                                    </a>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="5">
                                    <div class="empty-state">
                                        <i class="fas fa-layer-group"></i>
                                        <h5 class="text-gray-500">No Classes & Sections Found</h5>
                                        <p class="text-muted">No active classes and sections available in the system.</p>
                                    </div>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <!-- Students Data Table Card (Show when viewing specific class OR when searching) -->
    <?php if ($viewing_specific_class || !empty($search_name)): ?>
    <div class="card data-table-card">
        <div class="card-header py-3 d-flex justify-content-between align-items-center">
            <h6 class="m-0 font-weight-bold text-primary">
                <i class="fas fa-users me-2"></i>
                <?php if ($viewing_specific_class): ?>
                    Students of <?php echo htmlspecialchars($class_name . " - " . $section_name); ?>
                    <span class="student-count-badge"><?php echo count($students); ?> Students</span>
                <?php else: ?>
                    Search Results
                    <span class="student-count-badge"><?php echo count($students); ?> Students</span>
                <?php endif; ?>
            </h6>
            <a href="students.php" class="btn btn-sm btn-outline-secondary">
                <i class="fas fa-times me-1"></i>Clear Filter
            </a>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th width="60">ID</th>
                            <th>Student Name</th>
                            <th>Father Name</th>
                            <th width="100">Roll No</th>
                            <th width="120">Class</th>
                            <th width="100">Section</th>
                            <th width="100">Status</th>
                            <th width="120">Admission Date</th>
                            <th width="250" class="text-center">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (!empty($students)): ?>
                            <?php foreach ($students as $student): 
                                // Status Display Logic
                                $status_text = '';
                                $status_class = '';
                                
                                switch ($student['status']) {
                                    case 'active':
                                        $status_text = 'Active';
                                        $status_class = 'status-active';
                                        break;
                                    case 'inactive':
                                        $status_text = 'Inactive';
                                        $status_class = 'status-inactive';
                                        break;
                                    case 'withdrawn':
                                        $status_text = 'Withdrawn';
                                        $status_class = 'status-withdrawn';
                                        break;
                                    default:
                                        $status_text = ucfirst($student['status']);
                                        $status_class = 'status-secondary';
                                        break;
                                }
                                
                                // Check if student has pending fees - fee_invoices table se
                                $feeStatus = $student_fees_status[$student['id']] ?? [];
                                $has_pending_fees = $feeStatus['has_pending_fees'] ?? false;
                                $pending_count = $feeStatus['pending_count'] ?? 0;
                                $pending_amount = $feeStatus['total_pending_amount'] ?? 0;
                                
                                // Check if student has assigned fees - student_fees table se
                                $assignedFees = $student_assigned_fees[$student['id']] ?? [];
                                $has_assigned_fees = $assignedFees['has_assigned_fees'] ?? false;
                                $monthly_fee = $assignedFees['monthly_fee'] ?? 0;
                                $admission_fee = $assignedFees['admission_fee'] ?? 0;
                                $examination_fee = $assignedFees['examination_fee'] ?? 0;
                            ?>
                            <tr>
                                <td class="fw-semibold text-gray-600">#<?php echo $student['id']; ?></td>
                                <td>
                                    <a href="student_profile.php?id=<?php echo $student['id']; ?>" class="student-name-link">
                                        <?php echo htmlspecialchars($student['first_name'] . ' ' . $student['last_name']); ?>
                                    </a>
                                    <?php if ($has_pending_fees): ?>
                                        <span class="badge fee-pending fee-status-badge ms-1" 
                                              title="Fees Not Paid - Pending: Rs. <?php echo number_format($pending_amount, 2); ?>">
                                            <i class="fas fa-exclamation-triangle me-1"></i>Fees Not Paid
                                        </span>
                                    <?php elseif ($has_assigned_fees): ?>
                                        <span class="badge fee-paid fee-status-badge ms-1" 
                                              title="Fees Paid - Monthly: Rs. <?php echo number_format($monthly_fee, 2); ?>">
                                            <i class="fas fa-check-circle me-1"></i>Fees Paid
                                        </span>
                                    <?php else: ?>
                                        <span class="badge fee-not-assigned-badge fee-status-badge ms-1" title="Fee Not Assigned">
                                            <i class="fas fa-info-circle me-1"></i>Fee Not Assigned
                                        </span>
                                    <?php endif; ?>
                                </td>
                                <td class="text-gray-600"><?php echo htmlspecialchars($student['father_name']); ?></td>
                                <td>
                                    <span class="badge bg-light text-dark border"><?php echo htmlspecialchars($student['roll_no'] ?? '-'); ?></span>
                                </td>
                                <td class="text-gray-600"><?php echo htmlspecialchars($student['class_name'] ?? 'Not Enrolled'); ?></td>
                                <td>
                                    <span class="badge bg-light text-dark border"><?php echo htmlspecialchars($student['section_name'] ?? '-'); ?></span>
                                </td>
                                <td>
                                    <span class="badge <?php echo $status_class; ?> text-white">
                                        <?php echo $status_text; ?>
                                    </span>
                                </td>
                                <td class="text-gray-600"><?php echo date('d-M-Y', strtotime($student['admission_date'])); ?></td>
                                <td class="text-center">
                                    <div class="btn-group" role="group">
                                        <a href="student_profile.php?id=<?php echo $student['id']; ?>" class="btn btn-sm btn-secondary btn-action" title="View Profile">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="student_edit.php?id=<?php echo $student['id']; ?>" class="btn btn-sm btn-info btn-action" title="Edit Student">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        
                                        <!-- Fee Assignment Button -->
                                        <button type="button" 
                                                class="btn btn-sm btn-fee btn-action" 
                                                title="View/Assign Fees"
                                                onclick="openFeeModal(
                                                    <?php echo $student['id']; ?>,
                                                    '<?php echo htmlspecialchars(addslashes($student['first_name'] . ' ' . $student['last_name'])); ?>',
                                                    '<?php echo htmlspecialchars(addslashes($student['class_name'] ?? 'Not Enrolled')); ?>',
                                                    '<?php echo htmlspecialchars(addslashes($student['section_name'] ?? '-')); ?>'
                                                )">
                                            <i class="fas fa-money-bill-wave"></i>
                                        </button>
                                        
                                        <!-- Promotion/Demotion/Retention Buttons -->
                                        <?php if ($has_pending_fees): ?>
                                            <!-- Pending fees hone par disabled buttons -->
                                            <button class="btn btn-sm btn-promote btn-action pending-fees-warning" 
                                                    title="Fees Pending - Cannot Promote">
                                                <i class="fas fa-arrow-up"></i>
                                            </button>
                                            <button class="btn btn-sm btn-demote btn-action pending-fees-warning" 
                                                    title="Fees Pending - Cannot Demote">
                                                <i class="fas fa-arrow-down"></i>
                                            </button>
                                            <button class="btn btn-sm btn-retain btn-action pending-fees-warning" 
                                                    title="Fees Pending - Cannot Retain">
                                                <i class="fas fa-redo"></i>
                                            </button>
                                        <?php else: ?>
                                            <!-- No pending fees - normal buttons -->
                                            <a href="#" 
                                               class="btn btn-sm btn-promote btn-action" 
                                               onclick="return checkFeesBeforeAction('promote', <?php echo $student['id']; ?>, '<?php echo htmlspecialchars(addslashes($student['first_name'] . ' ' . $student['last_name'])); ?>')" 
                                               title="Promote Student">
                                                <i class="fas fa-arrow-up"></i>
                                            </a>
                                            
                                            <a href="#" 
                                               class="btn btn-sm btn-demote btn-action" 
                                               onclick="return checkFeesBeforeAction('demote', <?php echo $student['id']; ?>, '<?php echo htmlspecialchars(addslashes($student['first_name'] . ' ' . $student['last_name'])); ?>')" 
                                               title="Demote Student">
                                                <i class="fas fa-arrow-down"></i>
                                            </a>
                                            
                                            <a href="#" 
                                               class="btn btn-sm btn-retain btn-action" 
                                               onclick="return checkFeesBeforeAction('retain', <?php echo $student['id']; ?>, '<?php echo htmlspecialchars(addslashes($student['first_name'] . ' ' . $student['last_name'])); ?>')" 
                                               title="Retain Student">
                                                <i class="fas fa-redo"></i>
                                            </a>
                                        <?php endif; ?>
                                        
                                        <a href="students_process.php?action=delete_student&id=<?php echo $student['id']; ?>" 
                                           class="btn btn-sm btn-danger btn-action" 
                                           onclick="return confirm('Kya aap yaqeeni hain ke aap is student ko delete karna chahte hain? Yeh action wapas nahi ho sakta.')" 
                                           title="Delete Student">
                                            <i class="fas fa-trash"></i>
                                        </a>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="9">
                                    <div class="empty-state">
                                        <i class="fas fa-user-slash"></i>
                                        <h5 class="text-gray-500">No Students Found</h5>
                                        <p class="text-muted">No student records match your search criteria.</p>
                                        <a href="students.php" class="btn btn-primary mt-2">
                                            <i class="fas fa-redo me-2"></i>Back to Student List
                                        </a>
                                    </div>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <?php endif; ?>
</div>

<?php
include_once('includes/footer.php'); 
?>