<?php
// admin/subject_edit.php - Edit Subject Form (Dedicated Page)

session_start();
// Security Check
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

include_once('../config/db.php');
include_once('includes/header.php'); 
include_once('includes/sidebar.php'); 

$conn = getDBConnection();
$subject_id = (int)($_GET['id'] ?? 0);
$subject = null;
$error = '';

if ($subject_id <= 0) {
    $error = "Invalid Subject ID provided.";
} else {
    // Subject data fetch karein
    $stmt = $conn->prepare("SELECT id, name, code, type FROM subjects WHERE id = ?");
    $stmt->bind_param("i", $subject_id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows === 1) {
        $subject = $result->fetch_assoc();
    } else {
        $error = "Subject not found.";
    }
    $stmt->close();
}

// Session messages ko retrieve karein (subject_process.php se aaye hue errors)
$message = $_GET['msg'] ?? '';
if (isset($_SESSION['edit_msg'])) {
    $message = $_SESSION['edit_msg'];
    unset($_SESSION['edit_msg']);
}
if (isset($_SESSION['edit_err'])) {
    $error = $_SESSION['edit_err'];
    unset($_SESSION['edit_err']);
}

?>

<h1 class="mb-4">Edit Subject <i class="fas fa-edit"></i></h1>

<?php if ($message): ?>
    <div class="alert alert-success"><?php echo htmlspecialchars($message); ?></div>
<?php endif; ?>
<?php if ($error): ?>
    <div class="alert alert-danger"><?php echo htmlspecialchars($error); ?></div>
<?php endif; ?>

<?php if ($subject): ?>
    <div class="card p-4 shadow-sm col-md-6 mx-auto">
        <h4 class="card-title">Editing: **<?php echo htmlspecialchars($subject['name']); ?>** (ID: <?php echo $subject['id']; ?>)</h4>
        <form action="subject_process.php" method="POST">
            <input type="hidden" name="action" value="update_subject">
            <input type="hidden" name="id" value="<?php echo $subject['id']; ?>">
            
            <div class="form-group">
                <label>Subject Name:</label>
                <input type="text" name="name" class="form-control" value="<?php echo htmlspecialchars($subject['name']); ?>" required>
            </div>
            <div class="form-group">
                <label>Subject Code (Optional):</label>
                <input type="text" name="code" class="form-control" value="<?php echo htmlspecialchars($subject['code'] ?? ''); ?>">
            </div>
            <div class="form-group">
                <label>Type:</label>
                <select name="type" class="form-control">
                    <option value="core" <?php echo ($subject['type'] == 'core') ? 'selected' : ''; ?>>Core (Lāzimī)</option>
                    <option value="elective" <?php echo ($subject['type'] == 'elective') ? 'selected' : ''; ?>>Elective (Ikhtiyārī)</option>
                    <option value="optional" <?php echo ($subject['type'] == 'optional') ? 'selected' : ''; ?>>Optional</option>
                </select>
            </div>
            <div class="d-flex justify-content-between">
                <a href="subjects.php" class="btn btn-secondary"><i class="fas fa-chevron-left"></i> Back to Subjects</a>
                <button type="submit" class="btn btn-primary"><i class="fas fa-save"></i> Save Changes</button>
            </div>
        </form>
    </div>
<?php else: ?>
    <div class="alert alert-info">Subject details could not be loaded. Please check the ID or go back.</div>
    <a href="subjects.php" class="btn btn-secondary"><i class="fas fa-chevron-left"></i> Back to Subjects</a>
<?php endif; ?>

<?php
// Connection close karein
if (isset($conn) && is_object($conn)) {
    $conn->close();
}

include_once('includes/footer.php'); 
?>