<?php
// admin/subjects.php - Manage Subjects and Course Allocation (Without Teacher)

session_start();
// Security Check
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

include_once('../config/db.php');
include_once('includes/header.php'); 
include_once('includes/sidebar.php'); 

// Connection establish karein.
$conn = getDBConnection();
$message = $_GET['msg'] ?? '';
$error = $_GET['err'] ?? '';

// --- Data Fetching ---

$current_session_id = $settings['academic.active_session_id'] ?? 1;

// 1. Fetch Subjects
$subjects_result = $conn->query("SELECT id, name, code, type FROM subjects ORDER BY name ASC");
$subjects = $subjects_result->fetch_all(MYSQLI_ASSOC);

// 2. Fetch Classes/Sections for Allocation forms
$classes_result = $conn->query("SELECT id, name FROM academic_classes ORDER BY order_no ASC");
$classes = $classes_result->fetch_all(MYSQLI_ASSOC);

$sections_result = $conn->query("SELECT id, name FROM academic_sections WHERE status='active' ORDER BY name ASC");
$sections = $sections_result->fetch_all(MYSQLI_ASSOC);

// 3. Fetch Existing Allocations
$allocation_query = "
    SELECT 
        ca.id, 
        ca.class_id,
        ca.section_id,
        ca.subject_id,
        ac.name as class_name, 
        asec.name as section_name, 
        sub.name as subject_name
    FROM course_allocation ca
    JOIN academic_classes ac ON ca.class_id = ac.id
    LEFT JOIN academic_sections asec ON ca.section_id = asec.id 
    JOIN subjects sub ON ca.subject_id = sub.id
    WHERE ca.session_id = {$current_session_id}
    ORDER BY ac.order_no, asec.name, sub.name
";
$allocations_result = $conn->query($allocation_query);
$allocations = $allocations_result->fetch_all(MYSQLI_ASSOC);

// Allocated subjects ko track karne ke liye ek structure banate hain (for JS pre-selection)
$allocated_subjects = [];
foreach ($allocations as $alloc) {
    // Key format: class_id_section_id
    $key = $alloc['class_id'] . '_' . ($alloc['section_id'] ?? 'NULL');
    if (!isset($allocated_subjects[$key])) {
        $allocated_subjects[$key] = [];
    }
    $allocated_subjects[$key][$alloc['subject_id']] = true;
}

?>

<h1 class="mb-4">Subjects & Course Allocation <i class="fas fa-book-reader"></i></h1>

<?php if ($message): ?>
    <div class="alert alert-success"><?php echo htmlspecialchars($message); ?></div>
<?php endif; ?>
<?php if ($error): ?>
    <div class="alert alert-danger"><?php echo htmlspecialchars($error); ?></div>
<?php endif; ?>

<ul class="nav nav-tabs" id="subjectTab" role="tablist">
    <li class="nav-item">
        <a class="nav-link <?php echo (!isset($_GET['tab']) || $_GET['tab'] == 'subjects') ? 'active' : ''; ?>" data-toggle="tab" href="#subjects" role="tab" aria-controls="subjects" aria-selected="true"><i class="fas fa-book"></i> 1. Manage Subjects</a>
    </li>
    <li class="nav-item">
        <a class="nav-link <?php echo (isset($_GET['tab']) && $_GET['tab'] == 'allocation') ? 'active' : ''; ?>" data-toggle="tab" href="#allocation" role="tab" aria-controls="allocation" aria-selected="false"><i class="fas fa-chalkboard-teacher"></i> 2. Course Allocation</a>
    </li>
</ul>

<div class="tab-content mt-3">
    <div class="tab-pane fade <?php echo (!isset($_GET['tab']) || $_GET['tab'] == 'subjects') ? 'show active' : ''; ?>" id="subjects" role="tabpanel">
        <div class="row">
            <div class="col-md-5">
                <div class="card p-3 shadow-sm">
                    <h4>Add New Subject</h4>
                    <form action="subject_process.php" method="POST">
                        <input type="hidden" name="action" value="add_subject">
                        <div class="form-group">
                            <label>Subject Name (e.g., Mathematics):</label>
                            <input type="text" name="name" class="form-control" required>
                        </div>
                        <div class="form-group">
                            <label>Subject Code (e.g., PTB, OXFORD, CAMBRADGE) (Optional):</label>
                            <input type="text" name="code" class="form-control">
                        </div>
                        <div class="form-group">
                            <label>Type:</label>
                            <select name="type" class="form-control">
                                <option value="core">Core (Lāzimī)</option>
                                <option value="elective">Elective (Ikhtiyārī)</option>
                            </select>
                        </div>
                        <button type="submit" class="btn btn-primary">Save Subject</button>
                    </form>
                </div>
            </div>
            <div class="col-md-7">
                <div class="card p-3 shadow-sm">
                    <h4>Existing Subjects (<?php echo count($subjects); ?>)</h4>
                    <div class="table-responsive">
                        <table class="table table-bordered table-sm table-striped">
                            <thead class="thead-light">
                                <tr><th>Name</th><th>Code</th><th>Type</th><th>Actions</th></tr>
                            </thead>
                            <tbody>
                                <?php foreach ($subjects as $subject): ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($subject['name']); ?></td>
                                    <td><?php echo htmlspecialchars($subject['code'] ?? 'N/A'); ?></td>
                                    <td><?php echo ucfirst(htmlspecialchars($subject['type'])); ?></td>
                                    <td>
                                        <a href="subject_edit.php?id=<?php echo $subject['id']; ?>" class="btn btn-sm btn-info">
                                            Edit
                                        </a>
                                        <a href="subject_process.php?action=delete_subject&id=<?php echo $subject['id']; ?>" class="btn btn-sm btn-danger" onclick="return confirm('WARNING: Is subject ko delete karne se is se mutalliq tamam allocations aur marks records delete ho jayenge. Kya aap waqai delete karna chahte hain?');">Del</a>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="tab-pane fade <?php echo (isset($_GET['tab']) && $_GET['tab'] == 'allocation') ? 'show active' : ''; ?>" id="allocation" role="tabpanel">
        <div class="row">
            <div class="col-md-5">
                <div class="card p-3 shadow-sm">
                    <h4>Assign Subjects to Class</h4>
                    <form action="subject_process.php" method="POST">
                        <input type="hidden" name="action" value="allocate_subjects_batch">
                        <input type="hidden" name="session_id" value="<?php echo $current_session_id; ?>">
                        
                        <div class="form-group">
                            <label>Class:</label>
                            <select name="class_id" id="allocation-class" class="form-control" required>
                                <option value="">-- Select Class --</option>
                                <?php foreach ($classes as $class): ?>
                                    <option value="<?php echo $class['id']; ?>"><?php echo htmlspecialchars($class['name']); ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="form-group">
                            <label>Section (Optional, All Sections ke liye khali chhor dein):</label>
                            <select name="section_id" id="allocation-section" class="form-control">
                                <option value="">-- All Sections --</option>
                                <?php foreach ($sections as $section): ?>
                                    <option value="<?php echo $section['id']; ?>"><?php echo htmlspecialchars($section['name']); ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        
                        <h5 class="mt-4">Select Subjects (Check marks):</h5>
                        <div class="subject-list" style="max-height: 250px; overflow-y: auto; border: 1px solid #ccc; padding: 10px;">
                            <?php if (empty($subjects)): ?>
                                <p class="text-danger">Pehle Subjects add karein.</p>
                            <?php else: ?>
                                <?php foreach ($subjects as $subject): ?>
                                    <div class="form-check">
                                        <input class="form-check-input allocation-subject-check" 
                                               type="checkbox" 
                                               name="subject_ids[]" 
                                               value="<?php echo $subject['id']; ?>" 
                                               id="subject_<?php echo $subject['id']; ?>">
                                        <label class="form-check-label" for="subject_<?php echo $subject['id']; ?>">
                                            <?php echo htmlspecialchars($subject['name']); ?> (<?php echo ucfirst($subject['type']); ?>)
                                        </label>
                                    </div>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </div>
                        
                        <button type="submit" class="btn btn-success mt-3" <?php echo empty($subjects) ? 'disabled' : ''; ?>>Allocate Selected Subjects</button>
                    </form>
                </div>
            </div>
            
            <div class="col-md-7">
                <div class="card p-3 shadow-sm">
                    <h4>Current Allocations (Session: <?php echo $current_session_id; ?>)</h4>
                    <div class="table-responsive">
                        <table class="table table-bordered table-sm table-striped">
                            <thead class="thead-light">
                                <tr><th>Class/Section</th><th>Subject</th><th>Actions</th></tr>
                            </thead>
                            <tbody>
                                <?php foreach ($allocations as $alloc): ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($alloc['class_name']); ?> / <?php echo htmlspecialchars($alloc['section_name'] ?? 'ALL'); ?></td>
                                    <td><?php echo htmlspecialchars($alloc['subject_name']); ?></td>
                                    <td>
                                        <a href="subject_process.php?action=delete_allocation&id=<?php echo $alloc['id']; ?>" class="btn btn-sm btn-danger" onclick="return confirm('Is course allocation ko hatana chahte hain?');">Remove</a>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    // Allocation data ko JS mein store karein (PHP se)
    var allocatedSubjects = <?php echo json_encode($allocated_subjects); ?>;

    function updateSubjectCheckboxes() {
        var classId = $('#allocation-class').val();
        var sectionId = $('#allocation-section').val() || 'NULL';
        var key = classId + '_' + sectionId;
        
        // Sab checkboxes ko uncheck karein
        $('.allocation-subject-check').prop('checked', false);

        if (classId && allocatedSubjects[key]) {
            // Agar is combination (Class/Section) ke liye subjects allocated hain, to unhe check karein
            for (var subjectId in allocatedSubjects[key]) {
                if (allocatedSubjects[key].hasOwnProperty(subjectId)) {
                    $('#subject_' + subjectId).prop('checked', true);
                }
            }
        }
    }

    // Class aur Section change hone par checkboxes update karein
    $('#allocation-class, #allocation-section').on('change', updateSubjectCheckboxes);

    // Initial load par agar URL mein tab=allocation ho to update karein
    if (new URLSearchParams(window.location.search).get('tab') === 'allocation') {
        updateSubjectCheckboxes();
    }
});
</script>

<?php
// Connection close karein
if (isset($conn) && is_object($conn)) {
    $conn->close();
}

include_once('includes/footer.php'); 
?>