<?php
// admin/teachers_process.php
session_start();
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php'); 
    exit;
}
include_once('../config/db.php');
$conn = getDBConnection();

$action = $_POST['action'] ?? $_GET['action'] ?? '';

// Function to handle redirection
function redirect($page, $msg = '', $view = 'list', $type = 'success') {
    $param_name = ($type === 'success') ? 'msg' : 'err';
    // Edit action ke baad humesha list view par bhej rahe hain
    $view_param = ($action === 'edit_teacher') ? 'list' : $view;
    header("Location: $page.php?view=$view_param&$param_name=" . urlencode($msg));
    exit;
}

// ====================================================================
// ACTION 1: ADD NEW TEACHER
// ====================================================================
if ($action === 'add_teacher' && $_SERVER['REQUEST_METHOD'] === 'POST') {
    
    // Data Retrieval
    $name = trim($_POST['name'] ?? '');
    $emp_no = trim($_POST['emp_no'] ?? NULL);
    $designation = trim($_POST['designation'] ?? '');
    $qualification = trim($_POST['qualification'] ?? NULL);
    $cnic = trim($_POST['cnic'] ?? '');
    $phone = trim($_POST['phone'] ?? NULL);
    $joining_date = $_POST['joining_date'] ?? date('Y-m-d');
    $salary = (float)($_POST['salary'] ?? 0.00); 
    $photo_path = NULL; 

    // Basic Validation
    if (empty($name) || empty($designation) || empty($cnic) || $salary < 0) {
        redirect('teachers', 'Zaruri maloomat (Name, Designation, CNIC, Salary) adhoori hain.', 'add', 'danger');
    }

    // Photo Upload Handling
    if (isset($_FILES['photo']) && $_FILES['photo']['error'] === 0) {
        $upload_dir = '../uploads/teachers/';
        if (!is_dir($upload_dir)) { mkdir($upload_dir, 0777, true); }
        $file_ext = pathinfo($_FILES['photo']['name'], PATHINFO_EXTENSION);
        $new_filename = uniqid('teach_') . '.' . $file_ext;
        $destination = $upload_dir . $new_filename;

        if (move_uploaded_file($_FILES['photo']['tmp_name'], $destination)) {
            $photo_path = $new_filename; 
        } else {
            redirect('teachers', 'Photo upload failed. Check folder permissions.', 'add', 'danger');
        }
    } else {
        $photo_path = 'default.png'; 
    }

    // INSERT into teachers table
    $stmt = $conn->prepare("INSERT INTO teachers 
        (name, emp_no, designation, qualification, cnic, phone, joining_date, salary, photo_path) 
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
        
    // Bind string: 9 variables (7 strings, 1 double, 1 string)
    $stmt->bind_param("sssssssds", 
        $name, $emp_no, $designation, $qualification, $cnic, $phone, $joining_date, $salary, $photo_path
    );
    
    if ($stmt->execute()) {
        $stmt->close();
        redirect('teachers', 'Teacher "' . $name . '" successfully saved.', 'list', 'success');
    } else {
        $error_message = 'Teacher save nahi ho saka.';
        if ($conn->errno == 1062) {
            $error_message = 'Teacher save nahi ho saka. CNIC ya Emp No pehle se mojood ho sakta hai.';
        }
        redirect('teachers', $error_message . ' Error: ' . $stmt->error, 'add', 'danger');
    }
}

// ====================================================================
// ACTION 2: EDIT/UPDATE TEACHER
// ====================================================================
elseif ($action === 'edit_teacher' && $_SERVER['REQUEST_METHOD'] === 'POST') {
    
    // Data Retrieval
    $teacher_id = (int)($_POST['teacher_id'] ?? 0);
    $name = trim($_POST['name'] ?? '');
    $emp_no = trim($_POST['emp_no'] ?? NULL);
    $designation = trim($_POST['designation'] ?? '');
    $qualification = trim($_POST['qualification'] ?? NULL);
    $cnic = trim($_POST['cnic'] ?? '');
    $phone = trim($_POST['phone'] ?? NULL);
    $joining_date = $_POST['joining_date'] ?? date('Y-m-d');
    $salary = (float)($_POST['salary'] ?? 0.00); 
    $status = $_POST['status'] ?? 'active';

    if ($teacher_id == 0) {
        redirect('teachers', 'Invalid Teacher ID for update.', 'list', 'danger');
    }
     if (empty($name) || empty($designation) || empty($cnic) || $salary < 0) {
        redirect('teachers', 'Zaruri maloomat (Name, Designation, CNIC, Salary) adhoori hain.', 'edit', 'danger');
    }

    $conn->begin_transaction();
    try {
        // A. Fetch current photo name
        $current_q = $conn->query("SELECT photo_path FROM teachers WHERE id = {$teacher_id}");
        $current_photo = $current_q->fetch_assoc()['photo_path'] ?? 'default.png';
        $photo_name = $current_photo;

        // B. Handle New Photo Upload
        if (isset($_FILES['photo']) && $_FILES['photo']['error'] == 0) {
            $upload_dir = '../uploads/teachers/';
            if (!is_dir($upload_dir)) { mkdir($upload_dir, 0777, true); }
            
            $ext = pathinfo($_FILES['photo']['name'], PATHINFO_EXTENSION);
            $new_file_name = 'teacher_' . $teacher_id . '_' . time() . '.' . $ext;
            
            if (move_uploaded_file($_FILES['photo']['tmp_name'], $upload_dir . $new_file_name)) {
                $photo_name = $new_file_name;
                if ($current_photo && $current_photo !== 'default.png' && file_exists($upload_dir . $current_photo)) {
                    unlink($upload_dir . $current_photo); 
                }
            } else {
                throw new Exception("Photo upload failed during update.");
            }
        }
        
        // C. Update Teacher Record
        $update_q = $conn->prepare("UPDATE teachers SET 
            name = ?, emp_no = ?, designation = ?, qualification = ?, cnic = ?, 
            phone = ?, joining_date = ?, salary = ?, status = ?, photo_path = ? 
            WHERE id = ?");

        // 🔑 FINAL FIX: Bind string corrected to 'sssssssdssi' (11 characters for 11 variables)
        // Variables: name(s), emp_no(s), designation(s), qualification(s), cnic(s), phone(s), joining_date(s), salary(d), status(s), photo_name(s), teacher_id(i)
        $update_q->bind_param("sssssssdssi", 
            $name, $emp_no, $designation, $qualification, $cnic, 
            $phone, $joining_date, $salary, $status, $photo_name, $teacher_id
        );
        
        if (!$update_q->execute()) {
            if ($conn->errno == 1062) {
                throw new Exception("CNIC already exists for another teacher.");
            }
            throw new Exception("Teacher update failed: " . $update_q->error);
        }

        $conn->commit();
        redirect('teachers', 'Teacher details updated successfully. (ID: ' . $teacher_id . ')', 'list', 'success');

    } catch (Exception $e) {
        $conn->rollback();
        // Redirect back to the edit view with the error
        redirect('teachers', 'Update failed: ' . $e->getMessage(), 'edit', 'danger');
    }
}

// ====================================================================
// ACTION 3: DELETE TEACHER
// ====================================================================
elseif ($action === 'delete_teacher' && isset($_GET['id'])) {
    
    $teacher_id = (int)$_GET['id'];
    
    if ($teacher_id > 0) {
        // Check if teacher exists
        $stmt = $conn->prepare("SELECT * FROM teachers WHERE id = ?");
        $stmt->bind_param("i", $teacher_id);
        $stmt->execute();
        $result = $stmt->get_result();
        
        if ($result->num_rows > 0) {
            $teacher_data = $result->fetch_assoc();
            
            // Delete teacher from database
            $delete_stmt = $conn->prepare("DELETE FROM teachers WHERE id = ?");
            $delete_stmt->bind_param("i", $teacher_id);
            
            if ($delete_stmt->execute()) {
                // Delete teacher's photo if exists and not default
                $photo_path = $teacher_data['photo_path'] ?? '';
                if ($photo_path && $photo_path !== 'default.png') {
                    $upload_dir = '../uploads/teachers/';
                    if (file_exists($upload_dir . $photo_path)) {
                        unlink($upload_dir . $photo_path);
                    }
                }
                redirect('teachers', 'Teacher "' . $teacher_data['name'] . '" successfully deleted.', 'list', 'success');
            } else {
                redirect('teachers', 'Error deleting teacher.', 'list', 'danger');
            }
            $delete_stmt->close();
        } else {
            redirect('teachers', 'Teacher not found.', 'list', 'danger');
        }
        
        $stmt->close();
    } else {
        redirect('teachers', 'Invalid teacher ID.', 'list', 'danger');
    }
}

// ====================================================================
// FALLBACK
// ====================================================================
else {
    redirect('teachers', 'Invalid action.', 'list', 'danger');
}

$conn->close();
?>