<?php
// admin/unpaid_fee_report.php - FINAL LANDSCAPE VERSION WITHOUT REGISTRATION NO
session_start();
include_once('includes/header.php'); 

$conn = getDBConnection();

// School info fetch karein - fee_voucher_print.php jaisa
$settings = [];
$result = $conn->query("SELECT setting_key, setting_value FROM settings WHERE setting_key IN ('institute.name','institute.address','institute.logo_path', 'institute.phone')");
while ($row = $result->fetch_assoc()) {
    $settings[$row['setting_key']] = $row['setting_value'];
}

$school_name = $settings['institute.name'] ?? '';
$school_address = $settings['institute.address'] ?? '';
$school_phone = $settings['institute.phone'] ?? '';
$school_logo_path = $settings['institute.logo_path'] ?? '';
// Logo path check karein
$school_logo = '';
if (!empty($school_logo_path)) {
    // Check karein ke file actually exist karti hai ya nahi
    $full_logo_path = '../' . $school_logo_path;
    if (file_exists($full_logo_path)) {
        $school_logo = $full_logo_path;
    } else {
        // Agar file nahi milti to base path try karein
        $alt_logo_path = $school_logo_path;
        if (file_exists($alt_logo_path)) {
            $school_logo = $alt_logo_path;
        }
    }
}

// Current Session ID fetch karein
$settings_result = $conn->query("SELECT setting_value FROM settings WHERE setting_key='academic.active_session_id'");
$current_session_id = $settings_result->fetch_assoc()['setting_value'] ?? 1;

// Classes aur sections fetch karein
$classes_result = $conn->query("SELECT id, name FROM academic_classes ORDER BY order_no ASC");
$classes = $classes_result->fetch_all(MYSQLI_ASSOC);

$sections_result = $conn->query("SELECT id, name FROM academic_sections ORDER BY name ASC");
$sections = $sections_result->fetch_all(MYSQLI_ASSOC);

// Filter parameters
$report_class = $_GET['report_class'] ?? '';
$report_section = $_GET['report_section'] ?? '';

// Get class and section names for display
$selected_class_name = "All Classes";
$selected_section_name = "All Sections";

if (!empty($report_class)) {
    $class_result = $conn->query("SELECT name FROM academic_classes WHERE id = " . intval($report_class));
    if ($class_result && $class_row = $class_result->fetch_assoc()) {
        $selected_class_name = $class_row['name'];
    }
}

if (!empty($report_section)) {
    $section_result = $conn->query("SELECT name FROM academic_sections WHERE id = " . intval($report_section));
    if ($section_result && $section_row = $section_result->fetch_assoc()) {
        $selected_section_name = $section_row['name'];
    }
}

// Pagination
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$per_page = 50; // Print ke liye zyada records
$offset = ($page - 1) * $per_page;

// Build filter conditions
$class_condition = "";
$section_condition = "";

if (!empty($report_class) && $report_class != '') {
    $class_condition = " AND en.class_id = " . intval($report_class);
}

if (!empty($report_section) && $report_section != '') {
    $section_condition = " AND en.section_id = " . intval($report_section);
}

// Total students count for pagination
$count_query = "
    SELECT COUNT(DISTINCT s.id) as total
    FROM students s
    INNER JOIN student_enrollments en ON s.id = en.student_id 
    INNER JOIN fee_invoices fi ON s.id = fi.student_id 
    WHERE (fi.net_payable > fi.amount_paid OR fi.status IS NULL OR fi.status = '' OR fi.status IN ('unpaid', 'pending'))
    {$class_condition} {$section_condition}
";

$count_result = $conn->query($count_query);
$total_students = $count_result->fetch_assoc()['total'] ?? 0;
$total_pages = ceil($total_students / $per_page);

// Main query for students with unpaid fees
$students_query = "
    SELECT DISTINCT
        s.id as student_id,
        s.first_name,
        s.last_name,
        s.father_name,
        c.name as class_name,
        sec.name as section_name,
        en.roll_no,
        s.status as student_status
    FROM students s
    INNER JOIN student_enrollments en ON s.id = en.student_id 
    INNER JOIN academic_classes c ON en.class_id = c.id
    LEFT JOIN academic_sections sec ON en.section_id = sec.id
    INNER JOIN fee_invoices fi ON s.id = fi.student_id 
    WHERE (fi.net_payable > fi.amount_paid OR fi.status IS NULL OR fi.status = '' OR fi.status IN ('unpaid', 'pending'))
    {$class_condition} {$section_condition}
    ORDER BY c.order_no ASC, en.roll_no ASC
    LIMIT {$offset}, {$per_page}
";

$students_result = $conn->query($students_query);
$students = [];
if ($students_result) {
    while ($row = $students_result->fetch_assoc()) {
        $students[] = $row;
    }
}

// Months array for header - Full month names
$months = [
    '01' => 'Jan', '02' => 'Feb', '03' => 'Mar', '04' => 'Apr',
    '05' => 'May', '06' => 'Jun', '07' => 'Jul', '08' => 'Aug',
    '09' => 'Sep', '10' => 'Oct', '11' => 'Nov', '12' => 'Dec'
];

// Fetch fee data for each student
$student_fees = [];
$grand_totals = array_fill_keys(array_keys($months), 0);
$overall_total = 0;

foreach ($students as $student) {
    $student_id = $student['student_id'];
    
    // Get unpaid invoices for this student
    $fees_query = "
        SELECT 
            SUBSTRING(fi.month_year, 6, 2) as month_num,
            (fi.net_payable - fi.amount_paid) as balance_due
        FROM fee_invoices fi
        WHERE fi.student_id = {$student_id}
        AND (fi.net_payable > fi.amount_paid OR fi.status IS NULL OR fi.status = '' OR fi.status IN ('unpaid', 'pending'))
    ";
    
    $fees_result = $conn->query($fees_query);
    $monthly_fees = array_fill_keys(array_keys($months), 0);
    $student_total = 0;
    
    if ($fees_result) {
        while ($fee_row = $fees_result->fetch_assoc()) {
            $month = $fee_row['month_num'];
            $balance_due = (float)$fee_row['balance_due'];
            
            if (isset($monthly_fees[$month])) {
                $monthly_fees[$month] = $balance_due;
                $grand_totals[$month] += $balance_due;
                $student_total += $balance_due;
            }
        }
    }
    
    $student_fees[$student_id] = [
        'monthly' => $monthly_fees,
        'total' => $student_total
    ];
    
    $overall_total += $student_total;
}

$conn->close();
?>

<style>
/* Print Styles - LANDSCAPE */
@media print {
    @page {
        size: A4 landscape;
        margin: 5mm;
    }
    
    body * {
        visibility: hidden;
    }
    .print-section, .print-section * {
        visibility: visible;
    }
    .print-section {
        position: absolute;
        left: 0;
        top: 0;
        width: 100%;
        background: white;
    }
    .no-print {
        display: none !important;
    }
    .page-header,
    .search-card,
    .summary-card,
    .pagination,
    .btn-group,
    .card-header {
        display: none !important;
    }
    .data-table-card {
        border: none !important;
        box-shadow: none !important;
        width: 100% !important;
    }
    .table {
        border: 2px solid #000 !important;
        width: 100% !important;
        font-size: 9px !important;
    }
    .table th, .table td {
        border: 1px solid #000 !important;
        padding: 3px 2px !important;
        font-size: 8px !important;
    }
    
    /* PRINT MEIN SCHOOL HEADER SHOW HOGA */
    .school-header-print {
        display: flex !important;
        align-items: center;
        margin-bottom: 10px;
        border-bottom: 2px solid #000;
        padding-bottom: 8px;
        width: 100%;
    }
    .school-logo-print {
        width: 60px;
        height: 60px;
        margin-right: 15px;
        border: 1px solid #000;
        padding: 2px;
        flex-shrink: 0;
    }
    .school-logo-print img {
        width: 100%;
        height: 100%;
        object-fit: contain;
        display: block;
    }
    .school-info-print {
        flex: 1;
        text-align: center;
    }
    .school-info-print h2 {
        margin: 0;
        font-size: 16px;
        font-weight: bold;
        line-height: 1.2;
    }
    .school-info-print h3 {
        margin: 2px 0;
        font-size: 12px;
        line-height: 1.1;
    }
    .school-info-print h4 {
        margin: 2px 0;
        font-size: 10px;
        line-height: 1.1;
    }
    .class-info-print {
        display: block !important;
        background: #f0f0f0;
        padding: 4px;
        margin-bottom: 8px;
        border: 1px solid #000;
        font-weight: bold;
        font-size: 10px;
        text-align: center;
    }
    .table-footer {
        background: #d3d3d3 !important;
        font-weight: bold;
    }
    .student-status {
        font-size: 7px !important;
        font-style: italic;
    }
    .amount-cell {
        text-align: right !important;
    }
}

/* Screen Styles */
.page-header {
    border-bottom: 1px solid #e3e6f0;
    padding-bottom: 1rem;
    margin-bottom: 2rem;
}

.search-card {
    border: 1px solid #e3e6f0;
    border-radius: 0.5rem;
    box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.15);
}

.search-card .card-header {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    border-radius: 0.5rem 0.5rem 0 0 !important;
    padding: 1rem 1.5rem;
}

.data-table-card {
    border: 1px solid #e3e6f0;
    border-radius: 0.5rem;
    box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.15);
}

.table th {
    background: #f8f9fc;
    color: #4e73df;
    font-weight: 700;
    border-bottom: 2px solid #e3e6f0;
    padding: 0.75rem;
    font-size: 0.85rem;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.table td {
    padding: 0.75rem;
    vertical-align: middle;
    border-color: #e3e6f0;
    font-size: 0.9rem;
}

.amount-cell {
    text-align: right;
    font-weight: 600;
}

.amount-due {
    color: #e74a3b;
    background-color: #fde8e8;
}

.amount-paid {
    color: #1cc88a;
}

.empty-state {
    padding: 3rem 1rem;
    text-align: center;
    color: #6c757d;
}

.pagination {
    justify-content: center;
    margin-top: 2rem;
}

.page-item.active .page-link {
    background-color: #4e73df;
    border-color: #4e73df;
}

.summary-card {
    background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);
    color: white;
    border-radius: 0.5rem;
}

.month-header {
    background: #e74a3b !important;
    color: white !important;
    text-align: center;
}

.total-header {
    background: #1cc88a !important;
    color: white !important;
    text-align: center;
}

.student-status {
    font-size: 0.7rem;
    color: #6c757d;
    font-style: italic;
}

/* SCREEN PAR SCHOOL HEADER BILKUL NAHI DIKHEGA */
.school-header-print,
.class-info-print {
    display: none;
}
</style>

<div class="container-fluid">
    <!-- Page Header -->
    <div class="page-header no-print">
        <div class="row align-items-center">
            <div class="col">
                <h1 class="h3 mb-0 text-gray-800">
                    <i class="fas fa-file-invoice-dollar me-2"></i>
                    Outstanding Fee Report
                </h1>
                <p class="text-muted mb-0">View outstanding fees for all students</p>
            </div>
            <div class="col-auto">
                <a href="fees_vouchers.php" class="btn btn-primary">
                    <i class="fas fa-hand-holding-usd me-2"></i>Collect Fees
                </a>
            </div>
        </div>
    </div>

    <!-- Summary Cards -->
    <div class="row mb-4 no-print">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card summary-card shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-white text-uppercase mb-1">
                                Students with Outstanding Fees
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-white">
                                <?php echo $total_students; ?>
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-users fa-2x text-white"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-danger shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-danger text-uppercase mb-1">
                                Total Outstanding Amount
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                Rs. <?php echo number_format($overall_total, 2); ?>
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-money-bill-wave fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Search Filters Card -->
    <div class="card search-card mb-4 no-print">
        <div class="card-header">
            <h6 class="m-0 font-weight-bold">
                <i class="fas fa-filter me-2"></i>Filter Students
            </h6>
        </div>
        <div class="card-body">
            <form method="GET" action="unpaid_fee_report.php">
                <div class="row">
                    <div class="col-md-4">
                        <label class="form-label">Class</label>
                        <select name="report_class" class="form-select">
                            <option value="">All Classes</option>
                            <?php foreach ($classes as $class): ?>
                                <option value="<?php echo $class['id']; ?>" 
                                    <?php echo (isset($_GET['report_class']) && $_GET['report_class'] == $class['id']) ? 'selected' : ''; ?>>
                                    <?php echo htmlspecialchars($class['name']); ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">Section</label>
                        <select name="report_section" class="form-select">
                            <option value="">All Sections</option>
                            <?php foreach ($sections as $section): ?>
                                <option value="<?php echo $section['id']; ?>" 
                                    <?php echo (isset($_GET['report_section']) && $_GET['report_section'] == $section['id']) ? 'selected' : ''; ?>>
                                    <?php echo htmlspecialchars($section['name']); ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="col-md-4 d-flex align-items-end">
                        <button type="submit" class="btn btn-primary me-2">
                            <i class="fas fa-filter me-2"></i>Apply Filter
                        </button>
                        <a href="unpaid_fee_report.php" class="btn btn-outline-secondary">
                            <i class="fas fa-redo me-2"></i>Reset
                        </a>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Print Section -->
    <div class="print-section">
        <!-- School Header for Print - Logo left side with landscape layout -->
        <!-- Yeh sirf print preview mein dikhega, screen par bilkul nahi -->
        <div class="school-header-print">
            <?php if ($school_logo): ?>
            <div class="school-logo-print">
                <img src="<?php echo $school_logo; ?>" alt="School Logo" onerror="this.style.display='none'">
            </div>
            <?php else: ?>
            <div class="school-logo-print" style="background: #f0f0f0; display: flex; align-items: center; justify-content: center;">
                <span style="font-size: 8px; text-align: center;">No Logo</span>
            </div>
            <?php endif; ?>
            <div class="school-info-print">
                <h2><?php echo htmlspecialchars($school_name); ?></h2>
                <h3><?php echo htmlspecialchars($school_address); ?></h3>
                <?php if (!empty($school_phone)): ?>
                    <h4>Phone: <?php echo htmlspecialchars($school_phone); ?></h4>
                <?php endif; ?>
                <h4>Fee Defaulters Detail <?php echo date('Y'); ?></h4>
            </div>
        </div>

        <!-- Class Info for Print -->
        <!-- Yeh bhi sirf print preview mein dikhega -->
        <div class="class-info-print">
            Class: <?php echo htmlspecialchars($selected_class_name); ?> | 
            Section: <?php echo htmlspecialchars($selected_section_name); ?> | 
            Total Students: <?php echo $total_students; ?> | 
            Total Amount: Rs. <?php echo number_format($overall_total, 2); ?>
        </div>

        <!-- Data Table Card -->
        <div class="card data-table-card">
            <div class="card-header py-3 d-flex justify-content-between align-items-center no-print">
                <h6 class="m-0 font-weight-bold text-primary">
                    <i class="fas fa-table me-2"></i>
                    Outstanding Fee Report
                </h6>
                <div>
                    <span class="badge badge-danger">Showing Only Outstanding Fees</span>
                    <span class="badge badge-info">Total: Rs. <?php echo number_format($overall_total, 2); ?></span>
                </div>
            </div>
            <div class="card-body">
                <?php if (!empty($students)): ?>
                <div class="table-responsive">
                    <table class="table table-bordered table-hover" width="100%" cellspacing="0">
                        <thead>
                            <tr>
                                <th width="30">SR#</th>
                                <th width="200">Student Name</th>
                                <?php foreach ($months as $month_name): ?>
                                    <th width="50" class="month-header"><?php echo $month_name; ?></th>
                                <?php endforeach; ?>
                                <th width="70" class="total-header">Total</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php 
                            $serial = $offset + 1;
                            foreach ($students as $student): 
                                $student_id = $student['student_id'];
                                $fees_data = $student_fees[$student_id] ?? ['monthly' => array_fill_keys(array_keys($months), 0), 'total' => 0];
                                $student_status = $student['student_status'] ?? 'active';
                                $status_display = $student_status === 'active' ? 'Active' : 'Dropped';
                            ?>
                            <tr>
                                <td class="text-center"><?php echo $serial++; ?></td>
                                <td class="text-center">
                                    <?php echo htmlspecialchars($student['first_name'] . ' ' . $student['last_name']); ?>
                                    <span class="student-status">(<?php echo $status_display; ?>)</span>
                                </td>
                                
                                <?php foreach (array_keys($months) as $month_num): 
                                    $amount = $fees_data['monthly'][$month_num] ?? 0;
                                ?>
                                <td class="text-center" class="amount-cell <?php echo ($amount > 0) ? 'amount-due' : ''; ?>">
                                    <?php if ($amount > 0): ?>
                                        <?php echo number_format($amount, 0); ?>
                                    <?php else: ?>
                                        -
                                    <?php endif; ?>
                                </td>
                                <?php endforeach; ?>
                                
                                <td class="text-center" class="amount-cell amount-due font-weight-bold">
                                    <?php if ($fees_data['total'] > 0): ?>
                                        <?php echo number_format($fees_data['total'], 0); ?>
                                    <?php else: ?>
                                        -
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                        <tfoot class="table-footer">
                            <tr>
                                <td class="text-center" colspan="2" class="font-weight-bold">
                                    Total of Class: <?php echo htmlspecialchars($selected_class_name); ?>
                                </td>
                                <?php foreach (array_keys($months) as $month_num): ?>
                                    <td class="text-center font-weight-bold">
                                        <?php if ($grand_totals[$month_num] > 0): ?>
                                            <?php echo number_format($grand_totals[$month_num], 0); ?>
                                        <?php else: ?>
                                            -
                                        <?php endif; ?>
                                    </td>
                                <?php endforeach; ?>
                                <td class="text-center font-weight-bold">
                                    <?php echo number_format($overall_total, 0); ?>
                                </td>
                            </tr>
                            <tr>
                                <td colspan="<?php echo count($months) + 3; ?>" class="text-right font-weight-bold">
                                    <?php echo $total_students; ?> Students | Total: Rs. <?php echo number_format($overall_total, 2); ?>
                                </td>
                            </tr>
                        </tfoot>
                    </table>
                </div>

                <!-- Pagination -->
                <?php if ($total_pages > 1): ?>
                <nav aria-label="Page navigation" class="no-print">
                    <ul class="pagination">
                        <?php if ($page > 1): ?>
                            <li class="page-item">
                                <a class="page-link" href="?<?php echo http_build_query(array_merge($_GET, ['page' => $page - 1])); ?>" aria-label="Previous">
                                    <span aria-hidden="true">&laquo;</span>
                                </a>
                            </li>
                        <?php endif; ?>

                        <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                            <li class="page-item <?php echo ($i == $page) ? 'active' : ''; ?>">
                                <a class="page-link" href="?<?php echo http_build_query(array_merge($_GET, ['page' => $i])); ?>">
                                    <?php echo $i; ?>
                                </a>
                            </li>
                        <?php endfor; ?>

                        <?php if ($page < $total_pages): ?>
                            <li class="page-item">
                                <a class="page-link" href="?<?php echo http_build_query(array_merge($_GET, ['page' => $page + 1])); ?>" aria-label="Next">
                                    <span aria-hidden="true">&raquo;</span>
                                </a>
                            </li>
                        <?php endif; ?>
                    </ul>
                </nav>
                <?php endif; ?>

                <?php else: ?>
                    <div class="empty-state">
                        <i class="fas fa-check-circle fa-3x text-success mb-3"></i>
                        <h4 class="text-success">No Outstanding Fees Found!</h4>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <!-- Export Options -->
    <?php if (!empty($students)): ?>
    <div class="row mt-4 no-print">
        <div class="col-md-12 text-center">
            <div class="btn-group">
                <button class="btn btn-outline-primary" onclick="window.print()">
                    <i class="fas fa-print me-2"></i> Print Report
                </button>
                <button class="btn btn-outline-success">
                    <i class="fas fa-file-excel me-2"></i> Export Excel
                </button>
                <button class="btn btn-outline-danger">
                    <i class="fas fa-file-pdf me-2"></i> Export PDF
                </button>
            </div>
        </div>
    </div>
    <?php endif; ?>
</div>

<script>
// Print functionality
function printReport() {
    window.print();
}

// Auto-submit form when filters change (optional)
document.addEventListener('DOMContentLoaded', function() {
    // Add any JavaScript functionality here if needed
});
</script>

<?php
include_once('includes/footer.php'); 
?>