<?php
include_once('includes/header.php'); 
include_once('includes/sidebar.php'); 

// Check if user is Admin (role_id = 1) - Security
if ($_SESSION['user_role_id'] != 1) {
    header('Location: dashboard.php?err=' . urlencode('Aapke paas is page ka access nahi hai.'));
    exit;
}

$conn = getDBConnection();
$message = $_GET['msg'] ?? '';
$error = $_GET['err'] ?? '';

// --- Data Fetching ---
$roles_result = $conn->query("SELECT id, name FROM user_roles ORDER BY id ASC");
$roles = $roles_result->fetch_all(MYSQLI_ASSOC);

// Teachers jo abhi tak user nahi bane hain
$teachers_result = $conn->query("SELECT id, name FROM teachers WHERE status='active' AND id NOT IN (SELECT teacher_id FROM users WHERE teacher_id IS NOT NULL)");
$available_teachers = $teachers_result->fetch_all(MYSQLI_ASSOC);

// All Users
$users_query = "
    SELECT u.id, u.username, ur.name AS role_name, t.name AS teacher_name, u.status 
    FROM users u
    JOIN user_roles ur ON u.role_id = ur.id
    LEFT JOIN teachers t ON u.teacher_id = t.id
    ORDER BY u.id ASC
";
$users_result = $conn->query($users_query);
$users = $users_result->fetch_all(MYSQLI_ASSOC);

$conn->close();
?>

<h1 class="mb-4">User & Security Management 🛡️</h1>

<?php if ($message): ?>
    <div class="alert alert-success"><?php echo htmlspecialchars($message); ?></div>
<?php endif; ?>
<?php if ($error): ?>
    <div class="alert alert-danger"><?php echo htmlspecialchars($error); ?></div>
<?php endif; ?>

<div class="row">
    <div class="col-md-5">
        <div class="card p-3 mb-4">
            <h5 class="card-title">Add New User / Staff Login</h5>
            <form action="system_process.php" method="POST">
                <input type="hidden" name="action" value="add_user">
                
                <div class="form-group">
                    <label>Username (Login ID):</label>
                    <input type="text" name="username" class="form-control" required>
                </div>
                <div class="form-group">
                    <label>Password:</label>
                    <input type="password" name="password" class="form-control" required>
                </div>
                <div class="form-group">
                    <label>User Role:</label>
                    <select name="role_id" class="form-control" required>
                        <option value="">-- Select Role --</option>
                        <?php foreach ($roles as $role): ?>
                            <option value="<?php echo $role['id']; ?>"><?php echo htmlspecialchars($role['name']); ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="form-group">
                    <label>Link to Teacher/Staff (Optional for Teachers):</label>
                    <select name="teacher_id" class="form-control">
                        <option value="">-- None (For Admin/Other Staff) --</option>
                        <?php foreach ($available_teachers as $teacher): ?>
                            <option value="<?php echo $teacher['id']; ?>"><?php echo htmlspecialchars($teacher['name']); ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <button type="submit" class="btn btn-primary mt-2">Create User</button>
            </form>
        </div>
    </div>
    <div class="col-md-7">
        <h4 class="mb-3">Existing Users</h4>
        <div class="table-responsive">
            <table class="table table-bordered table-sm table-striped">
                <thead>
                    <tr><th>Username</th><th>Role</th><th>Linked Staff</th><th>Status</th><th>Actions</th></tr>
                </thead>
                <tbody>
                    <?php foreach ($users as $user): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($user['username']); ?></td>
                        <td><?php echo htmlspecialchars($user['role_name']); ?></td>
                        <td><?php echo htmlspecialchars($user['teacher_name'] ?? '-'); ?></td>
                        <td><span class="badge badge-<?php echo $user['status'] == 'active' ? 'success' : 'danger'; ?>"><?php echo ucfirst($user['status']); ?></span></td>
                        <td>
                            <a href="users.php?edit_id=<?php echo $user['id']; ?>" class="btn btn-sm btn-warning">Edit</a>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php
include_once('includes/footer.php'); 
?>