 <?php
// install/step2_admin.php

// Agar DB setup nahi hua, to wapas step 1 par bhej dein.
if (!file_exists(__DIR__ . '/../config/db.php')) {
    header('Location: step1_db.php?error=' . urlencode('Please complete DB configuration first.'));
    exit;
}
// Note: Installed flag yahan check nahi karna, kyunki yeh final step hai.
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Step 2: Admin & Institute Info</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <style>
        .container { max-width: 600px; margin-top: 50px; }
    </style>
</head>
<body>
    <div class="container">
        <h2 class="text-center mb-4">🏫 IMS Installer - Step 2/2</h2>
        <h4 class="text-center mb-4">Admin & Institute Details</h4>
        <form action="process.php" method="POST">
            <input type="hidden" name="step" value="admin_info">
            
            <hr>
            <h5>Admin Login Details</h5>
            <div class="form-group">
                <label for="admin_name">Admin Full Name:</label>
                <input type="text" class="form-control" id="admin_name" name="admin_name" required>
            </div>
            <div class="form-group">
                <label for="admin_email">Admin Email (Username):</label>
                <input type="email" class="form-control" id="admin_email" name="admin_email" required>
            </div>
            <div class="form-group">
                <label for="admin_password">Password:</label>
                <input type="password" class="form-control" id="admin_password" name="admin_password" required>
            </div>
            
            <hr>
            <h5>Institute Information (Printable)</h5>
            <div class="form-group">
                <label for="institute_name">Institute Name (Result Card/Voucher par aayega):</label>
                <input type="text" class="form-control" id="institute_name" name="institute_name" required>
            </div>
            <div class="form-group">
                <label for="institute_address">Address:</label>
                <textarea class="form-control" id="institute_address" name="institute_address" rows="2" required></textarea>
            </div>
            <div class="form-group">
                <label for="institute_phone">Phone/Contact No:</label>
                <input type="text" class="form-control" id="institute_phone" name="institute_phone">
            </div>
            
            <button type="submit" class="btn btn-success btn-block mt-4">Install & Finish</button>

            <?php if(isset($_GET['error'])): ?>
                <div class="alert alert-danger mt-3">
                    <strong>Error:</strong> <?php echo htmlspecialchars($_GET['error']); ?>
                </div>
            <?php endif; ?>

        </form>
    </div>
</body>
</html>