<?php
// FILE: login.php (Authentication and Role-based Redirection Logic)
ob_start(); // ✅ FIX: Output Buffering shuru kiya for header() redirection

session_start();
// Include DB connection
include_once('config/db.php');
$conn = getDBConnection();

$error = '';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $username = trim($_POST['username'] ?? '');
    $password = $_POST['password'] ?? '';

    if (empty($username) || empty($password)) {
        $error = "Please enter both username and password.";
    } else {
        // Prepare query to fetch user details including role_id and password hash
        $stmt = $conn->prepare("SELECT id, name, password_hash, role_id FROM users WHERE username = ? AND status = 'active'");
        $stmt->bind_param("s", $username);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows === 1) {
            $user = $result->fetch_assoc();

            // Password verification
            if (password_verify($password, $user['password_hash'])) { 
                
                // Login successful! Session variables set karein
                $_SESSION['user_id'] = $user['id'];
                $_SESSION['name'] = $user['name'];
                $_SESSION['role_id'] = $user['role_id'];
                
                // --------------------------------------------------------
                // 🛑 CORE LOGIC: ROLE-BASED REDIRECTION (Parent ID 5 Confirmed)
                // --------------------------------------------------------
                $role_id = (int)$user['role_id'];
                
                if ($role_id == 1) {
                    // Role 1: Admin
                    header("Location: admin/dashboard.php"); 
                    exit;
                } elseif ($role_id == 5) { 
                    // Role 5: Parent
                    header("Location: parent/dashboard.php"); // ✅ Redirection for Parent
                    exit;
                } elseif ($role_id == 3) {
                    // Role 3: Teacher
                    header("Location: teacher/dashboard.php");
                    exit;
                } else {
                    // Unknown Role
                    $error = "Your account role is invalid. Contact support.";
                    session_unset();
                    session_destroy();
                }
                
            } else {
                // Password wrong, ya password_verify() fail ho gaya
                $error = "Invalid username or password.";
            }
        } else {
            // Username nahi mila
            $error = "Invalid username or password.";
        }

        $stmt->close();
    }
}
$conn->close();
// Agar redirection nahi hua toh buffer ko yahan flush kar denge
ob_end_flush(); 
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <title>User Login</title>
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet" />
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css" rel="stylesheet" />
</head>
<body class="bg-primary">
    <div id="layoutAuthentication">
        <div id="layoutAuthentication_content">
            <main>
                <div class="container">
                    <div class="row justify-content-center">
                        <div class="col-lg-5">
                            <div class="card shadow-lg border-0 rounded-lg mt-5">
                                <div class="card-header"><h3 class="text-center font-weight-light my-4">Login</h3></div>
                                <div class="card-body">
                                    <?php if (!empty($error)): ?>
                                        <div class="alert alert-danger"><?php echo htmlspecialchars($error); ?></div>
                                    <?php endif; ?>
                                    <form method="POST" action="login.php">
                                        <div class="form-group">
                                            <label class="small mb-1" for="inputUsername">Username</label>
                                            <input class="form-control py-4" id="inputUsername" name="username" type="text" placeholder="Enter username" required />
                                        </div>
                                        <div class="form-group">
                                            <label class="small mb-1" for="inputPassword">Password</label>
                                            <input class="form-control py-4" id="inputPassword" name="password" type="password" placeholder="Enter password" required />
                                        </div>
                                        <div class="form-group d-flex align-items-center justify-content-between mt-4 mb-0">
                                            <button type="submit" class="btn btn-primary btn-block">Login</button>
                                        </div>
                                    </form>
                                </div>
                                <div class="card-footer text-center">
                                    <div class="small"><a href="#">Forgot Password?</a></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </main>
        </div>
        </div>
</body>
</html>