<?php
// FILE: parent/login.php (Parent Specific Login Page)
ob_start(); // Output Buffering Start for header() redirection

session_start();
// Zaroori: DB connection path '../config/db.php' use kiya gaya hai
include_once('../config/db.php');
$conn = getDBConnection();

$error = '';

// Agar user already logged in ho, aur Parent ho, toh seedha dashboard par bhej do
if (isset($_SESSION['user_id']) && ($_SESSION['role_id'] ?? 0) == 5) {
    header('Location: dashboard.php');
    exit;
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $username = trim($_POST['username'] ?? '');
    $password = $_POST['password'] ?? '';

    if (empty($username) || empty($password)) {
        $error = "Please enter both username and password.";
    } else {
        // Prepare query to fetch user details (Active status check zaroori hai)
        $stmt = $conn->prepare("SELECT id, name, password_hash, role_id FROM users WHERE username = ? AND status = 'active'");
        $stmt->bind_param("s", $username);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows === 1) {
            $user = $result->fetch_assoc();

            // Password verification
            if (password_verify($password, $user['password_hash'])) { 
                
                $role_id = (int)$user['role_id'];
                
                // 🛑 CORE LOGIC: Check for Parent Role ID (5)
                if ($role_id == 5) {
                    // Login successful! Session variables set karein
                    $_SESSION['user_id'] = $user['id'];
                    $_SESSION['name'] = $user['name'];
                    $_SESSION['role_id'] = $role_id;
                    
                    // Redirect to dashboard in the same folder
                    header("Location: dashboard.php"); 
                    ob_end_flush();
                    exit;
                } else {
                    // Agar login theek hai, lekin role ID 5 nahi hai
                    $error = "You do not have Parent access. Use the correct portal.";
                }
                
            } else {
                $error = "Invalid username or password.";
            }
        } else {
            $error = "Invalid username or password.";
        }

        $stmt->close();
    }
}
$conn->close();
ob_end_flush(); 
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <title>Parent Login</title>
    <link href="../../assets/css/styles.css" rel="stylesheet" /> 
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet" />
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css" rel="stylesheet" />
</head>
<body class="bg-info">
    <div id="layoutAuthentication">
        <div id="layoutAuthentication_content">
            <main>
                <div class="container">
                    <div class="row justify-content-center">
                        <div class="col-lg-5">
                            <div class="card shadow-lg border-0 rounded-lg mt-5">
                                <div class="card-header bg-primary text-white"><h3 class="text-center font-weight-light my-4">Parent Login</h3></div>
                                <div class="card-body">
                                    <?php if (!empty($error)): ?>
                                        <div class="alert alert-danger"><?php echo htmlspecialchars($error); ?></div>
                                    <?php endif; ?>
                                    <form method="POST" action="login.php">
                                        <div class="form-group">
                                            <label class="small mb-1" for="inputUsername">Username</label>
                                            <input class="form-control py-4" id="inputUsername" name="username" type="text" placeholder="Enter username" required />
                                        </div>
                                        <div class="form-group">
                                            <label class="small mb-1" for="inputPassword">Password</label>
                                            <input class="form-control py-4" id="inputPassword" name="password" type="password" placeholder="Enter password" required />
                                        </div>
                                        <div class="form-group d-flex align-items-center justify-content-between mt-4 mb-0">
                                            <button type="submit" class="btn btn-primary btn-block">Login as Parent</button>
                                        </div>
                                    </form>
                                </div>
                                <div class="card-footer text-center">
                                    <div class="small"><a href="../login.php">Admin/Teacher Login</a></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </main>
        </div>
        </div>
</body>
</html>