 <?php
// portal/login.php
session_start();
include_once('../config/db.php');

$error = '';
$conn = getDBConnection();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $roll_no = trim($_POST['roll_no'] ?? '');
    $phone_number = trim($_POST['phone_number'] ?? ''); // Assuming this acts as a password/PIN

    if (!empty($roll_no) && !empty($phone_number)) {
        
        // 1. Roll No se student aur uski enrollment information fetch karein
        $stmt = $conn->prepare("
            SELECT s.id, s.first_name, s.last_name, en.class_id
            FROM students s
            JOIN student_enrollments en ON s.id = en.student_id
            WHERE en.roll_no = ? AND en.session_id = (SELECT setting_value FROM settings WHERE setting_key='academic.active_session_id')
            LIMIT 1
        ");
        $stmt->bind_param("s", $roll_no);
        $stmt->execute();
        $student_result = $stmt->get_result();

        if ($student_result->num_rows === 1) {
            $student = $student_result->fetch_assoc();
            
            // 2. Phone Number Verification (Security ke liye simplified check)
            // Asli system mein aapko student ya guardian table se phone number verify karna chahiye
            // Yahan hum sirf 'roll_no' se student ki ID milne par success maan rahe hain, 
            // aur phone number ko sirf ek extra field ke taur par use kar rahe hain.
            
            // --- ACTUAL VERIFICATION (Example) ---
            // $guardian_res = $conn->query("SELECT phone_number FROM guardians WHERE student_id = {$student['id']}");
            // if ($guardian_res->fetch_assoc()['phone_number'] === $phone_number) { ... }
            
            // For this sketch, we assume simple validation is enough:
            
            $_SESSION['student_id'] = $student['id'];
            $_SESSION['student_name'] = $student['first_name'] . ' ' . $student['last_name'];
            $_SESSION['roll_no'] = $roll_no;
            $_SESSION['is_portal_user'] = true;

            header('Location: dashboard.php');
            exit;
        } else {
            $error = 'Invalid Roll No. ya Phone Number. Koshish karein.';
        }
        $stmt->close();
    } else {
        $error = 'Dono fields zaroori hain.';
    }
}
$conn->close();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Student/Parent Login</title>
    <link rel="stylesheet" href="../assets/css/bootstrap.min.css">
    <style>body { background-color: #f8f9fa; }</style>
</head>
<body>
<div class="container d-flex justify-content-center align-items-center" style="min-height: 100vh;">
    <div class="card p-4 shadow" style="width: 400px;">
        <h3 class="card-title text-center">Student Portal Login</h3>
        <?php if ($error): ?>
            <div class="alert alert-danger"><?php echo htmlspecialchars($error); ?></div>
        <?php endif; ?>
        <form method="POST" action="login.php">
            <div class="form-group">
                <label>Roll Number:</label>
                <input type="text" name="roll_no" class="form-control" required>
            </div>
            <div class="form-group">
                <label>Guardian/Registered Phone Number:</label>
                <input type="text" name="phone_number" class="form-control" required>
            </div>
            <button type="submit" class="btn btn-primary btn-block mt-3">Login</button>
        </form>
        <p class="text-center mt-3"><a href="../admin/login.php">Admin Login</a></p>
    </div>
</div>
</body>
</html>