 <?php
// admin/attendance_process.php
session_start();
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}
include_once('../config/db.php');
$conn = getDBConnection();

$action = $_POST['action'] ?? '';

// Function to handle redirection
function redirect($page, $msg = '', $type = 'success', $params = []) {
    $param_name = ($type === 'success') ? 'msg' : 'err';
    $url_params = http_build_query(array_merge($params, [$param_name => $msg]));
    header("Location: $page.php?$url_params");
    exit;
}

// ====================================================================
// ACTION: SAVE ATTENDANCE
// ====================================================================
if ($action === 'save_attendance' && $_SERVER['REQUEST_METHOD'] === 'POST') {
    
    $session_id = (int)($settings['academic.active_session_id'] ?? 0);
    $sheet_id = (int)($_POST['sheet_id'] ?? 0);
    $class_id = (int)($_POST['class_id'] ?? 0);
    $section_id = (int)($_POST['section_id'] ?? 0);
    $attendance_date = $_POST['attendance_date'] ?? date('Y-m-d');
    $statuses = $_POST['status'] ?? [];
    $notes = $_POST['note'] ?? [];
    $lock_sheet = isset($_POST['lock_sheet']) ? 1 : 0;
    $recorded_by_teacher_id = $_SESSION['user_id']; // For simplicity, using login user's ID

    if (empty($statuses) || $class_id === 0 || $section_id === 0) {
        redirect('attendance', 'Zaruri maloomat adhoori hain.', 'danger', ['class_id' => $class_id, 'section_id' => $section_id, 'attendance_date' => $attendance_date]);
    }

    $conn->begin_transaction();
    
    try {
        // 1. Manage the Attendance Sheet (UPSERT)
        if ($sheet_id === 0) {
            // INSERT New Sheet
            $sheet_stmt = $conn->prepare("INSERT INTO daily_attendance_sheets 
                (session_id, class_id, section_id, attendance_date, recorded_by_teacher_id, is_locked) 
                VALUES (?, ?, ?, ?, ?, ?)");
            $sheet_stmt->bind_param("iiisii", $session_id, $class_id, $section_id, $attendance_date, $recorded_by_teacher_id, $lock_sheet);
            
            if (!$sheet_stmt->execute()) { throw new Exception("Error creating sheet: " . $sheet_stmt->error); }
            $sheet_id = $sheet_stmt->insert_id;
            $sheet_stmt->close();
        } else {
            // UPDATE Existing Sheet (Sirf lock status update hoga)
            $sheet_stmt = $conn->prepare("UPDATE daily_attendance_sheets SET is_locked = ? WHERE id = ?");
            $sheet_stmt->bind_param("ii", $lock_sheet, $sheet_id);
            
            if (!$sheet_stmt->execute()) { throw new Exception("Error updating sheet lock: " . $sheet_stmt->error); }
            $sheet_stmt->close();
            
            // Purane records delete kar dein taake naye records save ho sakein
            $conn->query("DELETE FROM daily_attendance_records WHERE sheet_id = {$sheet_id}");
            if ($conn->error) { throw new Exception("Error deleting old records: " . $conn->error); }
        }

        // 2. Insert Attendance Records
        $insert_count = 0;
        $record_stmt = $conn->prepare("INSERT INTO daily_attendance_records 
            (sheet_id, student_id, status, note) 
            VALUES (?, ?, ?, ?)");
            
        foreach ($statuses as $student_id => $status) {
            $student_id = (int)$student_id;
            $note = trim($notes[$student_id] ?? NULL);
            
            $record_stmt->bind_param("iiss", $sheet_id, $student_id, $status, $note);
            if (!$record_stmt->execute()) { throw new Exception("Error inserting record for student $student_id: " . $record_stmt->error); }
            $insert_count++;
        }
        $record_stmt->close();

        $conn->commit();
        redirect('attendance', "Attendance for $insert_count students successfully saved.", 'success', ['class_id' => $class_id, 'section_id' => $section_id, 'attendance_date' => $attendance_date]);

    } catch (Exception $e) {
        $conn->rollback();
        redirect('attendance', 'Attendance save nahi ho saki: ' . $e->getMessage(), 'danger', ['class_id' => $class_id, 'section_id' => $section_id, 'attendance_date' => $attendance_date]);
    }
} 
// ... (Other actions like delete/view reports here) ...
else {
    redirect('attendance', 'Invalid action.', 'danger');
}

$conn->close();
?>