<?php
// FILE: admin/award_list.php - Selection Page (FINAL CODE)
include_once('includes/header.php'); 
include_once('includes/sidebar.php'); 
include_once('../config/db.php');

$conn = getDBConnection();

// Fetch Active Exam
$active_exam_query = "SELECT id, name FROM exams WHERE status = 'active' LIMIT 1";
$active_exam_result = $conn->query($active_exam_query);
$active_exam = $active_exam_result->fetch_assoc();

// Fetch Class, Section, and Exam Term data for the dropdowns
$classes_result = $conn->query("SELECT id, name FROM academic_classes ORDER BY order_no ASC");
$classes = $classes_result->fetch_all(MYSQLI_ASSOC);

$sections_result = $conn->query("SELECT id, name FROM academic_sections ORDER BY name ASC");
$sections = $sections_result->fetch_all(MYSQLI_ASSOC);

// ADJUSTED: exam_terms ki jagah 'exams' table istemaal ho rahi hai
$terms_result = $conn->query("SELECT id, name FROM exams ORDER BY start_date DESC");
$terms = $terms_result->fetch_all(MYSQLI_ASSOC);

$conn->close();
?>

<h1 class="mb-4">Generate Award List Template (Manual Entry)</h1>

<div class="card mb-4">
    <div class="card-header">
        Select Criteria
    </div>
    <div class="card-body">
        <form action="award_list_generate.php" method="GET" target="_blank">
            
            <div class="row">
                <div class="form-group col-md-3">
                    <label for="class_id">Select Class:</label>
                    <select name="class_id" id="class_id" class="form-control" required>
                        <option value="">-- Select Class --</option>
                        <?php foreach ($classes as $class): ?>
                            <option value="<?php echo $class['id']; ?>"><?php echo htmlspecialchars($class['name']); ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="form-group col-md-3">
                    <label for="section_id">Select Section:</label>
                    <select name="section_id" id="section_id" class="form-control" required>
                        <option value="">-- Select Section --</option>
                        <?php foreach ($sections as $section): ?>
                            <option value="<?php echo $section['id']; ?>"><?php echo htmlspecialchars($section['name']); ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="form-group col-md-3">
                    <label for="term_id">Select Exam (Term):</label>
                    <?php if ($active_exam): ?>
                        <input type="hidden" name="term_id" value="<?php echo $active_exam['id']; ?>">
                        <select class="form-control" disabled>
                            <option value="<?php echo $active_exam['id']; ?>" selected>
                                <?php echo htmlspecialchars($active_exam['name']); ?> (Active)
                            </option>
                        </select>
                    <?php else: ?>
                        <select name="term_id" id="term_id" class="form-control" required>
                            <option value="">-- Select Exam --</option>
                            <?php foreach ($terms as $term): ?>
                                <option value="<?php echo $term['id']; ?>"><?php echo htmlspecialchars($term['name']); ?></option>
                            <?php endforeach; ?>
                        </select>
                    <?php endif; ?>
                </div>
                
                <div class="form-group col-md-3 align-self-end">
                    <button type="submit" class="btn btn-primary btn-block">Generate Award List</button>
                </div>
            </div>

        </form>
    </div>
</div>

<?php include_once('includes/footer.php'); ?>