<?php
session_start();
// Aapki database connection file ka path, agar zaroorat ho to badal dijiye.
include_once('../config/db.php'); 

// Simple redirection helper function
function redirect($page, $message, $type = 'success') {
    $param = ($type === 'success') ? 'msg' : 'err';
    // sections.php ke liye hi redirect karte hain
    header('Location: sections.php?' . $param . '=' . urlencode($message)); 
    exit;
}

$conn = getDBConnection();
$action = $_POST['action'] ?? $_GET['action'] ?? '';

if (empty($action)) {
    redirect('sections', 'Invalid action specified.', 'err'); // 🛑 INVALID ACTION FIX
}

// ====================================================================
// A. CLASSES MANAGEMENT ACTIONS (academic_classes)
// ====================================================================

// ACTION 1: ADD NEW CLASS
if ($action === 'add_class' && $_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name'] ?? '');
    $order_no = (int)($_POST['order_no'] ?? 0);
    $code = strtoupper(substr($name, 0, 3)); 

    if (empty($name)) {
        redirect('sections', 'Class Name cannot be empty.', 'err');
    }

    $stmt = $conn->prepare("INSERT INTO academic_classes (name, code, order_no) VALUES (?, ?, ?)");
    $stmt->bind_param("ssi", $name, $code, $order_no);

    if ($stmt->execute()) {
        redirect('sections', "Class '{$name}' successfully added.");
    } else {
        redirect('sections', "Error adding class: " . $conn->error, 'err');
    }
    $stmt->close();
}

// ACTION 2: UPDATE EXISTING CLASS (Called from edit_class.php)
elseif ($action === 'update_class' && $_SERVER['REQUEST_METHOD'] === 'POST') {
    $class_id = (int)$_POST['class_id'];
    $name = trim($_POST['name'] ?? '');
    $order_no = (int)($_POST['order_no'] ?? 0);

    if ($class_id <= 0 || empty($name)) {
        redirect('sections', 'Invalid Class ID or Name.', 'err');
    }

    $stmt = $conn->prepare("UPDATE academic_classes SET name = ?, order_no = ? WHERE id = ?");
    $stmt->bind_param("sii", $name, $order_no, $class_id);

    if ($stmt->execute()) {
        redirect('sections', "Class ID {$class_id} successfully updated.");
    } else {
        redirect('sections', "Error updating class: " . $conn->error, 'err');
    }
    $stmt->close();
}

// ACTION 3: DELETE CLASS
elseif ($action === 'delete_class' && $_SERVER['REQUEST_METHOD'] === 'GET') {
    $class_id = (int)($_GET['id'] ?? 0);

    if ($class_id <= 0) {
        redirect('sections', 'Invalid Class ID for deletion.', 'err');
    }

    // Check for assignments before deleting
    $check = $conn->query("SELECT id FROM class_sections WHERE class_id = {$class_id}");
    if ($check->num_rows > 0) {
        redirect('sections', 'This Class cannot be deleted as it has assigned sections. Remove them first.', 'err');
    }
    
    $stmt = $conn->prepare("DELETE FROM academic_classes WHERE id = ?");
    $stmt->bind_param("i", $class_id);

    if ($stmt->execute()) {
        redirect('sections', "Class ID {$class_id} successfully deleted.");
    } else {
        redirect('sections', "Error deleting class: " . $conn->error, 'err');
    }
    $stmt->close();
}

// ====================================================================
// B. SECTIONS MANAGEMENT ACTIONS (academic_sections)
// ====================================================================

// ACTION 4: ADD NEW SECTION
elseif ($action === 'add_section' && $_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name'] ?? '');

    if (empty($name)) {
        redirect('sections', 'Section Name cannot be empty.', 'err');
    }

    $stmt = $conn->prepare("INSERT INTO academic_sections (name) VALUES (?)");
    $stmt->bind_param("s", $name);

    if ($stmt->execute()) {
        redirect('sections', "Section '{$name}' successfully added.");
    } else {
        redirect('sections', "Error adding section: " . $conn->error, 'err');
    }
    $stmt->close();
}

// ACTION 5: UPDATE EXISTING SECTION (Called from edit_section.php)
elseif ($action === 'update_section' && $_SERVER['REQUEST_METHOD'] === 'POST') {
    $section_id = (int)$_POST['section_id'];
    $name = trim($_POST['name'] ?? '');

    if ($section_id <= 0 || empty($name)) {
        redirect('sections', 'Invalid Section ID or Name.', 'err');
    }

    $stmt = $conn->prepare("UPDATE academic_sections SET name = ? WHERE id = ?");
    $stmt->bind_param("si", $name, $section_id);

    if ($stmt->execute()) {
        redirect('sections', "Section ID {$section_id} successfully updated to '{$name}'.");
    } else {
        redirect('sections', "Error updating section: " . $conn->error, 'err');
    }
    $stmt->close();
}

// ACTION 6: DELETE SECTION
elseif ($action === 'delete_section' && $_SERVER['REQUEST_METHOD'] === 'GET') {
    $section_id = (int)($_GET['id'] ?? 0);

    if ($section_id <= 0) {
        redirect('sections', 'Invalid Section ID for deletion.', 'err');
    }

    // Check for assignments before deleting
    $check = $conn->query("SELECT id FROM class_sections WHERE section_id = {$section_id}");
    if ($check->num_rows > 0) {
        redirect('sections', 'This Section cannot be deleted as it is assigned to Classes. Remove assignments first.', 'err');
    }
    
    $stmt = $conn->prepare("DELETE FROM academic_sections WHERE id = ?");
    $stmt->bind_param("i", $section_id);

    if ($stmt->execute()) {
        redirect('sections', "Section ID {$section_id} successfully deleted.");
    } else {
        redirect('sections', "Error deleting section: " . $conn->error, 'err');
    }
    $stmt->close();
}


// ====================================================================
// C. ASSIGNMENT ACTIONS (class_sections)
// ====================================================================

// ACTION 7: ASSIGN SECTION TO CLASS
elseif ($action === 'assign_section' && $_SERVER['REQUEST_METHOD'] === 'POST') {
    $class_id = (int)($_POST['class_id'] ?? 0);
    $section_id = (int)($_POST['section_id'] ?? 0);
    $session_id = (int)($_POST['session_id'] ?? 0);
    $capacity = (int)($_POST['capacity'] ?? 0);
    
    if ($class_id <= 0 || $section_id <= 0 || $session_id <= 0) {
        redirect('sections', 'Assignment fields are missing.', 'err');
    }

    // Check for duplicates
    $check = $conn->query("SELECT id FROM class_sections WHERE class_id = {$class_id} AND section_id = {$section_id} AND session_id = {$session_id}");
    if ($check->num_rows > 0) {
        redirect('sections', 'This Class-Section combination is already assigned for this session.', 'err');
    }

    $stmt = $conn->prepare("INSERT INTO class_sections (class_id, section_id, session_id, capacity) VALUES (?, ?, ?, ?)");
    $stmt->bind_param("iiii", $class_id, $section_id, $session_id, $capacity);

    if ($stmt->execute()) {
        redirect('sections', "Class-Section successfully assigned.");
    } else {
        redirect('sections', "Error assigning Class-Section: " . $conn->error, 'err');
    }
    $stmt->close();
}

// ACTION 8: DELETE ASSIGNMENT
elseif ($action === 'delete_assignment' && $_SERVER['REQUEST_METHOD'] === 'GET') {
    $assignment_id = (int)($_GET['id'] ?? 0);

    if ($assignment_id <= 0) {
        redirect('sections', 'Invalid Assignment ID for deletion.', 'err');
    }

    $stmt = $conn->prepare("DELETE FROM class_sections WHERE id = ?");
    $stmt->bind_param("i", $assignment_id);

    if ($stmt->execute()) {
        redirect('sections', "Assignment successfully removed.");
    } else {
        redirect('sections', "Error removing assignment: " . $conn->error, 'err');
    }
    $stmt->close();
}

// FALLBACK for unknown actions
else {
    redirect('sections', 'Unknown action requested.', 'err');
}

$conn->close();
?>