<?php

// --- 1. Database Connection Details (REPLACE WITH YOUR ACTUAL DETAILS) ---
$servername = "localhost";
$username = "root"; // Your MySQL username
$password = ""; // Your MySQL password
$dbname = "ammo"; // Your database name (from the image)

// Create connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// --- 2. Check if the deletion confirmation was submitted ---
if (isset($_POST['confirm_delete'])) {

    // Start a transaction for safety (optional but good practice)
    $conn->begin_transaction();
    $success = true;

    try {
        // Query 1: Delete entries from the SECOND child table (fee_payments)
        $sql1 = "DELETE FROM `fee_payments`";
        if (!$conn->query($sql1)) {
            throw new Exception("Error deleting from fee_payments: " . $conn->error);
        }

        // Query 2: Delete entries from the FIRST child table (fee_invoice_items)
        $sql2 = "DELETE FROM `fee_invoice_items`";
        if (!$conn->query($sql2)) {
            throw new Exception("Error deleting from fee_invoice_items: " . $conn->error);
        }

        // Query 3: Delete entries from the PARENT table (fee_invoices)
        $sql3 = "DELETE FROM `fee_invoices`";
        if (!$conn->query($sql3)) {
            throw new Exception("Error deleting from fee_invoices: " . $conn->error);
        }

        // Commit the transaction if all queries were successful
        $conn->commit();
        $message = "✅ **Success!** All dummy entries have been deleted from `fee_payments`, `fee_invoice_items`, and `fee_invoices`.";
        $style = "success";

    } catch (Exception $e) {
        // Rollback the transaction if any query failed
        $conn->rollback();
        $message = "❌ **Error!** Deletion failed: " . $e->getMessage();
        $style = "danger";
    }

    // Close connection
    $conn->close();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Delete Dummy Entries</title>
    <style>
        body { font-family: Arial, sans-serif; padding: 20px; }
        .container { max-width: 600px; margin: 0 auto; border: 1px solid #ccc; padding: 20px; border-radius: 5px; }
        .danger { background-color: #fdd; border: 1px solid #f00; color: #333; padding: 10px; border-radius: 3px; }
        .success { background-color: #ddf; border: 1px solid #00f; color: #333; padding: 10px; border-radius: 3px; }
        h2 { border-bottom: 2px solid #eee; padding-bottom: 10px; }
        button { padding: 10px 20px; background-color: #d9534f; color: white; border: none; border-radius: 5px; cursor: pointer; }
    </style>
</head>
<body>
    <div class="container">
        <h2>Manual Dummy Entry Deletion</h2>

        <?php if (isset($message)): ?>
            <div class="<?= $style; ?>">
                <?= $message; ?>
            </div>
            <p><a href="delete_entries.php">Go Back</a></p>
        <?php else: ?>
            <div class="danger">
                <h3>⚠️ Warning: Permanent Deletion</h3>
                <p>Clicking the button below will permanently delete **ALL** entries from the following linked tables:</p>
                <ul>
                    <li>`fee_payments`</li>
                    <li>`fee_invoice_items`</li>
                    <li>`fee_invoices` (Your target table)</li>
                </ul>
                <p>This action **cannot be undone**.</p>
            </div>

            <form method="POST" action="">
                <input type="hidden" name="confirm_delete" value="1">
                <button type="submit" onclick="return confirm('Are you absolutely sure you want to delete ALL entries?');">
                    CONFIRM & DELETE ALL ENTRIES
                </button>
            </form>
        <?php endif; ?>
    </div>
</body>
</html>