<?php
// FILE: admin/edit_expense.php

session_start();
ob_start();
include_once('../config/db.php');

$conn = getDBConnection();

$expense_types = ['Salaries', 'Rent', 'Utilities', 'Maintenance', 'Supplies', 'Others'];
$message = '';
$expense_id = $_GET['id'] ?? null;
$expense_data = null;

// --- 1. FETCH EXPENSE DATA ---
if ($expense_id) {
    $stmt = $conn->prepare("SELECT id, date, expense_type, description, amount FROM other_expenses WHERE id = ?");
    if ($stmt) {
        $stmt->bind_param("i", $expense_id);
        $stmt->execute();
        $result = $stmt->get_result();
        $expense_data = $result->fetch_assoc();
        $stmt->close();

        if (!$expense_data) {
            $message = '<div class="alert alert-danger">Expense not found.</div>';
            $expense_id = null; // Agar ID nahi mili to form hide kar dein
        }
    } else {
        $message = '<div class="alert alert-danger">Database error during fetch: ' . $conn->error . '</div>';
        $expense_id = null;
    }
} else {
    $message = '<div class="alert alert-danger">No expense ID provided.</div>';
}

// --- 2. HANDLE FORM SUBMISSION (UPDATE) ---
if ($_SERVER['REQUEST_METHOD'] === 'POST' && $expense_id) {
    $date = $_POST['date'] ?? date('Y-m-d');
    $expense_type = $_POST['expense_type'] ?? '';
    $description = $_POST['description'] ?? '';
    $amount = $_POST['amount'] ?? 0;
    $id_to_update = $_POST['expense_id'] ?? null;

    // Validation
    if (empty($expense_type) || $amount <= 0 || empty($date) || $id_to_update != $expense_id) {
        $message = '<div class="alert alert-danger">Please fill all required fields correctly or ID mismatch.</div>';
    } else {
        $update_stmt = $conn->prepare("UPDATE other_expenses SET date = ?, expense_type = ?, description = ?, amount = ? WHERE id = ?");
        if ($update_stmt) {
            $update_stmt->bind_param("ssdsi", $date, $expense_type, $description, $amount, $id_to_update);
            if ($update_stmt->execute()) {
                $message = '<div class="alert alert-success">Expense updated successfully!</div>';
                
                // Update local data with new changes
                $expense_data['date'] = $date;
                $expense_data['expense_type'] = $expense_type;
                $expense_data['description'] = $description;
                $expense_data['amount'] = $amount;

            } else {
                $message = '<div class="alert alert-danger">Error executing update: ' . $update_stmt->error . '</div>';
            }
            $update_stmt->close();
        } else {
            $message = '<div class="alert alert-danger">Database error during update: ' . $conn->error . '</div>';
        }
    }
}


// Includes for Page Layout
include('includes/header.php'); 
include_once('includes/sidebar.php');
?>

<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <h1 class="m-0">✏️ Edit Extra Expense</h1>
        </div>
    </div>
    
    <section class="content">
        <div class="container-fluid">
            <?php echo $message; ?>
            
            <?php if ($expense_data): ?>
            <div class="card card-info">
                <div class="card-header">
                    <h3 class="card-title">Editing Expense ID: <?php echo htmlspecialchars($expense_data['id']); ?></h3>
                </div>
                <div class="card-body">
                    <form method="POST" action="edit_expense.php?id=<?php echo $expense_data['id']; ?>">
                        <input type="hidden" name="expense_id" value="<?php echo $expense_data['id']; ?>">
                        
                        <div class="row">
                            <div class="form-group col-md-4">
                                <label for="date">Date:</label>
                                <input type="date" name="date" id="date" class="form-control" value="<?php echo htmlspecialchars($expense_data['date']); ?>" required>
                            </div>
                            
                            <div class="form-group col-md-4">
                                <label for="expense_type">Expense Head:</label>
                                <select name="expense_type" id="expense_type" class="form-control" required>
                                    <option value="">-- Select Type --</option>
                                    <?php foreach ($expense_types as $type): ?>
                                        <option value="<?php echo $type; ?>" <?php echo ($type == $expense_data['expense_type']) ? 'selected' : ''; ?>>
                                            <?php echo htmlspecialchars($type); ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            
                            <div class="form-group col-md-4">
                                <label for="amount">Amount (PKR):</label>
                                <input type="number" name="amount" id="amount" class="form-control" step="0.01" value="<?php echo htmlspecialchars($expense_data['amount']); ?>" required>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="description">Description (Optional):</label>
                            <textarea name="description" id="description" class="form-control" rows="3"><?php echo htmlspecialchars($expense_data['description'] ?? ''); ?></textarea>
                        </div>
                        
                        <button type="submit" class="btn btn-success">Update Expense</button>
                        <a href="financial_summary_report.php" class="btn btn-secondary">Back to Report</a>
                    </form>
                </div>
            </div>
            <?php endif; ?>
            
        </div>
    </section>
</div>

<?php 
// Connection Closure 
if (isset($conn) && $conn instanceof mysqli) {
    //@$conn->close();
}

include_once('includes/footer.php'); 
ob_end_flush();
?>