 <?php
include_once('includes/header.php'); 
include_once('includes/sidebar.php'); 

$conn = getDBConnection();
$section_id = (int)($_GET['id'] ?? 0);

if ($section_id <= 0) {
    header('Location: sections.php?err=' . urlencode('Invalid Section ID.'));
    exit;
}

// Data Fetching: academic_sections table se data nikalna
$stmt = $conn->prepare("SELECT * FROM academic_sections WHERE id = ?");
$stmt->bind_param("i", $section_id);
$stmt->execute();
$result = $stmt->get_result();
$section = $result->fetch_assoc();

if (!$section) {
    header('Location: sections.php?err=' . urlencode('Section not found.'));
    exit;
}

$stmt->close();
$conn->close();
?>

<h1 class="mb-4">Edit Section: <?php echo htmlspecialchars($section['name']); ?></h1>

<div class="row">
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                Update Section Details
            </div>
            <div class="card-body">
                <form action="classes_process.php" method="POST">
                    <input type="hidden" name="action" value="update_section">
                    <input type="hidden" name="section_id" value="<?php echo $section['id']; ?>">
                    
                    <div class="form-group">
                        <label>Section Name (e.g., A, B, Morning):</label>
                        <input type="text" name="name" class="form-control" value="<?php echo htmlspecialchars($section['name']); ?>" required>
                    </div>
                    
                    <button type="submit" class="btn btn-primary">Save Changes</button>
                    <a href="sections.php" class="btn btn-secondary">Cancel / Go Back</a>
                </form>
            </div>
        </div>
    </div>
</div>

<?php
include_once('includes/footer.php'); 
?>