 <?php
// FILE: admin/edit_slc.php - Edit School Leaving Certificate Details

session_start();
ob_start();
include_once('../config/db.php');
include_once('includes/header.php'); 
$conn = getDBConnection();

$slc_id = (int) ($_REQUEST['slc_id'] ?? 0);
$slc_data = null;
$message = '';
$error = '';

if ($slc_id <= 0) {
    die("<div class='alert alert-danger'>Invalid Certificate ID.</div>");
}

// --- Handle Update (POST) ---
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['update_slc'])) {
    $leaving_reason = trim($_POST['leaving_reason'] ?? '');
    $character_remark = trim($_POST['character_remark'] ?? '');

    $update_stmt = $conn->prepare("UPDATE school_leaving_certificates SET leaving_reason = ?, character_remark = ?, is_edited = 1 WHERE id = ?");
    $update_stmt->bind_param("ssi", $leaving_reason, $character_remark, $slc_id);
    if ($update_stmt->execute()) {
        $message = "Success: Certificate details updated and marked as edited!";
    } else {
        $error = "Error updating certificate: " . $conn->error;
    }
    $update_stmt->close();
}

// --- Fetch Current Data ---
$query = "
    SELECT 
        slc.*, 
        s.first_name, s.last_name, s.father_name, s.dob, 
        ac.name as leaving_class_name
    FROM school_leaving_certificates slc
    JOIN students s ON slc.student_id = s.id
    JOIN academic_classes ac ON slc.leaving_class_id = ac.id
    WHERE slc.id = ?
";
$stmt = $conn->prepare($query);
$stmt->bind_param("i", $slc_id);
$stmt->execute();
$slc_data = $stmt->get_result()->fetch_assoc();
$stmt->close();

if (!$slc_data) {
    die("<div class='alert alert-danger'>Certificate data not found.</div>");
}

$student_name = htmlspecialchars($slc_data['first_name'] . ' ' . $slc_data['last_name']);
?>

<h1 class="mb-4">Edit School Leaving Certificate <i class="fas fa-edit"></i></h1>

<?php if ($message): ?>
    <div class="alert alert-success"><?php echo $message; ?></div>
<?php endif; ?>
<?php if ($error): ?>
    <div class="alert alert-danger"><?php echo $error; ?></div>
<?php endif; ?>

<div class="card p-4 shadow-sm">
    <h5 class="card-title">Editing Certificate ID: <?php echo $slc_data['id']; ?></h5>
    <p><strong>Student:</strong> <?php echo $student_name; ?></p>
    <p><strong>Leaving Class:</strong> <?php echo htmlspecialchars($slc_data['leaving_class_name']); ?></p>

    <form method="POST" action="edit_slc.php?slc_id=<?php echo $slc_id; ?>">
        
        <div class="form-group">
            <label for="leaving_reason">Reason for Leaving:</label>
            <textarea name="leaving_reason" id="leaving_reason" class="form-control" rows="3" placeholder="Enter reason for leaving school (e.g., Transfer to another city, Joined family business)"><?php echo htmlspecialchars($slc_data['leaving_reason'] ?? ''); ?></textarea>
        </div>
        
        <div class="form-group">
            <label for="character_remark">Character/Conduct Remark:</label>
            <input type="text" name="character_remark" id="character_remark" class="form-control" value="<?php echo htmlspecialchars($slc_data['character_remark'] ?? 'Good'); ?>" placeholder="Enter a brief remark on conduct (e.g., Good, Excellent)">
        </div>
        
        <button type="submit" name="update_slc" class="btn btn-primary"><i class="fas fa-save"></i> Save Changes</button>
        <a href="generate_slc.php" class="btn btn-secondary"><i class="fas fa-arrow-left"></i> Back to List</a>
        <a href="slc_template.php?slc_id=<?php echo $slc_id; ?>" target="_blank" class="btn btn-success float-right"><i class="fas fa-print"></i> View/Print</a>

    </form>
</div>

<?php
if (isset($conn) && is_object($conn)) {
    $conn->close();
}
include_once('includes/footer.php');
ob_end_flush();
?>