 <?php
include_once('includes/header.php'); 
include_once('includes/sidebar.php'); 

$conn = getDBConnection();
$message = $_GET['msg'] ?? '';
$error = $_GET['err'] ?? '';

// --- Data Fetching ---
$current_session_id = $settings['academic.active_session_id'];

// 1. Fetch Exams
$exams_result = $conn->query("SELECT * FROM exams WHERE session_id = {$current_session_id} ORDER BY start_date DESC");
$exams = $exams_result->fetch_all(MYSQLI_ASSOC);
$exam_id_to_edit = $_GET['exam_id'] ?? null;

// 2. Fetch Classes and Subjects for structure setting
$classes_result = $conn->query("SELECT id, name, order_no FROM academic_classes ORDER BY order_no ASC");
$classes = $classes_result->fetch_all(MYSQLI_ASSOC);
$subjects_result = $conn->query("SELECT id, name FROM subjects ORDER BY name ASC");
$subjects = $subjects_result->fetch_all(MYSQLI_ASSOC);

$conn->close();
?>

<h1 class="mb-4">Exams & Class Structure</h1>

<?php if ($message): ?>
    <div class="alert alert-success"><?php echo htmlspecialchars($message); ?></div>
<?php endif; ?>
<?php if ($error): ?>
    <div class="alert alert-danger"><?php echo htmlspecialchars($error); ?></div>
<?php endif; ?>

<ul class="nav nav-tabs" id="examsTab" role="tablist">
    <li class="nav-item">
        <a class="nav-link active" data-toggle="tab" href="#manage">1. Manage Exams</a>
    </li>
    <li class="nav-item">
        <a class="nav-link" data-toggle="tab" href="#structure_set">2. Set Class Structure</a>
    </li>
</ul>

<div class="tab-content mt-3">
    <div class="tab-pane fade show active" id="manage" role="tabpanel">
        <div class="row">
            <div class="col-md-5">
                <h4>Define New Exam</h4>
                <form action="exams_process.php" method="POST">
                    <input type="hidden" name="action" value="add_exam">
                    <input type="hidden" name="session_id" value="<?php echo $current_session_id; ?>">
                    
                    <div class="form-group">
                        <label>Exam Name (e.g., Mid Term, Annual Exam):</label>
                        <input type="text" name="name" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>Exam Type:</label>
                        <select name="type" class="form-control">
                            <option value="term">Term Exam</option>
                            <option value="final">Final/Annual Exam</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label>Start Date:</label>
                        <input type="date" name="start_date" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>End Date:</label>
                        <input type="date" name="end_date" class="form-control" required>
                    </div>
                    <button type="submit" class="btn btn-primary">Save Exam</button>
                </form>
            </div>
            <div class="col-md-7">
                <h4>Exams List (Current Session)</h4>
                <table class="table table-bordered table-sm table-striped">
                    <thead>
                        <tr><th>Name</th><th>Type</th><th>Dates</th><th>Status</th><th>Actions</th></tr>
                    </thead>
                    <tbody>
                        <?php foreach ($exams as $exam): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($exam['name']); ?></td>
                            <td><?php echo ucfirst($exam['type']); ?></td>
                            <td><?php echo htmlspecialchars($exam['start_date']) . ' to ' . htmlspecialchars($exam['end_date']); ?></td>
                            <td><span class="badge badge-<?php echo $exam['status'] == 'active' ? 'success' : 'secondary'; ?>"><?php echo ucfirst($exam['status']); ?></span></td>
                            <td>
                                <a href="exams.php?exam_id=<?php echo $exam['id']; ?>#structure_set" class="btn btn-sm btn-info">Set Structure</a>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    
    <div class="tab-pane fade" id="structure_set" role="tabpanel">
        <?php if ($exams): ?>
            <h4>Set Subject Marks Structure for Exam</h4>
            <form method="GET" action="exams.php" class="form-inline mb-4">
                <label class="mr-2">Select Exam:</label>
                <select name="exam_id" class="form-control mr-3" onchange="this.form.submit()">
                    <option value="">-- Select Exam to Configure --</option>
                    <?php foreach ($exams as $exam): ?>
                        <option value="<?php echo $exam['id']; ?>" <?php echo $exam_id_to_edit == $exam['id'] ? 'selected' : ''; ?>>
                            <?php echo htmlspecialchars($exam['name']); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
                <input type="hidden" name="tab" value="structure_set">
            </form>

            <?php if ($exam_id_to_edit): 
                // Selected Exam aur uski current structure fetch karte hain
                $conn = getDBConnection();
                $structure_query = "SELECT class_id, subject_id, total_marks, passing_marks FROM class_exam_structure WHERE exam_id = " . (int)$exam_id_to_edit;
                $structure_result = $conn->query($structure_query);
                $current_structure = [];
                while($row = $structure_result->fetch_assoc()) {
                    $current_structure[$row['class_id']][$row['subject_id']] = $row;
                }
                $conn->close();

                $selected_exam_name = array_filter($exams, fn($e) => $e['id'] == $exam_id_to_edit);
                $selected_exam_name = $selected_exam_name[array_key_first($selected_exam_name)]['name'] ?? 'Selected Exam';
            ?>
                
                <h5 class="mt-3">Structure for: **<?php echo htmlspecialchars($selected_exam_name); ?>**</h5>
                <form action="exams_process.php" method="POST">
                    <input type="hidden" name="action" value="set_exam_structure">
                    <input type="hidden" name="exam_id" value="<?php echo $exam_id_to_edit; ?>">
                    
                    <p class="text-info">Har subject ke Total aur Passing Marks enter karein. Jo subject khali chhorenge, woh exam structure se nikal diya jayega.</p>
                    
                    <div class="table-responsive">
                    <table class="table table-bordered table-sm">
                        <thead>
                            <tr>
                                <th>Class</th>
                                <?php foreach ($subjects as $subject): ?>
                                    <th colspan="2" class="text-center"><?php echo htmlspecialchars($subject['name']); ?></th>
                                <?php endforeach; ?>
                            </tr>
                            <tr>
                                <th></th>
                                <?php foreach ($subjects as $subject): ?>
                                    <th class="text-center">Total</th>
                                    <th class="text-center">Pass</th>
                                <?php endforeach; ?>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($classes as $class): ?>
                            <tr>
                                <td>**<?php echo htmlspecialchars($class['name']); ?>**</td>
                                <?php foreach ($subjects as $subject): 
                                    $s = $current_structure[$class['id']][$subject['id']] ?? ['total_marks' => '', 'passing_marks' => ''];
                                ?>
                                <td>
                                    <input type="number" name="total[<?php echo $class['id']; ?>][<?php echo $subject['id']; ?>]" 
                                           class="form-control form-control-sm text-center" placeholder="Total" 
                                           value="<?php echo htmlspecialchars($s['total_marks']); ?>">
                                </td>
                                <td>
                                    <input type="number" name="pass[<?php echo $class['id']; ?>][<?php echo $subject['id']; ?>]" 
                                           class="form-control form-control-sm text-center" placeholder="Pass" 
                                           value="<?php echo htmlspecialchars($s['passing_marks']); ?>">
                                </td>
                                <?php endforeach; ?>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                    </div>
                    <button type="submit" class="btn btn-success mt-3">Save Exam Structure</button>
                </form>
            <?php endif; ?>
        <?php else: ?>
            <div class="alert alert-warning">Pehle koi Exam **Manage Exams** tab mein define karein.</div>
        <?php endif; ?>
    </div>
</div>

<?php
include_once('includes/footer.php'); 
?>