<?php
// admin/exam_structure.php - Define Max Marks and Passing Marks for an Exam/Class 
session_start();
include_once('../config/db.php');
include_once('includes/header.php'); 
include_once('includes/sidebar.php'); 

$conn = getDBConnection();

// --- Input Variables ---
$selected_exam_id = (int)($_GET['exam_id'] ?? 0);
$selected_class_id = (int)($_GET['class_id'] ?? 0);
$current_session_id = $settings['academic.active_session_id'] ?? 1;

// Get active exam
$active_exam_query = "SELECT id, name FROM exams WHERE status = 'active' LIMIT 1";
$active_exam_result = $conn->query($active_exam_query);
$active_exam = $active_exam_result->fetch_assoc();

// If no exam is selected but active exam exists, use active exam
if (!$selected_exam_id && $active_exam) {
    $selected_exam_id = $active_exam['id'];
}

$subjects_data = [];
$class_name = '';
$exam_name = '';

if ($selected_exam_id && $selected_class_id) {
    // Get allocated subjects, along with existing structure data
    $subjects_query = "
        SELECT 
            s.id AS subject_id, 
            s.name AS subject_name,
            ac.name AS class_name,
            ex.name AS exam_name,
            ces.total_marks,      
            ces.passing_marks        
        FROM course_allocation ca
        JOIN subjects s ON ca.subject_id = s.id
        LEFT JOIN class_exam_structure ces 
            ON ces.subject_id = s.id AND ces.class_id = ca.class_id AND ces.exam_id = ?
        JOIN academic_classes ac ON ca.class_id = ac.id
        JOIN exams ex ON ex.id = ?
        WHERE ca.class_id = ? AND ca.session_id = ?
        ORDER BY s.name ASC
    ";
    $subjects_stmt = $conn->prepare($subjects_query); 
    $subjects_stmt->bind_param("iiii", $selected_exam_id, $selected_exam_id, $selected_class_id, $current_session_id); 
    $subjects_stmt->execute();
    $result = $subjects_stmt->get_result();
    $subjects_data = $result->fetch_all(MYSQLI_ASSOC);
    $subjects_stmt->close();
    
    if (!empty($subjects_data)) {
        // Class/Exam names sirf display ke liye
        $class_name = $subjects_data[0]['class_name'] ?? '';
        $exam_name = $subjects_data[0]['exam_name'] ?? '';
    }
}

// Fetch all Exams and Classes for dropdowns
$exams = $conn->query("SELECT id, name FROM exams ORDER BY id ASC")->fetch_all(MYSQLI_ASSOC);
$classes = $conn->query("SELECT id, name FROM academic_classes ORDER BY id ASC")->fetch_all(MYSQLI_ASSOC);

// Error/Message handling
$message = $_GET['msg'] ?? '';
$error = $_GET['err'] ?? '';

$conn->close();
?>

<h1 class="mb-4">Define Exam Structure (Max/Passing Marks) <i class="fas fa-book-reader"></i></h1>

<?php if ($message): ?>
    <div class="alert alert-success"><?php echo htmlspecialchars($message); ?></div>
<?php endif; ?>
<?php if ($error): ?>
    <div class="alert alert-danger"><?php echo htmlspecialchars($error); ?></div>
<?php endif; ?>

<div class="card p-4 mb-4 shadow-sm">
    <form action="exam_structure.php" method="GET">
        <div class="row">
            <div class="col-md-4">
                <label for="exam_id">Select Exam:</label>
                <?php if ($active_exam): ?>
                    <input type="hidden" name="exam_id" value="<?php echo $active_exam['id']; ?>">
                    <select id="exam_id" class="form-control" disabled>
                        <option value="<?php echo $active_exam['id']; ?>" selected>
                            <?php echo htmlspecialchars($active_exam['name']); ?> (Active)
                        </option>
                    </select>
                    <small class="form-text text-muted">Currently active exam is automatically selected</small>
                <?php else: ?>
                    <select name="exam_id" id="exam_id" class="form-control" required>
                        <option value="">-- Select Exam --</option>
                        <?php foreach ($exams as $exam): ?>
                            <option value="<?php echo $exam['id']; ?>" <?php echo $selected_exam_id == $exam['id'] ? 'selected' : ''; ?>>
                                <?php echo htmlspecialchars($exam['name']); ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                    <div class="alert alert-warning mt-2">No active exam found. Please select an exam manually.</div>
                <?php endif; ?>
            </div>
            <div class="col-md-4">
                <label for="class_id">Select Class:</label>
                <select name="class_id" id="class_id" class="form-control" required>
                    <option value="">-- Select Class --</option>
                    <?php foreach ($classes as $class): ?>
                        <option value="<?php echo $class['id']; ?>" <?php echo $selected_class_id == $class['id'] ? 'selected' : ''; ?>>
                            <?php echo htmlspecialchars($class['name']); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="col-md-4 d-flex align-items-end">
                <button type="submit" class="btn btn-primary w-100">Load Subjects</button>
            </div>
        </div>
    </form>
</div>

<?php if ($selected_exam_id && $selected_class_id && !empty($subjects_data)): ?>
    <h3 class="mb-3">Structure for Class/Exam: 
        <span class="text-primary"><?php echo htmlspecialchars($class_name); ?></span> / 
        <span class="text-primary"><?php echo htmlspecialchars($exam_name); ?></span>
    </h3>

    <form action="exam_structure_process.php" method="POST">
        <input type="hidden" name="action" value="save_exam_structure">
        <input type="hidden" name="exam_id" value="<?php echo $selected_exam_id; ?>">
        <input type="hidden" name="class_id" value="<?php echo $selected_class_id; ?>">
        <input type="hidden" name="session_id" value="<?php echo $current_session_id; ?>">

        <div class="table-responsive">
            <table class="table table-bordered table-striped table-hover">
                <thead class="thead-dark">
                    <tr>
                        <th>Subject</th>
                        <th style="width: 150px;">Max Marks (Total)</th>
                        <th style="width: 150px;">Passing Marks</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($subjects_data as $subject): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($subject['subject_name']); ?></td>
                        <td>
                            <input type="number" 
                                name="subjects[<?php echo $subject['subject_id']; ?>][total]" 
                                class="form-control form-control-sm" 
                                value="<?php echo htmlspecialchars($subject['total_marks'] ?? ''); ?>" 
                                min="1" required>
                        </td>
                        <td>
                            <input type="number" 
                                name="subjects[<?php echo $subject['subject_id']; ?>][passing]" 
                                class="form-control form-control-sm" 
                                value="<?php echo htmlspecialchars($subject['passing_marks'] ?? ''); ?>" 
                                min="0" required>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
        <button type="submit" class="btn btn-success btn-lg mt-3"><i class="fas fa-save"></i> Save Exam Structure</button>
    </form>
<?php elseif ($selected_exam_id && $selected_class_id && empty($subjects_data)): ?>
    <div class="alert alert-warning">No subjects found allocated to this class for the current session.</div>
<?php endif; ?>

<?php
include_once('includes/footer.php'); 
?>